﻿<%@ page language="C#" validaterequest="false" masterpagefile="MyShop.master" enableeventvalidation="false" autoeventwireup="true" inherits="Shop_Manage_shop_product_category, mallz" title="商品分类" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<asp:ScriptManager ID="ScriptManager1" runat="server" EnablePartialRendering ="true" />
<div class="pageTitle">店铺商品分类管理</div>
    
<div class="tips_onclick"><p>给商品分类，方便买家浏览。（您只能添加 <%=allownum %> 个分类）</p>
</div>

<div>
  <asp:UpdatePanel ID="UpdatePanel1" runat="server">
      <ContentTemplate>
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="tableHead" DataSourceID="ProductLikeCategory"  DataKeyNames="ShopProductClassID" OnDataBound="GridView1_DataBound" >
          <Columns>
            <asp:TemplateField  HeaderText='编号' HeaderStyle-Width="4%">
               <EditItemTemplate>
                  <asp:Literal ID="ShopProductClassID" runat="server" Text='<%# Bind("ShopProductClassID") %>' />
               </EditItemTemplate>  
               <ItemTemplate>                
                  <asp:Literal ID="ShopProductClassID" runat="server" Text='<%# Bind("ShopProductClassID") %>' />             
               </ItemTemplate>           
            </asp:TemplateField>
            <asp:TemplateField  HeaderText="名称" ItemStyle-HorizontalAlign="Left">
               <EditItemTemplate>
                  <asp:TextBox ID="TxtShopProducClassName" runat="server" Text='<%# Bind("ShopProductClassName") %>' Width="80%"/>
               </EditItemTemplate>
               <ItemTemplate>
                 <asp:Literal ID="LShopProducClassNamen" runat="server" Text='<%# Eval("ShopProductClassName") %>' />
               </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="排列序号" DataField="orderby" HeaderStyle-Width="10%" />
            <asp:TemplateField HeaderText="操作" HeaderStyle-Width="20%">
                <ItemTemplate>
                    <asp:LinkButton ID="Edit1"  runat="server" Text="编辑" CommandName="Edit" CausesValidation="false"/> 
                    <asp:LinkButton ID="LinkButton1" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确定删除吗？')"/> 
                    <asp:HyperLink ID="aa" runat="server" Text="商品列表" NavigateUrl='<%# "Shop_ViewProductByShopProductClassID.aspx?ShopProductClassID=" + Eval("ShopProductClassID") %>' />
                </ItemTemplate>
                <EditItemTemplate>
                    <asp:LinkButton ID="Edit1" runat="server" Text="提交" CommandName="Update" CausesValidation="false"/> 
                    <asp:LinkButton ID="LinkButton2"  runat="server" Text="取消" CommandName="Cancel" CausesValidation="false"/> 
                </EditItemTemplate>
            </asp:TemplateField>
           </Columns>          
           <EmptyDataTemplate>
                 <table style="width:98%">
                 <tr>
                 <th>编号</th>
                 <th>名称</th>
                 <th>排列序号</th>
                 <th>操作</th>
                 </tr>
                 <tr><td colspan="6">没有符合查询条件的记录！</td></tr>
                 </table>
           </EmptyDataTemplate>
        </asp:GridView>  
        <br />
     </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="AddCategoryButton" EventName="Click" />
        </Triggers>
    </asp:UpdatePanel>
</div>

<div class="SearchTableStyle">

    <asp:UpdatePanel id="UpdatePanel2" runat="server">
        <contenttemplate>
    <span>
    <table cellpadding="0" cellspacing="0" border="0" width="100%">
        <tr>
            <td align="right">新分类名称：</td>
            <td><asp:TextBox ID="TxtClassName" runat="server" MaxLength="50" Width="300px"/>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtClassName"  ErrorMessage="不能空" /></td>
        </tr>
        <tr>
            <td align="right">排序：</td>
            <td><asp:TextBox ID="TxtOrderBy" runat="server" Width="40px"/>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtOrderBy"   ErrorMessage="不能空" />
        <asp:RangeValidator ID="RangeValidator1" runat="server" ControlToValidate="TxtOrderBy" ErrorMessage="必须为正整数" MaximumValue="9999" MinimumValue="1" Type="Integer"/>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td><asp:Button ID="AddCategoryButton" runat="server" Text=" 添 加 " OnClick="Button2_Click" /></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td>(注:分类名称限定50字以内,支持HTML代码)</td>
        </tr>
    </table>
    </span>
        </contenttemplate>
    </asp:UpdatePanel>
</div>

<div style="clear:both">
        
</div>

<asp:ObjectDataSource ID="ProductLikeCategory" runat="server" DeleteMethod="DeleteProductLikeCategory"
       InsertMethod="InsertProductLikeCategory" SelectMethod="GetProductLikeCategory"
       TypeName="MallZ.Data.Shop_ProductLikeCategory" UpdateMethod="UpdateProductLikeCategory" OldValuesParameterFormatString="{0}"
       OnUpdating="ProductLikeCategory_OnUpdating">
    <InsertParameters>
        <asp:Parameter Name="shopid" Type="Int32" />
        <asp:Parameter Name="ShopProductClassName" Type="String" />
        <asp:Parameter Name="orderby" Type="Int32" />
    </InsertParameters>
    <SelectParameters>
        <asp:Parameter   Name="ShopID" Type="Int32" />
    </SelectParameters>
    <DeleteParameters>
        <asp:Parameter Name="ShopProductClassID" Type="Int32" />
    </DeleteParameters>
    <UpdateParameters>
        <asp:Parameter Name="ShopProductClassName" Type="String" />
        <asp:Parameter Name="orderby" Type="Int32" />
        <asp:Parameter Name="ShopProductClassID" Type="Int32" />
    </UpdateParameters>
</asp:ObjectDataSource> 
</asp:Content>

