﻿<%@ page language="C#" masterpagefile="MyShopMasterPage.master" autoeventwireup="true" inherits="Shop_Member_Shop_PaymentType, mallz" title="付款方式管理" enableEventValidation="false" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<div class="pageTitle">付款方式管理</div>
    <asp:ScriptManager id="ScriptManager1" runat="server"></asp:ScriptManager>

    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" style="margin:10px 0 10px 0;" CssClass="tableHead" DataKeyNames="TypeID" OnDataBound="GridView1_DataBound" OnRowDeleting="GridView1_RowDeleting" OnRowEditing="GridView1_RowEditing"  align="center">
        <Columns>
            <asp:BoundField DataField="Typeid" HeaderText="编号" ReadOnly="True" HeaderStyle-Width="4%"/>
            <asp:BoundField DataField="TypeName" HeaderText="名称" />
            <asp:BoundField DataField="DisCount" HeaderText="折扣" DataFormatString="{0}%" HeaderStyle-Width="6%"/>
            <asp:CheckBoxField DataField="isdisabled" HeaderText="禁用" Text="是" HeaderStyle-Width="6%" />
            <asp:CheckBoxField DataField="isdefault" HeaderText="默认" Text="是" ReadOnly="True" HeaderStyle-Width="6%" />
            <asp:TemplateField HeaderText="描述" ItemStyle-Width="40%" ItemStyle-HorizontalAlign="Left">
                <ItemTemplate>
                    <div style="padding-left:3px;"><asp:Literal ID="txtIntro" runat="server" Text='<%# (Eval("Intro").ToString()).Replace("\n","<br/>") %>' /></div>
                </ItemTemplate>
            </asp:TemplateField>        
            <asp:TemplateField HeaderText="操作" HeaderStyle-Width="15%">
                <ItemTemplate>
                    <asp:LinkButton ID="butSetDefault" runat="server" OnCommand="SetDefault_OnCommand" CausesValidation="false" CommandArgument='<%#Eval("Typeid") %>' Text="默认" />
                    <asp:LinkButton ID="LinkButton2" runat="server" OnCommand="SetDisabled_OnCommand" CausesValidation="false" CommandArgument='<%#Eval("Typeid") %>' Text="禁用" />
                    <asp:LinkButton ID="butedit" runat="server" Text="修改" CommandName="Edit" CausesValidation="false" />
                    <asp:LinkButton ID="LinkButton1" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"/>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <EmptyDataTemplate >                   
            <div style="padding:10px;">没有符合查询条件的记录！</div>
        </EmptyDataTemplate> 
    </asp:GridView>
    

 <table class="ShopOrderStyle">
   <caption id="paytype_title">新增付款方式信息</caption>
        <tr>
            <td class="OrderTitle" style="height: 9px">名称：</td>
            <td style="height: 9px">
                <asp:TextBox ID="TxtPayName" Width="400" runat="server" onblur="CheckInputCharNums(this,25);" />
                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtPayName"  ErrorMessage="名称不能空"/> (限定最多为25个中文字)
            </td>
        </tr>
         <tr>
            <td class="OrderTitle">支付属性：</td>
            <td>
                <asp:DropDownList id="DropPayAttribute" runat="server" AutoPostBack="True" OnSelectedIndexChanged="DropPayAttribute_SelectedIndexChanged">
                    <asp:ListItem Value="0">在线支付</asp:ListItem>
                    <asp:ListItem Enabled="False" Value="1">商城用户</asp:ListItem>
                    <asp:ListItem Value="2">线下支付</asp:ListItem>
                </asp:DropDownList>
<asp:UpdatePanel id="UpdatePanel1" runat="server" UpdateMode="Conditional" >
     <ContentTemplate>
                <div id="online_payTypeSelect" class="Content" runat="server">
                    <div class="div_row">
                        <div class="div_left">选择支付方式：</div>
                        <div class="div_right">
                            <asp:DropDownList id="ShopOnlinePaytype" DataSourceID="ObjectDataSource1" DataTextField="PayTitle"  DataValueField="SysStr"  runat="server" AppendDataBoundItems="True">
                                <asp:ListItem Text="选择在线通道" Value="" />
                            </asp:DropDownList>
                            <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" TypeName="MallZ.Data.OnlinePaySeting" SelectMethod="GetPayTypeFromLanguage"></asp:ObjectDataSource>
                        </div>
                    </div>
                    <div id="alipay_seller_email" class="div_row">
                        <div class="div_left">支付帐号：</div>
                        <div class="div_right">
                            <asp:TextBox id="OnlinePayEmail" runat="server" Width="150px"/> (选择支付宝时填写) 
                            <a href="https://www.alipay.com/" target="_blank">申请支付宝</a> <a onmouseover="showHelp('help4');" onmouseout="hidenHelp('help4');" href="#">&nbsp;<img src="/Images/Member/tooltip.png" border=0 /></a><br />
                        </div>
                    </div>
                    <div id="other_onlinepya_account" class="div_row">
                        <div class="div_left">商户号：</div>
                        <div class="div_right"><asp:TextBox id="Account" runat="server" Width="200px"/></div>
                    </div>
                    <div id="other_onlinepya_key" class="div_row">
                        <div class="div_left">商户密钥：</div>
                        <div class="div_right"><asp:TextBox id="Md5Code" runat="server" Width="200px" TextMode="Password"/>&nbsp;不修改请留空 </div>
                    </div>
                    <div class="div_row">
                        <div class="div_left">在线支付订单前缀：</div>
                        <div class="div_right"><asp:TextBox id="OnlinePayFlag" runat="server" Text="MZ_" MaxLength="4" /></div>
                    </div>
               </div>
               <div id="Div1" class="Content" runat="server">
                    <div style="DISPLAY: none" class="div_row">
                        <div class="div_left">线下支付类型：</div>
                        <div class="div_right">
                              <asp:DropDownList id="outLinePayType" runat="server">                                        
                                  <asp:ListItem Text="银行转帐/汇款" Value="1"  />
                                  <asp:ListItem Text="现金" Value="0" />
                                  <asp:ListItem Text="邮寄汇款" Value="4" />
                                  <asp:ListItem Text="上门收款" Value="5" />
                                  <asp:ListItem Text="支票" Value="6" />
                                  <asp:ListItem Text="其它" Value="7" />
                              </asp:DropDownList><span>（注：“银行转帐”方式请注意描述银行帐号信息）</span> 
                        </div>
                     </div>
                </div>
    </ContentTemplate>
    <Triggers>
        <asp:AsyncPostBackTrigger ControlID="DropPayAttribute" EventName="SelectedIndexChanged" />
    </Triggers>
</asp:UpdatePanel><asp:HiddenField ID="payTypeID" runat="server" />
            </td>
        </tr>
        <tr style="display:none;">
            <td class="OrderTitle">设定付款折扣：</td>
            <td><asp:TextBox ID="TxtDisCount" runat="server" Text="0" Width="30px" />%(请填写0-100范围内数字) <a href="#"  onmouseover="showHelp('help2');" onmouseout="hidenHelp('help2');" >&nbsp;<img src="/Images/Member/tooltip.png" border="0" /></a><br />
                <asp:RequiredFieldValidator ID="Rq2" runat="server" ErrorMessage="折扣不能空" ControlToValidate="TxtDisCount" Display="Dynamic"/>
                <asp:RangeValidator ID="Ra1" runat="server" ControlToValidate="TxtDisCount"  ErrorMessage="请填写0-100范围内数字" MaximumValue="100" MinimumValue="0" Type="Integer" Display="Dynamic" Width="141px"/>
            </td>
        </tr>
        <tr>
            <td class="OrderTitle">是否禁用：</td>
            <td><asp:CheckBox ID="ChDisable" runat="server" Text="禁用" /></td>
        </tr>
        <tr>
            <td class="OrderTitle">描述：</td>
            <td><asp:TextBox ID="TxtIntro" runat="server" TextMode="MultiLine" Height="60px" Width="433px" onblur="CheckInputCharNums(this,200);"/>(注:字数限制在200字以内)</td>
        </tr>
        <tr>
            <td class="OrderTitle">请输入登录密码：</td>
            <td><asp:TextBox ID="UserSavePass" runat="server"  TextMode="Password" /><a href="#"  onmouseover="showHelp('help3');" onmouseout="hidenHelp('help3');" >&nbsp;<img src="/Images/Member/tooltip.png" border="0" /></a><br />              
               <asp:RequiredFieldValidator ID="Rq4" runat="server" ErrorMessage="请输入安全密码" ControlToValidate="UserSavePass" Display="Dynamic"/>
            </td>
        </tr>
        <tr>
            <td colspan="2"><asp:Label ID="err_tips" runat="server" /></td>
        </tr>
        <tr>           
            <td colspan="2" style="text-align:center;">
                <asp:Button ID="OnLinePaySubmit" runat="server" OnClick="OnLinePaySubmit_Click" Text=" 提 交 " />
                <asp:Button ID="btnEdit" runat="server" Text=" 修 改 " Visible="False" OnClick="btnEdit_Click" />
            </td>
        </tr>
    </table>
    
    
     <div id="help2"   style="position:absolute;z-index:1000; border:solid 1px black; padding:10px; background:white; display:none;" onmouseover="this.style.display='block';" onmouseout="this.style.display='none'">
       你可以设置多个付款方式，设置优惠的付款折扣可以吸引买家在购买商品时采用该付款方式。    
   </div>
    <div id="help3"   style="position:absolute;z-index:1000; border:solid 1px black; padding:10px; background:white; display:none;" onmouseover="this.style.display='block';" onmouseout="this.style.display='none'">
       此密码为用户登陆密码！   
   </div>
   <div id="help4"   style="position:absolute;z-index:1000; border:solid 1px black; padding:10px; background:white; display:none;" onmouseover="this.style.display='block';" onmouseout="this.style.display='none'">
       商城已集成支付宝商家工具。只需填写支付宝帐号即可无须另外开通商家工具。   
   </div>
   
</asp:Content>

