﻿<%@ page language="C#" masterpagefile="MyShopMasterPage.master" autoeventwireup="true" inherits="Member_Shop_ProductInStock, mallz" title="仓库商品" enableEventValidation="false" %>
<%@ Import   Namespace="MallZ.Web.Shop"   %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <div class="pageTitle">仓库里的商品</div>

<table class="SearchTableStyle">
    <tr class="tdbg">
        <td class="tdbg5" style="width:40%;">商品名称：<asp:TextBox ID="TxtProductName" runat="server" Width="250" /> </td>
        <td class="tdbg5" style="width:15%;"><asp:DropDownList ID="ProductType" runat="server">
         <asp:ListItem Text="全部类型" Value="0" />
         <asp:ListItem Text="一口价" Value="1" />
         <asp:ListItem Text="拍卖" Value="2" />
         <asp:ListItem Text="团购" Value="3" />
      </asp:DropDownList></td>
        <td class="tdbg5"><asp:Button ID="Button1" runat="server" Text=" 查 询 " OnClick="Search_OnClick" /></td>
    </tr>
</table>
<br />
<div style="clear:both;"></div>  
    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" AllowPaging="True" PageSize="20" CssClass="tableHead" DataKeyNames="ProductID"  OnRowDataBound="GridView1_RowDataBound" Width="98%" EnableViewState="true"  OnRowEditing="GridView1_RowEditing">
        <Columns>
            <asp:TemplateField ItemStyle-Width="4%">
               <ItemTemplate>
                   <input id="productids" name="productids" value="<%#Eval("ProductID") %>" type="checkbox" title="<%# "ID："+Eval("ProductID") %>" />
               </ItemTemplate>
               <HeaderTemplate>
                   <input id="chkAll" onclick="SelectAllCheckboxes(this,'productids');" type="checkbox" />
               </HeaderTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="图片" HeaderStyle-Width="12%">
               <ItemTemplate>
                  <asp:HyperLink ID="ProductImgLink" runat="server" NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>'  Target="_blank"><asp:Image ID="Product_Image" Width="100" runat="server" ImageUrl='<%# Eval("ProductSmallImageUrl") %>' onerror="this.src='/Images/show_nopic.gif'" /></asp:HyperLink>
               </ItemTemplate>
             </asp:TemplateField>
              <asp:TemplateField HeaderText="商品名称" ItemStyle-HorizontalAlign="Left">
               <ItemTemplate>
                  <asp:HyperLink ID="ProductName" runat="server"  Text='<%# Eval("ProductName") %>'  NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>'  Target="_blank"/><br />
                  <asp:Label ID="ProductType" runat="server" Text='<%#TextFormat.GetProductType(Eval("ProductType").ToString())    %>'  ForeColor="orangered"/><br />
                  <asp:Literal runat="server" ID="s" Text='<%# "[ "+Eval("ClassName") +" ]" %>' />
               </ItemTemplate>
             </asp:TemplateField>
            <asp:TemplateField HeaderText="销售时间" HeaderStyle-Width="13%">
                <ItemTemplate>
                    <asp:Literal ID="LitBeginDate" runat="server" Text='<%#Eval("BeginDate") %>' /><br />
                    <asp:Literal ID="LitEndDate" runat="server" Text='<%# (Eval("NoLimitDate").ToString()=="1")?MallZ.Common.Language.Get("Shop/Product/AllValidDay"):Eval("EndDate") %>' />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="出价/浏览" HeaderStyle-Width="10%">                
                 <ItemTemplate>
                     <asp:Literal ID="Bid_Times_Or_Hits" runat="server" Text='<%#Eval("BuyTimes")+"/"+Eval("Hits") %>'/>
                 </ItemTemplate>
             </asp:TemplateField>
            <asp:TemplateField HeaderText="当前价格" ItemStyle-Width="7%" >
                <ItemTemplate>
                    <asp:Literal ID="litCurrentPrice" runat="server" Text='<%# Eval("CurrentPrice") %>' />
                </ItemTemplate>
             </asp:TemplateField>
            <asp:TemplateField HeaderStyle-Width="7%" HeaderText="库存" >
                <ItemTemplate>
                    <asp:Literal ID="LitStocks" runat="server" Text='<%#Eval("Stocks") %>' /><br />
                    <asp:LinkButton ID="es" runat="server" CommandName="Edit" Text="更改" />
                </ItemTemplate>
                <EditItemTemplate>
                     <asp:TextBox ID="TxtStocks" runat="server" Width="50" Text='<%#Eval("Stocks") %>'/><br />
                     <asp:LinkButton ID="es2" runat="server" CommandArgument='<%# Eval("ProductID") %>' OnCommand="UpdateStocks" Text="提交"  />
                     <asp:LinkButton ID="LinkButton1" runat="server" OnClientClick="history.back();return false;" Text="取消" />
                 </EditItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField  HeaderText="当前期" HeaderStyle-Width="7%">
                <ItemTemplate>
                    <asp:Literal ID="textCycle" runat="server" Text='<%#Eval("Cycle") %>' />
                </ItemTemplate>
             </asp:TemplateField>
            <asp:TemplateField HeaderText="操作" HeaderStyle-Width="7%">
                <ItemTemplate>
                    <asp:HyperLink runat="server" ID="butedit" NavigateUrl='<%# "../EditProduct.aspx?ProductID=" + Eval("ProductID") %>' Target="_blank" Text="编辑" />
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <EmptyDataTemplate>
        <table class="TableHeader" style="width:98%">
        <tr>
            <th>选择</th>
            <th>图片</th>
            <th>商品名称</th>
            <th>销售时间</th>
            <th>价格</th>
            <th>库存量</th>
            <th>编辑</th>
        </tr>
        <tr><td colspan="7">暂无任何商品</td></tr>
        </table>
        </EmptyDataTemplate>
        <PagerStyle CssClass="productPageStyle" />            
    </asp:GridView>

<div style="text-align:center;width:98%; margin-top:10px;">
     <asp:Button ID="OnSale_Button" runat="server" Text="商品上架"  CommandName="OnSale" OnCommand="StockPorityButton_Command" OnClientClick="return confirm('商品重新上架后，发布时间、购买次数等将回到初始状态，确定执行操作吗？')" />&nbsp;
     <asp:Button ID="btn_editProducts" runat="server" OnClick="btn_editProducts_Click" Text="批量修改" />
     <asp:Button ID="Delete_Button" runat="server" Text="批量删除" CommandName="Delete" OnCommand="Delete_Command"  OnClientClick="return confirm('确定将删除所选定的商品，确认吗？')"/></div>

<div style="margin:auto; width:95%; margin-top:10px;">
注：系统默认不删除有订单的商品！
</div>

  <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="GetInStockProductsBySalerID" TypeName="MallZ.Data.Shop_Product" OldValuesParameterFormatString="original_{0}">
      <SelectParameters>
      <asp:Parameter  Name="SalerID"  Type="Int32"/>
      <asp:Parameter DefaultValue="NotSoldAll" Name="Type" Type="String" />
      </SelectParameters>
  </asp:ObjectDataSource>
  
</asp:Content>

