﻿<%@ page language="C#" masterpagefile="MyShopMasterPage.master" autoeventwireup="true" inherits="Member_ShopProductSale, mallz" title="出售中的商品" enableEventValidation="false" %>
<%@ Register tagPrefix="MZ" TagName="TextFormat" Src="../UserControls/ProductTextFormat.ascx" %>
<%@ Import   Namespace="MallZ.Web.Shop"%>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <div class="pageTitle">出售中的商品</div>

 <table class="SearchTableStyle">
    <tr>
       <td style="width:40%;">&nbsp;&nbsp;商品名称：<asp:TextBox ID="ProductName" runat="server" Width="250"/></td>
       <td>
       <asp:DropDownList ID="IsShopElite" runat="server" AutoPostBack="true" OnSelectedIndexChanged="QucikSearch_Click">
             <asp:ListItem Selected="True" Value="" Text="所有商品"/>
             <asp:ListItem Value="1" Text="橱窗推荐"/>
             <asp:ListItem Value="0" Text="未 推 荐"/>
           </asp:DropDownList></td>
       <td><asp:DropDownList ID="ProductType" runat="server" AutoPostBack="true" OnSelectedIndexChanged="QucikSearch_Click">
         <asp:ListItem Text="商品类型" Value="" />
         <asp:ListItem Text="一口价" Value="1" />
         <asp:ListItem Text="拍卖" Value="2" />
         <asp:ListItem Text="团购" Value="3" />
      </asp:DropDownList></td>
       <td><asp:CheckBox ID="bid" runat="server" Text="有订单" AutoPostBack="true" OnCheckedChanged="QucikSearch_Click" /></td>
       <td><asp:DropDownList ID="show_type" runat="server" AutoPostBack="true" OnSelectedIndexChanged="QucikSearch_Click">
         <asp:ListItem Text="选择排序方式" Value="" Selected="True" />
         <asp:ListItem Text="上架时间从近到远" Value="1" />
         <asp:ListItem Text="上架时间从远到近" Value="2" />
         <asp:ListItem Text="价格从高到低" Value="3" />
         <asp:ListItem Text="价格从低到高" Value="4" />
         <asp:ListItem Text="浏览量从高到低" Value="5" />
         <asp:ListItem Text="浏览量从低到高" Value="6" />
         <asp:ListItem Text="剩余数量从高到低" Value="7" />
         <asp:ListItem Text="剩余数量从低到高" Value="8" />
      </asp:DropDownList></td>
       <td> <asp:Button ID="search" Text=" 查 询 " runat="server" OnClick="QucikSearch_Click"/></td>
    </tr>
 </table>
 <br />
 <div id="product_history">
     <asp:GridView ID="GridView1" runat="server" CssClass="tableHead" AutoGenerateColumns="False"  RowStyle-HorizontalAlign="Center" width="98%" AllowPaging="True" DataKeyNames="ProductID" AllowSorting="True" OnPageIndexChanging="GridView1_PageIndexChanging" OnRowEditing="GridView1_RowEditing" >
         <Columns>
             <asp:TemplateField HeaderText="选择" HeaderStyle-Width="4%">
                 <ItemTemplate>
                     <input type="checkbox" name="ids" id="ids" value="<%# Eval("ProductID") %>" title="<%# "ID："+Eval("ProductID") %>" />
                 </ItemTemplate>
                  <HeaderTemplate>
                     <input id="chkAll" onclick="SelectAllCheckboxes(this,'ids');" type="checkbox" />                    
                  </HeaderTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="图片" HeaderStyle-Width="12%">                   
                 <ItemTemplate>
                      <asp:HyperLink ID="ProductNameUrl2" runat="server" NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank"><asp:Image ID="Image1" Width="100" runat="server" ImageUrl='<%# Eval("ProductSmallImageUrl") %>' onerror="this.src='../Images/show_nopic.gif'" /></asp:HyperLink>
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="商品名称" ItemStyle-HorizontalAlign="Left">
                 <ItemTemplate>
                    <asp:HyperLink ID="ProductNameUrl" runat="server" Text='<%# Eval("ProductName") %>' NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank"/><br />
                    <asp:Label ID="ProductType" runat="server" Text='<%# TextFormat.GetProductType(Eval("ProductType").ToString())    %>'  ForeColor="orangered"/><br />
                    <asp:Literal runat="server" ID="s" Text='<%# "[ "+Eval("ClassName") +" ]" %>' />
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="当前价格" HeaderStyle-Width="10%">
                <ItemTemplate>
                    <asp:Literal ID="textCurrentPrice" runat="server" Text='<%#Eval("CurrentPrice") %>' />
                </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="剩余时间" HeaderStyle-Width="10%">
                 <ItemTemplate>
                     <MZ:TextFormat runat="server" ID="TextFormat0" Text="LeftTime" Value='<%# Eval("EndDate") + "|" + Eval("NoLimitDate")%>' />
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="出价/浏览" HeaderStyle-Width="10%">                
                 <ItemTemplate>
                     <asp:Literal ID="Bid_Times_Or_Hits" runat="server" Text='<%#Eval("BuyTimes")+"/"+Eval("Hits") %>'/>
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="库存" HeaderStyle-Width="7%">                
                 <ItemTemplate>
                     <asp:Literal ID="LitStocks" runat="server" Text='<%#Eval("Stocks") %>'/><br />
                     <asp:LinkButton ID="es" runat="server" CommandName="Edit" Text="更改" />
                 </ItemTemplate>
                 <EditItemTemplate>
                     <asp:TextBox ID="TxtStocks" runat="server" Width="50" Text='<%#Eval("Stocks") %>'/><br />
                     <asp:LinkButton ID="es2" runat="server" CommandArgument='<%# Eval("ProductID") %>' OnCommand="UpdateStocks" Text="提交"  />
                     <asp:LinkButton ID="LinkButton1" runat="server" OnClientClick="history.back();return false;" Text="取消" />
                 </EditItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="橱窗推荐" HeaderStyle-Width="7%" >
                <ItemTemplate>
                    <asp:Literal ID="IsShopElite" runat="server" Text='<%# (Eval("IsShopElite").ToString()=="True")?"是":"否" %>'  />
                </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField  HeaderText="当前期" HeaderStyle-Width="7%">
                <ItemTemplate>
                    <asp:Literal ID="textCycle" runat="server" Text='<%#Eval("Cycle") %>' />
                </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="操作" HeaderStyle-Width="7%">
                 <ItemTemplate>
                     <asp:HyperLink ID="editProduct" runat="server" Text="编辑" NavigateUrl='<%#"../EditProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank" />
                 </ItemTemplate>
             </asp:TemplateField>
         </Columns>
         <EmptyDataTemplate>
             <table style="width:98%">
             <tr>
             <th><input id="Checkbox1" type="checkbox" /></th>
             <th>图片</th>
             <th>商品名称</th>
             <th>当前价格</th>
             <th>剩余时间</th>
             <th>出价次数/浏览量</th>
             <th>库存</th>
             <th>操作</th>
             </tr>
             <tr><td colspan="8">没有出售中的商品！</td></tr>
             </table>
         </EmptyDataTemplate>
         <PagerStyle CssClass="productPageStyle" />              
     </asp:GridView>
 </div>
 <div align="center" style="text-align:center;">
     <asp:Button ID="Stop_Button" runat="server" Text="放入仓库"  CommandName="StopSale" OnCommand="Button_Command" OnClientClick="return confirm('商品放入仓库后，再次销售需要重新上架，确定将商品放入仓库吗？')" />
     <asp:Button ID="Elite_Button" runat="server" Text="店铺推荐" CommandName="ShopElite" OnCommand="Button_Command" />
     <asp:Button ID="Button1" runat="server" Text="取消推荐" CommandName="CancleShopElite" OnCommand="Button_Command" />
 </div>
</asp:Content>