﻿<%@ page language="C#" masterpagefile="MyShopMasterPage.master" autoeventwireup="true" inherits="Member_ShopProductSold, mallz" title="已出售商品" enableEventValidation="false" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <div class="pageTitle">已卖出的商品</div>

 <table class="SearchTableStyle">
    <tr class="tdbg">
        <td class="tdbg5" align="right">商品名称：</td>
        <td class="tdbg6"><asp:TextBox ID="TxtProductName" runat="server"  Width="200px" Height="16px" />&nbsp;&nbsp;</td>
        <td class="tdbg5" align="right">交易类型：</td>
        <td class="tdbg6">
             <asp:DropDownList ID="RadProductType" runat="server" RepeatDirection="Horizontal"  AutoPostBack="true" OnSelectedIndexChanged="Search_OnClick">
               <asp:ListItem Text="所有" Value="0" Selected="True" />
               <asp:ListItem Text="一口价" Value="1"/>
               <asp:ListItem Text="拍卖" Value="2" />
               <asp:ListItem Text="团购" Value="3" />
            </asp:DropDownList>
         </td>
     </tr>
    <tr class="tdbg">
           <td class="tdbg5" align="right">下单起始日期：</td>
           <td class="tdbg6"><asp:TextBox ID="TxtBeginDate" runat="server" Height="16px" /></td>
           <td class="tdbg5" align="right">至：</td>
           <td class="tdbg6" ><asp:TextBox ID="TxtEndDate" runat="server" Height="16px" /></td>
    </tr>
     <tr class="tdbg">
         <td class="tdbg6" align="center" colspan="4">
         <asp:Button ID="search_btn" runat="server" Text=" 查 询 " OnClick="Search_OnClick" />
     </td>
     </tr>
 </table>

 <div style="clear:both"></div>
 <div id="product_history">
     <asp:GridView ID="GridView1" runat="server" CssClass="tableHead" width="98%" AutoGenerateColumns="False"  AllowPaging="True" OnDataBound="GridView1_DataBound" >
         <Columns>
             <asp:TemplateField HeaderText="选择" HeaderStyle-Width="4%">
                 <ItemTemplate>
                     <input type="checkbox" name="ids" id="ids" value="<%# Eval("ProductID") %>" title="<%# "ID："+Eval("ProductID") %>" />
                 </ItemTemplate>
                  <HeaderTemplate>
                     <input id="chkAll" onclick="SelectAllCheckboxes(this,'ids');" type="checkbox" />                    
                  </HeaderTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="图片" HeaderStyle-Width="12%">                   
                 <ItemTemplate>
                      <asp:HyperLink ID="ProductNameUrl2" runat="server" NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank"><asp:Image ID="Image1" runat="server"  Width="100" ImageUrl='<%# Eval("ProductSmallImageUrl") %>' onerror="this.src='../Images/show_nopic.gif'" /></asp:HyperLink>
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="商品名称" ItemStyle-HorizontalAlign="Left">
                 <ItemTemplate>
                    <asp:HyperLink ID="ProductName" runat="server" Text='<%# Bind("ProductName") %>' NavigateUrl='<%#"../ShopProduct.aspx?ProductID="+Eval("ProductID") %>'  Target="_blank"/><br />
                    <asp:Label ID="LabProductType" runat="server" Text='<%# MallZ.Web.Shop.TextFormat.GetProductType(Eval("ProductType").ToString()) %>'/><br />
                    <asp:Literal runat="server" ID="s" Text='<%# "[ "+Eval("ClassName") +" ]" %>' />
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="销售状态" HeaderStyle-Width="6%">                
                 <ItemTemplate>
                     <asp:Literal ID="EnableSingleSell" runat="server" Text='<%#(Eval("EnableSingleSell").ToString()=="True" && Eval("EnableSale").ToString()=="True")?"√":"×" %>'/>
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="出价/浏览" HeaderStyle-Width="10%">                
                 <ItemTemplate>
                     <asp:Literal ID="Bid_Times_Or_Hits" runat="server" Text='<%#Eval("BuyTimes")+"/"+Eval("Hits") %>'/>
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="当前价格" ItemStyle-Width="7%" >
                <ItemTemplate>
                    <asp:Literal ID="litCurrentPrice" runat="server" Text='<%# Eval("CurrentPrice") %>' />
                </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="商品库存" HeaderStyle-Width="7%">
                 <ItemTemplate>
                    <asp:Literal ID="LabStocks" runat="server" Text='<%# Eval("Stocks") %>'/>
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:BoundField DataField="Cycle" HeaderText="当前期" ItemStyle-Width="7%" />
             <asp:TemplateField HeaderText="操作" HeaderStyle-Width="7%">
                 <ItemTemplate>
                     <asp:HyperLink ID="view" runat="server" Text="查看订单" NavigateUrl='<%# "Shop_ManageOrder.aspx?all=all&productname="+HttpContext.Current.Server.UrlEncode(Eval("ProductName").ToString()) %>' />
                 </ItemTemplate>
             </asp:TemplateField>
         </Columns>
         <EmptyDataTemplate>
          <table style="width:98%">
          <tr>
          <th>ID</th>
          <th>商品名称</th>
          <th>商品类型</th>
          <th>结束时间</th>
          <th>操作</th>
          </tr>
          <tr><td colspan="5">暂无任何商品</td></tr>
          </table>
         </EmptyDataTemplate>     
     </asp:GridView>
 </div>
 
</asp:Content>

