﻿var mouseOffset = null;
var iMouseDown  = false;
var lMouseState = false;
var dragObject  = null;
var DragDrops   = [];
var curTarget   = null;
var lastTarget  = null;
var dragHelper  = null;
var tempDiv     = null;
var rootParent  = null;
var rootSibling = null;
var layoutType="normal";
var slectType="Drag";
var rss_description=[];
var now = new Date();
var nextmonth = new Date(now.getYear(),now.getMonth()+1, now.getDate());
var _ContainerArray_=new Array();
var DragBoxArray=new Array();
var userChannel=new Array();

Number.prototype.NaN0=function(){return isNaN(this)?0:this;}

function CreateDragContainer(){
	var cDrag        = DragDrops.length;
	DragDrops[cDrag] = [];
     _ContainerArray_=document.getElementsByClassName("DragContainer");	
	  for (var i=0; i<_ContainerArray_.length; i++) {	 	
		 var cObj = _ContainerArray_[i];
		 DragDrops[cDrag].push(cObj);
		 cObj.setAttribute('DropObj', cDrag);

		for(var j=0; j<cObj.childNodes.length; j++){

			if(cObj.childNodes[j].nodeName=='#text') continue;

			cObj.childNodes[j].setAttribute('DragObj', cDrag);
			
		}
	}
}


function mouseCoords(ev){
	if(ev.pageX || ev.pageY){
		return {x:ev.pageX, y:ev.pageY};
	}
	return {
		x:ev.clientX + document.body.scrollLeft - document.body.clientLeft,
		y:ev.clientY + document.body.scrollTop  - document.body.clientTop
	};
}

function getMouseOffset(target, ev){
	ev = ev || window.event;
	var docPos    = getPosition(target);
	var mousePos  = mouseCoords(ev);
	return {x:mousePos.x - docPos.x, y:mousePos.y - docPos.y};
	
}

function getPosition(e){
	var left = 0;
	var top  = 0;
	while (e.offsetParent){
		left += e.offsetLeft + (e.currentStyle?(parseInt(e.currentStyle.borderLeftWidth)).NaN0():0);
		top  += e.offsetTop  + (e.currentStyle?(parseInt(e.currentStyle.borderTopWidth)).NaN0():0);
		e     = e.offsetParent;
	}

	left += e.offsetLeft + (e.currentStyle?(parseInt(e.currentStyle.borderLeftWidth)).NaN0():0);
	top  += e.offsetTop  + (e.currentStyle?(parseInt(e.currentStyle.borderTopWidth)).NaN0():0);
	return {x:left, y:top};
}


function mouseMove(ev){
	ev         = ev || window.event;
	var target   = ev.target || ev.srcElement;
	var mousePos = mouseCoords(ev);
	if(lastTarget && (target!==lastTarget)){
		var origClass = lastTarget.getAttribute('origClass');
		if(origClass) lastTarget.className = origClass;
	}

	var dragObj = target.getAttribute('DragObj');
	if(dragObj!=null){
		if(target!=lastTarget){
			var oClass = target.getAttribute('overClass');
			if(oClass){
				target.setAttribute('origClass', target.className);
				target.className = oClass;
			}
		}


		if(iMouseDown && !lMouseState){
			if((target.id).indexOf("_title")>0){
			  var __dragBox__Id= (target.id).substring(0,(target.id).indexOf("_title"));
			  target=document.getElementById(__dragBox__Id);
			  dragObj= target.getAttribute('DragObj');
			}
			curTarget     = target;
			rootParent    = curTarget.parentNode;
			rootSibling   = curTarget.nextSibling;
			mouseOffset   = getMouseOffset(target, ev);
			for(var i=0; i<dragHelper.childNodes.length; i++) dragHelper.removeChild(dragHelper.childNodes[i]);	
			dragHelper.appendChild(curTarget.cloneNode(true));			
			dragHelper.style.width=curTarget.clientWidth;
			dragHelper.style.display = 'block';
			var dragClass = curTarget.getAttribute('dragClass');
			if(dragClass){				    
				dragHelper.firstChild.className = dragClass;	
				
			}

			dragHelper.firstChild.removeAttribute('DragObj');
			var dragConts = DragDrops[dragObj];
			curTarget.setAttribute('startWidth',  parseInt(curTarget.offsetWidth));
			curTarget.setAttribute('startHeight', parseInt(curTarget.offsetHeight));	
			curTarget.style.display  = 'block';
			if(layoutType=="normal"){			
			    for(var i=0; i<dragConts.length; i++){    			 
				    with(dragConts[i]){
					    var pos = getPosition(dragConts[i]);					  
					    setAttribute('startWidth',  parseInt(offsetWidth));
					    setAttribute('startHeight', parseInt(offsetHeight));
					    setAttribute('startLeft',   pos.x);
					    setAttribute('startTop',    pos.y);
				    }

				  
				    for(var j=0; j<dragConts[i].childNodes.length; j++){
					    with(dragConts[i].childNodes[j]){
						    if((nodeName=='#text') || (dragConts[i].childNodes[j]==curTarget)) continue;
						    var pos = getPosition(dragConts[i].childNodes[j]);
						    setAttribute('startWidth',  parseInt(offsetWidth));
						    setAttribute('startHeight', parseInt(offsetHeight));
						    setAttribute('startLeft',   pos.x);
						    setAttribute('startTop',    pos.y);
					    }
				    }
				}
			}
		}
	}

	if(curTarget){
		
		dragHelper.style.top  = mousePos.y - mouseOffset.y;
		dragHelper.style.left = mousePos.x - mouseOffset.x; 
		var dragConts  = DragDrops[curTarget.getAttribute('DragObj')];
		var activeCont = null;

		var xPos = mousePos.x - mouseOffset.x + (parseInt(curTarget.getAttribute('startWidth')) /2);
		var yPos = mousePos.y - mouseOffset.y + (parseInt(curTarget.getAttribute('startHeight'))/2);		
		for(var i=0; i<dragConts.length; i++){
			with(dragConts[i]){
				if(((getAttribute('startLeft'))                               < xPos) &&
					((getAttribute('startTop'))                                < yPos) &&
					((getAttribute('startLeft') + getAttribute('startWidth'))  > xPos) &&
					((getAttribute('startTop')  + getAttribute('startHeight')) > yPos)&&layoutType=="normal"){
						
						curTarget.style.border='dashed 1px gray';						
						for(var m=0;m<curTarget.childNodes.length;m++)
							(curTarget.childNodes[m]).style.visibility='hidden';
						activeCont = dragConts[i];
						break;
				}				
			}
		}

		
		if(activeCont){		
			if(layoutType=="normal"){
			    var beforeNode = null;
			    for(var i=activeCont.childNodes.length-1; i>=0; i--){
				    with(activeCont.childNodes[i]){
					    if(nodeName=='#text') continue;
					    if(
						   ( curTarget != activeCont.childNodes[i]                              &&
						    ((getAttribute('startLeft') + getAttribute('startWidth'))  > xPos) )&&
						    ((getAttribute('startTop') + getAttribute('startHeight'))  > yPos)){
							    beforeNode = activeCont.childNodes[i];    						
					    }
    					
				    }
			    }
			    
			    if(beforeNode){
				    if(beforeNode!=curTarget.nextSibling){
					    activeCont.insertBefore(curTarget, beforeNode);
				    }
			    
			    } else {
				    if((curTarget.nextSibling) || (curTarget.parentNode!=activeCont)){
					    activeCont.appendChild(curTarget);
				    }
			    }
			   
			    if(curTarget.style.display!=''){
				    curTarget.style.display  = '';
			    }
			}			
			
		} else {			
			if(curTarget.style.display!='none'){
				curTarget.style.display  = 'none';
			}
		}
		
	}

	lMouseState = iMouseDown;	
	lastTarget  = target;	
	lMouseState = iMouseDown;	
	return false;
}

function mouseUp(ev){
	if(curTarget){		
		curTarget.style.top  = dragHelper.style.top;
		curTarget.style.left = dragHelper.style.left;
		dragHelper.style.display = 'none';		
		dragHelper.removeChild(dragHelper.childNodes[0]);		
		if(curTarget.style.display == 'none'){
			if(rootSibling){
				rootParent.insertBefore(curTarget, rootSibling);
			} else {
				rootParent.appendChild(curTarget);
			}
		}		
		curTarget.style.display = '';
		curTarget.style.border='0';
		for(var m=0;m<curTarget.childNodes.length;m++)
			(curTarget.childNodes[m]).style.visibility='visible';
			
	    var m_containerObj=curTarget.parentNode;
	    var m_row=0;
	   
	    for(var ch=0;ch<m_containerObj.childNodes.length;ch++){
	      if((m_containerObj.childNodes[ch]).id==curTarget.id)
	        m_row=ch;
	    }
	  
	    SaveCurrnetLayout();
	}
	curTarget  = null;
	iMouseDown = false;	
	
}
function SaveCookie(){
  var s_cookie_array=new Array(); 
  for(var k=0;k<userChannel.length;k++){
     var tempArray=new Array();
     for(var l=0;l<=10;l++){        
       var temp_str=userChannel[k][l].toString();
       if(temp_str.indexOf("=")>0){         
          temp_str=temp_str.replace(/\=/g,"{equ}");          
       }   
       tempArray[l]=temp_str;
       if(l==1)
          temp_str=escape(temp_str);
     }
     s_cookie_array[k]=tempArray.join("|");  
  }
  var s_cookie=new Cookie();
  s_cookie.setCookie("MAllZ_ChannelArray", s_cookie_array,nextmonth); 
}

function SaveCurrnetLayout(){
//1先保存当前的列布局
//2循环所有容器，保存各容器内的模块的位置

  for(var i=0;i<_ContainerArray_.length;i++){
     for(var j=0;j<_ContainerArray_[i].childNodes.length;j++){
        for(var k=0;k<userChannel.length;k++){
           if((_ContainerArray_[i].childNodes[j]).id=="rss_"+userChannel[k][0].toString()){
               userChannel[k][4]=i;//col
               userChannel[k][5]=j;//row                   
           }
        }    
		//Cookie("ChannelArray")="id|title|rssurl|rssnum|col|row|width|height|type|top|left"
     }
  } 
  SaveCookie();
}


function mouseDown(){  
   var el = getReal(event.srcElement, "className", "dragBoxContent");
   if (el == null) {    
      iMouseDown = true;
	  if(lastTarget){	 
		return false;
	 }
   } 
   else{ 
     doDown();
   }
}

var theobject = null;
function resizeObject() {
 this.el        = null; 
 this.dir    = "";     
 this.grabx = null;     
 this.graby = null;
 this.width = null;
 this.height = null;
 this.left = null;
 this.top = null;
}
 
function getDirection(el) {
 var xPos, yPos, offset, dir;
 dir = "";
 xPos = window.event.offsetX;
 yPos = window.event.offsetY;
 offset = 8; 
 if (yPos<offset) dir += "n";
 else if (yPos > el.offsetHeight-offset) dir += "s";
 if (xPos<offset) dir += "w";
 else if (xPos > el.offsetWidth-offset) dir += "e";
 return dir;
}

function doDown() {

 var el = getReal(event.srcElement, "className", "dragBoxContent");
 if (el == null) {
  theobject = null;
  return;
 }  
 dir = getDirection(el);
 if (dir == "") return;
 
 theobject = new resizeObject(); 
 theobject.el = el;
 theobject.dir = dir;
 theobject.grabx = window.event.clientX;
 theobject.graby = window.event.clientY;
 theobject.width = el.offsetWidth;
 theobject.height = el.offsetHeight;
 theobject.left = el.offsetLeft;
 theobject.top = el.offsetTop;
 window.event.returnValue = false;
 window.event.cancelBubble = true;
}

function doUp() {

 if (theobject != null) {
  theobject = null; 
 }
 
}

function doMove() {
 var el, xPos, yPos, str, xMin, yMin;
 xMin = 8; 
 yMin = 8; 
 el = getReal(event.srcElement, "className", "dragBoxContent");
 if(el!=null){
     if (el.className == "dragBoxContent") {
      str = getDirection(el);
      if (str == "") str = "default";
      else str += "-resize";
      el.style.cursor = str;      
     }
 }

 if(theobject != null ) {
   var _DragBox=theobject.el.parentNode;
  if (dir.indexOf("e") != -1){
   theobject.el.style.width = Math.max(xMin, theobject.width + window.event.clientX - theobject.grabx) + "px";
  }
  if (dir.indexOf("s") != -1)
   theobject.el.style.height = Math.max(yMin, theobject.height + window.event.clientY - theobject.graby) + "px";
  if (dir.indexOf("w") != -1) {
   theobject.el.style.left = Math.min(theobject.left + window.event.clientX - theobject.grabx, theobject.left + theobject.width - xMin) + "px";
   theobject.el.style.width = Math.max(xMin, theobject.width - window.event.clientX + theobject.grabx) + "px";
  }
  if (dir.indexOf("n") != -1) {
   theobject.el.style.top = Math.min(theobject.top + window.event.clientY - theobject.graby, theobject.top + theobject.height - yMin) + "px";
   theobject.el.style.height = Math.max(yMin, theobject.height - window.event.clientY + theobject.graby) + "px";
  }
  theobject.el.style.width=(parseInt(theobject.el.style.width)<160)?(160+"px"):theobject.el.style.width;
  _DragBox.style.width=theobject.el.style.width;
  window.event.returnValue = false;
  window.event.cancelBubble = true;  
 } 
}

function getReal(el, type, value) {
 temp = el;
 while ((temp != null) && (temp.tagName != "BODY")) {
  if (eval("temp." + type) == value) {
   el = temp;
   return el;
  }
  else{
   return null;
  }
}
 return el;
}

document.onmousemove = selectMove;
document.onmouseout=selectMove;
document.onmousedown=selectMove;
document.onmouseup   =selectMove;

function selectMove(ev){
var selectTarget;
if(slectType!="undefined"){
    ev         = ev || window.event;
	var starget   = ev.target || ev.srcElement;
	if(starget.getAttribute('DragObj')!=null){
	   slectType="Drag";	  
	}
	else if(starget.getAttribute('ResizeObj')!=null){
	  slectType="Resize";	  
	}
	else{
	  slectType="ALL";
	}  
     selectTarget=starget.id
	if(slectType=="Drag"){
      document.onmousemove = mouseMove;
      document.onmousedown = mouseDown;
      document.onmouseup   = mouseUp;
    }
    if(slectType=="Resize"){
      document.onmousemove = doMove;
      document.onmousedown =doDown;
      document.onmouseup   =doUp;
    }
}
    
   
}    

function selectDown(){
if(slectType!="undefined"){
    if(slectType=="Drag"){
      document.onmousemove = mouseMove;
      document.onmousedown = mouseDown;
      document.onmouseup   = mouseUp;
    }
    if(slectType=="Resize"){
      document.onmousemove = doMove;
      document.onmousedown =doDown;
      document.onmouseup   =doUp;
    }
 }   
}
function selectUp(){
if(slectType!="undefined"){
    if(slectType=="Drag"){
      document.onmousemove = mouseMove;
      document.onmousedown = mouseDown;
      document.onmouseup   = mouseUp;
    }
    if(slectType=="Resize"){
      document.onmousemove = doMove;
      document.onmousedown =doDown;
      document.onmouseup   =doUp;
    }
 }
}

document.getElementsByClassName = function(cl) {
        var retnode = [];
        var myclass = new RegExp('\\b'+cl+'\\b');
        var elem = this.getElementsByTagName('*');
        for (var j = 0; j < elem.length; j++) {
            var classes = elem[j].className;
            if (myclass.test(classes)) retnode.push(elem[j]);
        }
        return retnode;
    }
 
   
   function initContainer(){  
	dragHelper = document.createElement('DIV');
	dragHelper.setAttribute("id","dragHelper_1");
	dragHelper.style.cssText = 'position:absolute;display:none;';	
	if(arguments.length>0){	
	   Layout(arguments[0]);
	}
	else
	{
	   if(GetCookieLayout()){	
	   }  
	   else{ 
	     loadChannel();
	   } 
	   window.setTimeout(Layout,500);	 
	}	
	document.body.appendChild(dragHelper);
	page = new Page();
	var _cookies=new Cookie();
	var _h_title=_cookies.getCookie("MAllZ_myspace_title");
	if(_h_title!=null&& _h_title!="")
	   document.getElementById("myTitle").value=_h_title;
   }   
   
   function loadChannel(){    
	 var _ajax_=new HttpAjax();
	 _xmlReq_ = _ajax_.create("WebService.ashx?Action=GetPublicRssList&Rnd="+Math.random(), load_Rsscallback, load_onError);
	

   }
   function load_Rsscallback(rValue){
     var rssContent=rValue.responsexml;      
     var channels=rssContent.getElementsByTagName("item");
     for(var i=0;i<channels.length;i++){       
	    userChannel[i]=new Array();
		userChannel[i][0]=channels[i].getElementsByTagName("id")[0].firstChild.nodeValue; 	   
		userChannel[i][1]=channels[i].getElementsByTagName("title")[0].firstChild.nodeValue; 
		userChannel[i][2]=channels[i].getElementsByTagName("link")[0].firstChild.nodeValue; 
		userChannel[i][3]=channels[i].getElementsByTagName("nums")[0].firstChild.nodeValue;
		userChannel[i][4]=channels[i].getElementsByTagName("col")[0].firstChild.nodeValue;
		userChannel[i][5]=channels[i].getElementsByTagName("row")[0].firstChild.nodeValue;
		userChannel[i][6]=channels[i].getElementsByTagName("width")[0].firstChild.nodeValue;
		userChannel[i][7]=channels[i].getElementsByTagName("height")[0].firstChild.nodeValue;	
		userChannel[i][8]=channels[i].getElementsByTagName("articleType")[0].firstChild.nodeValue;
		userChannel[i][9]=channels[i].getElementsByTagName("top")[0].firstChild.nodeValue;	
		userChannel[i][10]=channels[i].getElementsByTagName("left")[0].firstChild.nodeValue;		
		var userChannelObj=CreateDragBox(userChannel[i]);
		DragBoxArray.push(userChannelObj);
		
		 //Cookie("ChannelArray")="id|title|rssurl|rssnum|col|row|width|height|type|top|left"
	 }	  
  }
   
  function load_onError(){
  
  }
  
  function GetCookieLayout(){
     var cookie=new Cookie();
     var _cookie_layout=cookie.getCookie("MAllZ_Layout");
     var _cookie_ChannelArray=cookie.getCookie("MAllZ_ChannelArray"); 
 
     if(_cookie_layout==null||_cookie_layout==""||_cookie_ChannelArray==null||_cookie_ChannelArray=="")
        return false;  
     if(_cookie_ChannelArray.length>0 && _cookie_ChannelArray.indexOf(',')>0){         
         _cookie_DragBox=_cookie_ChannelArray.split(',');        
         for(var i=0;i<_cookie_DragBox.length;i++){          
                 var _cookie_DragBoxInfoArray=_cookie_DragBox[i].split('|');                 
                  userChannel[i]=new Array();
                  userChannel[i][0]=_cookie_DragBoxInfoArray[0];
                  userChannel[i][1]=_cookie_DragBoxInfoArray[1];
                  userChannel[i][2]=_cookie_DragBoxInfoArray[2];
                  userChannel[i][3]=_cookie_DragBoxInfoArray[3];
                  userChannel[i][4]=_cookie_DragBoxInfoArray[4];
                  userChannel[i][5]=_cookie_DragBoxInfoArray[5];
                  userChannel[i][6]=_cookie_DragBoxInfoArray[6];
                  userChannel[i][7]=_cookie_DragBoxInfoArray[7];
                  userChannel[i][8]=_cookie_DragBoxInfoArray[8];
                  userChannel[i][9]=_cookie_DragBoxInfoArray[9];
                  userChannel[i][10]=_cookie_DragBoxInfoArray[10];
                  var userChannelObj=CreateDragBox(userChannel[i]);
		          DragBoxArray.push(userChannelObj);  
		         
         }   
     } 
     return true;   
  }
 function UpdateDragBox(dragBoxId,itemOrder,itemValue){
     for(var k=0;k<userChannel.length;k++){
           if(dragBoxId=="rss_"+userChannel[k][0].toString()){            
               userChannel[k][itemOrder]=itemValue;              
           }
     } 
     SaveCookie(); 
 
 }
  var _ranTime=100;
 
  function Delay(url,id){  
   _ranTime=_ranTime+400; 
    window.setTimeout(_GetRss(url,id), _ranTime);
  }
  function _GetRss(url,id){   
    return function(){
       GetRss(url,id);
    }
  }
   var _ranTimeStatus;
  function GetRss(url,id){
     var _ajax_=new HttpAjax();    
	 _xmlReq_ = _ajax_.updateContent("WebService.ashx?Action=GetRssContent&rssurl="+url+"&Rnd="+Math.random(),id); 
  }
  function GetJs(url,id){
    var _script=document.createElement("script");
    _script.src=url;
   document.getElementById(id).appendChild(_script);
  } 
   
  function Layout(){ 
    var rowNums;  
     var cookie=new Cookie();  
    if(arguments[0]==null){
       var _cookie_layout=cookie.getCookie("MAllZ_Layout");
       if(_cookie_layout!=""&&_cookie_layout!=null){
           rowNums=parseInt(_cookie_layout);
           var m_ContainerSelect=document.getElementById("ContainerNums");
           for(var n=0;n<m_ContainerSelect.length;n++){
             var op=m_ContainerSelect.options[n]
              if(op.value==rowNums){ 
                 op.selected=true;
                 break;
              }  
           }
          
       }    
       else 
           rowNums=3;
    }    
    else
         rowNums=arguments[0];
    cookie.setCookie("MAllZ_Layout",rowNums,nextmonth);    
    var _pageContent=document.getElementById("PageContent");
	cleanWhiteSpace(_pageContent);	    
	var _PageContentChildNodes=_pageContent.childNodes.length;	
	for(var k=_PageContentChildNodes;k>0;k--){
	    _pageContent.removeChild(_pageContent.childNodes[k-1]);	  
	}	
	if(rowNums==0){
	    for(var i=0;i<DragBoxArray.length;i++){	   
		   var objRssID=userChannel[i][0];	
		   DragBoxArray[i].style.width="300px";
		   DragBoxArray[i].style.position="absolute";
	       _pageContent.appendChild(DragBoxArray[i]);		
	    }	   
	 
	 }else{
	  layoutType="normal";
	  var _contentWidth=parseInt(100/rowNums)-1.5;	 
	  for(var i=0;i<rowNums;i++){	   
	    var _dragContainer=document.createElement('div');
		_dragContainer.className='DragContainer';	   
	    _dragContainer.setAttribute('id','DragContainer'+i);
		_dragContainer.style.width=_contentWidth+"%";
		_pageContent.appendChild(_dragContainer);		
		PushBoxInContainer(_dragContainer,i,rowNums);		
	  }
	   var _clear=document.createElement('div');
	   _clear.className="both";
	   _pageContent.appendChild(_clear);
	   document.body.appendChild(_pageContent);
	   var _bottom_=document.getElementById("bottom");
	   _bottom_.style.display="block";
	   document.body.appendChild(_bottom_);
	   CreateDragContainer();  
	 }  
   } 
    
   function PushBoxInContainer(DragBoxContainer,ColNums,MaxCol){    
      for(var m=0;m<10;m++){
         for(var i=0;i<userChannel.length;i++){	         
		    var objRssCol=userChannel[i][4];		
	        var objRssRow=userChannel[i][5];	      
	        if(objRssRow==m && objRssCol==ColNums){
	          
		       (DragBoxArray[i].childNodes[1]).style.width="99%";
		       (DragBoxArray[i].childNodes[1]).style.height="auto";
		        DragBoxArray[i].style.position="";	
		        DragBoxArray[i].style.width="100%";	
		        DragBoxContainer.appendChild(DragBoxArray[i]);
		     }   
		     else if(objRssCol>=MaxCol) 
	           DragBoxContainer.appendChild(DragBoxArray[i]);
    		
	     }
	  }    
   }
  
  function insertAt(parentNode,newNode,index){
     if(!parentNode.hasChildNodes()){
        parentNode.appendChild(newNode);
        return newNode;
     }
     try{
        parentNode.insertBefore(newNode,parentNode.childNodes[index]);     
     }
     catch(e){
        return null;
     }
     return newNode;
  
  }
  function CreateDragBox(obj){
      var divElement=document.createElement("div");     
	  divElement.className="DragBox";
      divElement.setAttribute("overClass","OverDragBox");
      divElement.setAttribute("dragClass","DragDragBox");
      divElement.setAttribute("onmousemove","mouseMove");
      divElement.setAttribute("onmouseup","mouseUp");
      divElement.setAttribute("onmousedown","mouseDown");
      divElement.setAttribute("id","rss_"+obj[0]); 
      var rss_Id="rss_"+obj[0]; 
      var divHTML= "<table style=\"border:0;\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" id=\""+rss_Id+"_tablehead\">";
      divHTML+="<tr><td style=\"width:6px;\"><img src=\"Images/MySpace/aiddi_25.gif\"/></td>";
      divHTML+="<td style=\"background:url(Images/MySpace/aiddi_26.gif) repeat-x;width:100%;\" id=\""+rss_Id+"_table_td\">";
      divHTML+="<div id=\""+rss_Id+"_head\" class=\"dragBoxHead\"><div id=\""+rss_Id+"_title\" class=\"dragBoxTitle\" DragObj=\"0\" ><a href=\""+obj[2]+"\">"+obj[1]+"</a></div><div id=\""+rss_Id+"_tool\" class=\"dragBoxTool\"><img src=\"Images/MySpace/View.gif\" onClick='top.page.DragBoxMenu.showMenu(\""+rss_Id+"\")' align='middle' onMouseOver=\"this.className='buttonActive';\" onMouseOut=\"this.className='buttonBlur';\"/>&nbsp;<img src=\"Images/MySpace/Box_small.gif\" onClick='top.page.DragBoxMenu.showHideContent(\""+rss_Id+"_content\",this)' align='middle' onMouseOver=\"this.className='buttonActive';\" onMouseOut=\"this.className='buttonBlur';\"/>&nbsp;<img src=\"Images/MySpace/deleteLink.gif\" onClick='javascript:if(confirm(\"确认要删除此模块？\"))top.page.DragBoxMenu.close(\""+rss_Id+"\");' align='middle' onMouseOver=\"this.className='buttonActive';\" onMouseOut=\"this.className='buttonBlur';\"/></div></div>";
      divHTML+="</td>";
      divHTML+="<td><img src=\"Images/MySpace/aiddi_28.gif\"/></td>";
      divHTML+="</tr></table>";
      divHTML+="<div id=\""+rss_Id+"_content\" class=\"dragBoxContent\" ResizeObj=\"0\"><img src=\"Images/MySpace/Loading.gif\"/>";
      if(obj[8]=="Rss")
         divHTML+="<script>Delay('"+obj[2]+"','"+rss_Id+"_content');<\/script>";    
      divHTML+="</div>"     
      get_callback(divElement,divHTML);
	  return divElement;  
  } 
  function cleanWhiteSpace(element){
     for(var i=0;i<element.childNodes.lenght;i++){
	    var node=element.childNodes[i];
		if(node.nodeType==3&&!/\S/.test(node.nodeValue))
		node.parentNode.removeChild(node);
	 }
  
  }
   function gE(id) {
	if (document.all)
		return document.all[id];
	else
		return document.getElementById(id);
   }
   
   function get_callback(obj,innerContent){
      reInnerHTML(obj, innerContent);                　　　　                
   }
      
   var reInnerHTML=function (ele,innerHtml) {
       var nA=navigator.appVersion;
       if(nA.indexOf('MSIE')>=0)var curIE=nA.substr(nA.indexOf('MSIE')+5,3);
       if (curIE){
          innerHtml=innerHtml.replace(/<script([^>]*)>/gi,"<script$1 defer=\"true\">");
          var reStartScript=/^(\s*<script)/gi;
         if (reStartScript.test(innerHtml)){
             innerHtml="<span style=\"display:none;\">Hack IE</span>"+innerHtml;
             ele.innerHTML=innerHtml;
             ele.removeChild(ele.firstChild);
         }else{
             ele.innerHTML=innerHtml;
         }

       }else{
          var newObj=document.createElement(ele.tagName);
          newObj.id=ele.id;
          newObj.className=ele.className;
          newObj.innerHTML = innerHtml;
          ele.parentNode.replaceChild(newObj,ele);
       }
   }


function HttpCookie(name, value) {   
    if (name != null)
        this.name = name;
    else
        this.name = "";
    if (value != null)
        this.value = value;
    else
        this.value = "";
    this.expires = new Date();
    this.path = "";
    this.domain = "";
    this.toString = function() {
        return "MAllZ.IMS.DeskTop.HttpCookie";
    }
}

function Cookie() {
    var __value__ = document.cookie;
    if (__value__ == null || __value__ == "")
        this.enabled = false;
    else
        this.enabled = true;
    var __cookies__ = new Array();
    if (this.enabled) {
        var __tempValue = __value__.split(';');
        for (var i = 0; i < __tempValue.length; i++) {
            var __name = __tempValue[i].split('=')[0];
            var __value = unescape(__tempValue[i].split('=')[1]);
            var __cookie = new HttpCookie(__name, __value);
            __cookies__.push(__cookie);
        }
    }
    this.item = __cookies__;
    this.getCookie = function (name) {
        for (var i = 0; i < __cookies__.length; i++) {
            var __name = __cookies__[i].name;
            if (__name.indexOf(" ") > -1)
                __name = __name.substring(__name.indexOf(" ") + 1, __name.length);
            if (__name.lastIndexOf(" ") > -1)
                __name = __name.substring(0, __name.lastIndexOf(" "));
            var __value = __cookies__[i].value;
            if (__name == name)
                return __value;
        }
        return null;
    }
    this.setCookie = function() {   
        if (arguments.length == 0 || arguments.length > 3) {
            throw "Invalid arguments.";
        }
        else {
            var __cookie;
            if (arguments.length == 1)
                __cookie = arguments[0];
            else if (arguments.length == 2) {
                __cookie = new HttpCookie(arguments[0], arguments[1]);
            }
            else {
                __cookie = new HttpCookie(arguments[0], arguments[1]);
                __cookie.expires = arguments[2];
            }
            var __modified = false;
            var __index = -1;
            for (var i = 0; i < __cookies__.length; i++) {
                var __name = __cookies__[i].name;
                var __value = __cookies__[i].value;
                if (__name == __cookie.name) {
                    __cookies__[i].value = __cookie.value;
                    __cookies__[i].expires = __cookie.expires;
                    __modified = true;
                    __index = i;
                }
            }
            if (!__modified) {
                __index = __cookies__.length;
                __cookies__.push(__cookie);
            }            
          
            if (document.all) {               
                document.cookie = __cookies__[__index].name + "=" + __cookies__[__index].value + ";expires=" + __cookies__[__index].expires.toGMTString();
            }
            else {               
                var __expiresDate = __cookies__[__index].expires;
                var __abbreviatedMonthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                var __dayNames = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
                var __expires = __dayNames[__expiresDate.getUTCDay()] + ", " + (__expiresDate.getUTCDate() > 0 ? "" : "0") + __expiresDate.getUTCDate() + "-" + __abbreviatedMonthNames[__expiresDate.getUTCMonth()] + "-" + __expiresDate.getUTCFullYear() + " " + (__expiresDate.getUTCHours() > 9 ? "" : "0") + __expiresDate.getUTCHours() + ":" + (__expiresDate.getUTCMinutes() > 9 ? "" : "0") + __expiresDate.getUTCMinutes() + ":" + (__expiresDate.getUTCSeconds() > 9 ? "" : "0") + __expiresDate.getUTCSeconds() + " GMT";
                document.cookie = __cookie.name + "=" + __cookie.value + ";";
                document.cookie += "expires=" + __expires;               
            }
        }
    }
}

function HttpAjax() { 
    var self = this;    
    this.createXMLHttpRequest = function() {
	    try { 
		    return new ActiveXObject("Msxml2.XMLHTTP"); 
	    } 
	    catch (e) {
	    }
	    try { 
		    return new ActiveXObject("Microsoft.XMLHTTP"); 
	    } 
	    catch (e) {
	    }
	    try {
		    return new XMLHttpRequest(); 
	    } 
	    catch(e) {
	    }
	    return null;
    }
    this.toString = function() {
        return "MallZ.Web.HttpAjax";
    }
    
    this.create = function(url, callbackHandler, onErrorHandler) {
        var xmlReq = this.createXMLHttpRequest();
        if (xmlReq != null) {        
		    xmlReq.open("GET", url, true);
		    xmlReq.onreadystatechange = function() {
                switch(xmlReq.readyState)
                {
                    case 0: 
                        break;
                    case 1: 
                        break;
                    case 2: 
                        break;
                    case 3: 
                        break;
                    case 4: 
                        callbackHandler(xmlReq);
                        break;
                    default:
                        onErrorHandler();
                        break;
                    }
                }
		    xmlReq.send(null);
		    return xmlReq;
        }
        else {
			throw "System does not support Ajax.";
        }
    }
    this.setVisible = function(controlId, visible) {
        if (document.getElementById(controlId) != null)
            document.getElementById(controlId).style.visibility = (visible ? "visible" : "hidden");
    }
	this.setDisplay = function(controlId, displayMode) {
        if (document.getElementById(controlId) != null)
            document.getElementById(controlId).style.display = displayMode;
	}
    this.updateContent = function (url, controlId,rssNum) {
      var processingIcon;
      var _controlContent=document.getElementById(controlId);
      if( _controlContent!=null){
         _controlContent.innerHTML="<img src=\"Images/MySpace/Loading.gif\"/>";
      }		
        var xmlReq = this.createXMLHttpRequest();
        if (xmlReq != null) {
		    xmlReq.open("GET", url, true);
		    xmlReq.onreadystatechange = function() {
                switch(xmlReq.readyState)
                {
                    case 0: 
                        break;
                    case 1: 
                        break;
                    case 2: 
                        break;
                    case 3: 
                        break;
                    case 4: 
                        updateContent_callback(xmlReq, controlId,rssNum);
                        break;
                    default:
                        updateContent_onError(controlId);
                        break;
                    }
                }
		    xmlReq.send(null);
        }
        else {
           
        }
    }
   
    this.adjustFrameSize = function(frameId) {
	    var frame = top.document.getElementById(frameId);
	    if (frame) {
		    frame.style.height = "0px";
		    if (frame.contentDocument) {			   
			    frame.style.height = parseInt(frame.contentDocument.documentElement.scrollHeight) + "px";
		    }
		    else if (frame.document) {
			    frame.style.height = parseInt(frame.contentWindow.document.documentElement.scrollHeight) + "px";
		    }
	    }
    }  
    function updateContent_callback(rValue, controlId,rssNum) {
      var rsp = rValue.responseXML; 
      var news=rsp.getElementsByTagName("item");
      var nums=news.length;
      if(rssNum!=null&&rssNum!="")
        nums=parseInt(rssNum);
      if(news.length<nums)
          nums=news.length; 
      var result="<ul>"; 
      var rss_i=rss_description.length+1; 
      rss_description[rss_i]=new Array();
      for(var i=0;i<nums;i++)
      {
         if(news[i].getElementsByTagName("description")[0].hasChildNodes()&&news[i].getElementsByTagName("description")[0].firstChild.length>0)
         {     
            rss_description[rss_i][i]=news[i].getElementsByTagName("description")[0].firstChild.nodeValue;            
            result+="<li><a href='"+news[i].getElementsByTagName("link")[0].firstChild.nodeValue +"' target='_blank'>"+news[i].getElementsByTagName("title")[0].firstChild.nodeValue+"</a><a href='javascript:void(0)' onclick=\"top.page.DragBoxMenu.showRss(this,"+rss_i+","+i+");\"><img src='Images/MySpace/rss_detail.gif' border='0'/></a></li>";
         }    
         else
            result+="<li><a href='"+news[i].getElementsByTagName("link")[0].firstChild.nodeValue +"' target='_blank'>"+news[i].getElementsByTagName("title")[0].firstChild.nodeValue+"</a></li>";
      }
      result+="</ul>";     
      var _control=document.getElementById(controlId);
      if(_control!=null)
          _control.innerHTML=result;  
    }   
    function updateContent_onError(controlId) {
        if (document.getElementById(controlId) != null)
            document.getElementById(controlId).innerHTML = "Data unavailable. Please try again.";    
    }
}

function DragBoxMenu(){
   var _menuObj=gE("DragBox_Menu");
   var _control;
   var _head_; 
   var _content_;
   var self=this;
   var _controlID_;
   var _currentContainer;   
   var _href_;
   var ajax=new HttpAjax(); 
   var _titleObj_;
   var _explainContent=true;
   var _explainHead=true;
   this.showMenu=function(_controlId){
      _controlID_=_controlId;
       var _containerArray=document.getElementsByClassName("DragContainer");
       _control=document.getElementById(_controlId);
       _head_=document.getElementById(_controlId+"_head");
       _titleObj_=_head_.firstChild;
       _content=_control.childNodes[1];       
      _href_=(_titleObj_.childNodes[0]).getAttribute("href");    
       _currentContainer=_control.parentNode;  
       var _disableleft=false;
       var _disableright=false;
       var _disableup=false;
       var _disabledown=false;
       if(_containerArray.length>0){
           if(_containerArray[0].id==_currentContainer.id){
              _disableleft=true;
           }
           if(_containerArray[_containerArray.length-1].id==_currentContainer.id){
             _disableright=true;
           }
           cleanWhiteSpace(_currentContainer);
           if(_currentContainer.firstChild== _control){
             _disableup=true;
           }
           if(_currentContainer.lastChild== _control){
             _disabledown=true;
           }
       }
        var menuHtml="<ul id=\"navmenu\"><li><ul>";
         menuHtml+="<li><img src=\"Images/MySpace/refresh.gif\" />高度";
         menuHtml+="<ul>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.changeSize('add',50)\"><img src='Images/MySpace/add.gif'/>增加50</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.changeSize('sub',50)\"><img src='Images/MySpace/add.gif'/>减少50</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.changeSize('add',100)\"><img src='Images/MySpace/add.gif'/>增加100</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.changeSize('sub',100)\"><img src='Images/MySpace/add.gif'/>减少100</li>";         
         menuHtml+="</ul></li>";         
         menuHtml+="<li><a href='#'><img src=\"Images/MySpace/move.gif\" />移动</a>";
         menuHtml+="    <ul>";
         if(_disableup)
            menuHtml+="      <li id=\"Menu_moveUp\" ><img src=\"Images/MySpace/moveUp_U.gif\" />向上</li>";
         else
            menuHtml+="      <li id=\"Menu_moveUp\" onclick=\"top.page.DragBoxMenu.move('"+_controlId+"','up')\"><img src=\"Images/MySpace/moveUp.gif\" />向上</li>";
         if(_disabledown)
            menuHtml+="      <li id=\"Menu_moveDown\"><img src=\"Images/MySpace/moveDown_U.gif\" />向下</li>";
         else
            menuHtml+="      <li id=\"Menu_moveDown\" onclick=\"top.page.DragBoxMenu.move('"+_controlId+"','down')\"><img src=\"Images/MySpace/moveDown.gif\" />向下</li>";
         if(_disableleft)
            menuHtml+="      <li id=\"Menu_moveLeft\"><img src=\"Images/MySpace/moveLeft_U.gif\" />向左</li>";
         else
            menuHtml+="      <li id=\"Menu_moveLeft\" onclick=\"top.page.DragBoxMenu.move('"+_controlId+"','left')\"><img src=\"Images/MySpace/moveLeft.gif\" />向左</li>";
         if(_disableright)
            menuHtml+="      <li id=\"Menu_moveRight\"><img src=\"Images/MySpace/moveRight_U.gif\" />向右</li>";
         else
            menuHtml+="      <li id=\"Menu_moveRight\" onclick=\"top.page.DragBoxMenu.move('"+_controlId+"','right')\"><img src=\"Images/MySpace/moveRight.gif\" />向右</li>";
         menuHtml+="   </ul>";      
         menuHtml+="</li>";                
         menuHtml+="<li><a href='#'><img src=\"Images/MySpace/showNums.gif\" />显示数量</a>";
         menuHtml+="<ul>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.setNums('"+_controlId+"_content',5)\"><img src='Images/MySpace/add.gif'/>5</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.setNums('"+_controlId+"_content',10)\"><img src='Images/MySpace/add.gif'/>10</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.setNums('"+_controlId+"_content',15)\"><img src='Images/MySpace/add.gif'/>15</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.setNums('"+_controlId+"_content',20)\"><img src='Images/MySpace/add.gif'/>20</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.setNums('"+_controlId+"_content')\"><img src='Images/MySpace/add.gif'/>全部</li>";
         menuHtml+="</ul></li>";  
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.refresh('"+_controlId+"_content')\" ><img src=\"Images/MySpace/refresh.gif\" />刷新</li>";
         menuHtml+="<li onclick=\"top.page.DragBoxMenu.showSetTitle('"+_controlId+"_title')\"><img src=\"Images/MySpace/Mode.gif\" />更改标题</li>";   
         menuHtml+=" </ul></li></ul>";  
         var tmouseOffset=getMouseOffset(_titleObj_,event); 
         var tmousePos = mouseCoords(event);
         _menuObj.innerHTML=menuHtml;         
         _menuObj.style.display = "block"; 
         _menuObj.style.left= event.x-50;
         _menuObj.style.top =tmousePos.y-tmouseOffset.y+20;  
         navHover();        
   
   }
   this.hideMenu=function(){
     _menuObj.style.display="none";
   }
   this.refresh=function(_controlId){
     var refreshUrl="WebService.ashx?Action=GetRssContent&rssurl="+_href_+"&Rnd="+Math.random();   
     ajax.updateContent(refreshUrl,_controlId);
   }
   
   this.setNums=function(_controlId,DisplayNums){
      var refreshUrl="WebService.ashx?Action=GetRssContent&rssurl="+_href_+"&Rnd="+Math.random();   
      ajax.updateContent(refreshUrl,_controlId,DisplayNums);
   }
   
   this.close=function(_controlId){     
     _control=document.getElementById(_controlId);
     (_control.parentNode).removeChild(_control);
   }
  
   this.showHideContent=function(_controlId,obj){    
     _control=document.getElementById(_controlId); 
     var _display=_control.style.display;
     if(_display=="none"){
       obj.setAttribute("src","Images/MySpace/Box_small.gif");
       _control.style.display="block";
       _explainContent=true;
     }
     else{
        obj.setAttribute("src","Images/MySpace/Box_big.gif");
        _control.style.display="none";
        _explainContent=false;
     }  
     
   }
   this.changeSize=function(sizeType,sizeNums){
     var _sizeNums_=parseInt(sizeNums);
     switch(sizeType){
       case "add":      
         _content.style.height=_content.clientHeight+_sizeNums_;
         break;
       case "sub":        
          if(_content.clientHeight>_sizeNums_)
           _content.style.height=_content.clientHeight-_sizeNums_;
         break;
     }    
   
   }
  
   this.explainContent=function(){
      if(_explainHead){
      var _controlArray=document.getElementsByClassName("DragBox");   
	  for(var j=0;j<_controlArray.length;j++){	
	       _controlArray[j].childNodes[1].style.display=_explainContent?"none":"block";
	     }	  
	 	_explainContent=(_explainContent==true)?false:true;
	 }
	 else	
	    alert("很抱歉，不能在关闭眉栏时关闭内容");
   }
  
   this.explainHead=function(){
      if(_explainContent){
        //  var _ContainerArray_=document.getElementsByClassName("DragContainer");	
	      for (var i=0; i<_ContainerArray_.length; i++) {	
	         var _controlArray=_ContainerArray_[i].childNodes;	     
	         for(var j=0;j<_controlArray.length;j++){	    
	           _controlArray[j].childNodes[0].style.display=_explainHead?"none":"block";
	         }
    	  
	      }
	      _explainHead=(_explainHead==true)?false:true; 
	  }
	  else	 
	    alert("很抱歉，不能在关闭内容时关闭眉栏");
	  
   }
   
   this.move=function(_controlId,moveDirection){
      if(_control!=null&&_currentContainer!=null){     
           switch (moveDirection){
              case "up":
                 var beforeNode=_control.previousSibling;
                 if(beforeNode!=null)
                   _currentContainer.insertBefore(_control,beforeNode);
                 break;
              case "down":
                 var nextNode=_control.nextSibling;
                 if(nextNode!=null)
                   _currentContainer.insertBefore(nextNode,_control);
                 break;
              case "left":
                 var leftContainer=_currentContainer.previousSibling;
                 if(leftContainer!=null){
                    leftContainer.appendChild(_control);                   
                 }  
                 break;
              case "right":
                 var rightContainer=_currentContainer.nextSibling;
                 if(rightContainer!=null){
                     rightContainer.appendChild(_control);                   
                 }
                break;          
           }
      } 
   }
    
   this.showSetTitle=function(_controlId){
      var _title_=(_titleObj_.firstChild).innerHTML;    
      _titleObj_.innerHTML="<input type=\"text\" value=\""+_title_+"\" style=\"width:100px;\" onblur='top.page.DragBoxMenu.EndTitleSet(\""+_controlId+"\")'/>";
      _titleObj_.firstChild.focus();
   }
   this.EndTitleSet=function(_controlId){    
      var m_newTitle=_titleObj_.firstChild.value;
     _titleObj_.innerHTML="<a href='"+_href_+"'>"+m_newTitle+"</a>";
     UpdateDragBox(_controlID_,1,m_newTitle);
   }
   this.addContent=function(){
     var _addContentObj=document.getElementById("addContent");
     _addContentObj.style.display="block";   
     _addContentObj.style.position="absolute";     
     _addContentObj.innerHTML="<div style=\"top:200px;left:200px;position:absolute;\"><table border='0' cellpadding='0' cellspacing='0' width=\"627px\" style=\"background=white;\"><tr><td style=\"background:url(Images/MySpace/add_new_top.gif); text-align:right;\" colspan='2'><img src=\"Images/MySpace/red_close_windows.gif\" onClick=\"top.page.DragBoxMenu.CloseAdd()\"/></td><td width=\"7px\"><img src=\"Images/MySpace/add_rss_top_right.gif\"/></td></tr><tr><td style=\"background:url(Images/MySpace/add_rss_left.gif) repeat-y;width:6px;\"></td><td style=\"border-top:solid 1px black;\">&nbsp;&nbsp;请输入RSS名称：<input type=\"text\" name=\"RssTitle\" id=\"RssTitle\"  style=\"width:300px\"/><br/>&nbsp;&nbsp;请输入RSS地址：<input type=\"text\" name=\"RssURl\" id=\"RssUrl\" style=\"width:300px\"/><br/><center><input type=\"button\" value=\"确定\" onclick=\"top.page.DragBoxMenu.addRss();\"/></center></td><td style=\"background:url(Images/MySpace/add_rss_left.gif) repeat-y;width:6px;\"></td></tr><tr><td style=\"width:6px; height:10px;\"><img src=\"Images/MySpace/add_rss_bottom_left.gif\"/></td><td style=\"background:url(Images/MySpace/add_rss_bottom_right.gif) repeat-x;\"></td><td style=\"width:6px; height:10px;\"><img src=\"Images/MySpace/add_rss_bottom_right2.gif\"/></td></tr></table></div>";
    
   }
   var _cookie_=new Cookie();   
   
   this.CloseAdd=function(){
     document.getElementById("addContent").style.display="none";
   }
   this.addRss=function(){
      var _rssUrl=document.getElementById("RssUrl").value;
      var _rssTitle=document.getElementById("RssTitle").value;
      if(_rssUrl==""||_rssTitle=="")
         alert("输入的标题或链接地址为空");
      else{
          if(_rssUrl.indexOf("http")!=0){
            alert("输入链接地址格式不正确");
            return;
          }
          document.getElementById("addContent").style.display="none";
         _cookie_.setCookie("RssUrl",_rssUrl);        
         var _cl=userChannel.length;        
         var _newObjId="DragBox_"+parseInt(Math.random()*10000);        
         userChannel[_cl]=new Array();       
         userChannel[_cl][0]= _newObjId;
		 userChannel[_cl][1]=_rssTitle;
		 userChannel[_cl][2]=_rssUrl;
		 userChannel[_cl][3]="10";
		 userChannel[_cl][4]="1";
		 userChannel[_cl][5]="0";
		 userChannel[_cl][6]="0";
		 userChannel[_cl][7]="0";
		 userChannel[_cl][8]="Rss";
		 userChannel[_cl][9]="0";
		 userChannel[_cl][10]="0";
		
		 var userChannelObj=CreateDragBox(userChannel[_cl]);
		 DragBoxArray.push(userChannelObj);
		 DragDrops[0].push(userChannelObj);		 
	//	 var _containerArray_=document.getElementsByClassName("DragContainer");		
		 _ContainerArray_[0].insertBefore(userChannelObj,_ContainerArray_[0].childNodes[0]);
		  CreateDragContainer();
		   SaveCurrnetLayout();
		
        
      }
   }
   
   this.showRss=function(obj,nums1,nums2){
      var tmouseOffset=getMouseOffset(obj,event); 
      var tmousePos = mouseCoords(event);    
      var _rss_dtl=rss_description[nums1][nums2];
      var _rss_show=document.getElementById("showRssDtl");
      var _titleObj=obj.previousSibling;
      var _rss_title=_titleObj.innerHTML;
      var _rss_href=_titleObj.getAttribute("href");    
       _rss_show.innerHTML="<table border='0' cellpadding='0' cellspacing='0' ><tr class=\"rss_detail_title\"><td>"+_rss_title+"</td><td><img src=\"Images/MySpace/deleteLink.gif\" onClick=\"top.page.DragBoxMenu.closeRssDetail();\"  onMouseOver=\"this.className='buttonActive';\" onMouseOut=\"this.className='buttonBlur';\"/></td></tr><tr><td colspan='2' class=\"rss_detail_content\">"+_rss_dtl+"</td></tr><tr><td colspan='2' style=\"text-align:center;\"><a href=\""+_rss_href+"\" target=\"_blank\">全文</a></td></tr></table>"; 
       _rss_show.style.position="absolute"; 
       _rss_show.style.display = "block";
      var _rssLeft; 
      if((event.x+350)>document.body.clientWidth) 
         _rssLeft=document.body.clientWidth-400;
      else 
         _rssLeft= event.x-50;
       _rss_show.style.left= _rssLeft;
       _rss_show.style.top =tmousePos.y-tmouseOffset.y+20;     
   }
   this.closeRssDetail=function(){
      var _rss_show=document.getElementById("showRssDtl");
      _rss_show.style.display="none";
   } 
}

function Page() {
	this.DragBoxMenu=new DragBoxMenu();
}

var page;
function navHover() {
  var lis = document.getElementById("navmenu").getElementsByTagName("LI");
  for (var i=0; i<lis.length; i++) {
    lis[i].onmouseover=function() {
      this.className+=" iehover";
    }
    lis[i].onmouseout=function() {
      this.className=this.className.replace(new RegExp(" iehover\\b"), "");
    }
  }
}

function setDisplay(showtype){
  var _myTitle=document.getElementById("myTitle");
  switch(showtype){
    case "default":
      _myTitle.className="myTitleblur";
      var now = new Date();
      var nextYear = new Date(now.getYear() + 1, now.getMonth(), now.getDate());
      var _cookie=new Cookie();
      _cookie.setCookie("MAllZ_myspace_title",_myTitle.value,nextYear);
      break;
    case "show":
       _myTitle.className="myTitileActive";
       break;
  }
  
}
