﻿<%@ page language="C#" autoeventwireup="true" inherits="Shop_UserShop, mallz" enableEventValidation="false" %>
<%@ Register tagPrefix="MZ" TagName="TextFormat" Src="../../UserControls/ProductTextFormat.ascx" %>
<html runat="server" id="myhtml"  visible="false" >
<head><title></title></head>
<body>
<form id="form_1" runat="server">

<!--编辑按纽-->
<asp:HyperLink ID="EditProduct" runat="server" >编辑</asp:HyperLink>

<!--店铺类目-->
    <asp:GridView ID="ShopClassList" border="0" style="border:0; width:100%;" AutoGenerateColumns="false" runat="server">
        <Columns>
        <asp:TemplateField>
            <ItemTemplate>
            <div style="line-height:25px;">·<%#Eval("ShopProductClassName")%></div>
            </ItemTemplate>
        </asp:TemplateField>
        </Columns>
        <EmptyDataTemplate><div style="line-height:25px;">·暂无类目！</div></EmptyDataTemplate>
    </asp:GridView>

<!--友情链接-->
    <asp:GridView ID="FriendLink" runat="server" Width="100%" BorderWidth="0" BorderStyle="Solid" AutoGenerateColumns="false">
        <Columns>
        <asp:TemplateField>
            <ItemTemplate>
            <div style="line-height:25px;">·<a href="<%# "/Shop/index.aspx?shopid="+Eval("shopid") +""%>" target="_blank" ><%#Eval("ShopName")%></a></div>
            </ItemTemplate>
        </asp:TemplateField>
        </Columns>
        <EmptyDataTemplate><div style="line-height:25px;">·暂无友情链接</div></EmptyDataTemplate>
    </asp:GridView>
    
<!--店铺推荐产品-->
    <asp:repeater ID="ShopEliteProductList" runat="server">
        <HeaderTemplate><table id="DataList2" class="view" cellspacing="0" border="0"><tr></HeaderTemplate>
        <ItemTemplate><td>
         <table><tr><td><a href='/ShowProduct.aspx?ProductID=<%#Eval("ProductID") %>' target="_blank"><img border="0" onerror="this.src='/images/nopicture.gif'" src='<%# Eval("ProductSmallImageUrl") %>' /></a></td></tr>
         <tr><td><a id="DataList2_ctl07_mProductName" href="/ShowProduct.aspx?ProductID=<%#Eval("ProductID") %>" title="<%#Eval("ProductName") %>" target="_blank"><%#Eval("ProductName") %></a></td></tr>
         </table>
        </td></ItemTemplate>
        <FooterTemplate></tr></table></FooterTemplate>
    </asp:repeater>
    
<!--店铺产品-->
<asp:repeater ID="ShopProductList" runat="server" EnableViewState="false">
    <HeaderTemplate>
    <table id="DataList2" class="view" cellspacing="0" border="0"><tr>
    </HeaderTemplate>
    <ItemTemplate>
    <%#((Container.ItemIndex % 5) == 0 && Container.ItemIndex!=0) ? "</tr><tr>" : ""%>
    <td style="width:20%;">
       <ul>
          <li class="shopImg"><a href='/ShowProduct.aspx?ProductID=<%#Eval("ProductID") %>' target="_blank">
             <img border="0" onerror="this.src='/images/nopicture.gif'" src='<%# Eval("ProductSmallImageUrl") %>' /></a><li>
          <li class="shopTitle">
             <a id="DataList2_ctl07_mProductName" href="/ShowProduct.aspx?ProductID=<%#Eval("ProductID") %>" title="<%#Eval("ProductName") %>" target="_blank"><%#Eval("ProductName") %></a></li>
          <li class="shopPrize">
             <span id="DataList2_ctl07_ProducType" class="product_type_style"><%# MallZ.Web.Shop.TextFormat.GetProductType(Eval("ProductType").ToString()) %></span>:<span id="DataList2_ctl07_Label5" class="product_price_style"><%#Eval("CurrentPrice")%></span>
          </li>     
          <li class="shopDay" > 
              <span id="DataList2_ctl07_LabMoreThenDay">剩余时间：<MZ:TextFormat runat="server" ID="TextFormat0" Text="LeftTime" Value='<%# Eval("EndDate") + "|" +Eval("NoLimitDate")%>' /></span>
          </li>
          <li></li>
      </ul>
   </td>
    </ItemTemplate>
    <FooterTemplate>
    </tr></table>
    </FooterTemplate>
</asp:repeater>

<!--卖家信用评价-->
    <asp:GridView ID="SalerReview" Visible="false" runat="server" AutoGenerateColumns="False" CssClass="ReviewTableStyle">
    <Columns>
        <asp:TemplateField HeaderText="等级">
            <ItemTemplate>
                <asp:Image ID="Image1" runat="server" ImageUrl='<%# Bind("StarImageURL") %>' />
            </ItemTemplate>
        </asp:TemplateField>
        <asp:BoundField DataField="rday" HeaderText="当天" />
        <asp:BoundField DataField="rweek" HeaderText="最近一个星期" />
        <asp:BoundField DataField="rmonth" HeaderText="最近一个月" />
        <asp:BoundField DataField="rmonth" HeaderText="最近六个月" />
        <asp:BoundField DataField="ryear" HeaderText="当年" />
        <asp:BoundField DataField="CountStar" HeaderText="总计" />
    </Columns>
    </asp:GridView>
    
<!--买家信用评价-->
    <asp:GridView ID="BuyerReview" Visible="false" runat="server" AutoGenerateColumns="False" CssClass="ReviewTableStyle">
    <Columns>
        <asp:TemplateField HeaderText="等级">                
            <ItemTemplate>
                <asp:Image ID="Image1" runat="server" ImageUrl='<%# Bind("StarImageURL")%>' />
            </ItemTemplate>
        </asp:TemplateField>
        <asp:BoundField DataField="rday" HeaderText="当天" />
        <asp:BoundField DataField="rweek" HeaderText="最近一个星期" />
        <asp:BoundField DataField="rmonth" HeaderText="最近一个月" />
        <asp:BoundField DataField="rmonth" HeaderText="最近六个月" />
        <asp:BoundField DataField="ryear" HeaderText="当年" />
        <asp:BoundField DataField="CountStar" HeaderText="总计" />
    </Columns>  
    </asp:GridView>

<!--信用评价信息列表-->
    <asp:GridView ID="ReviewList" Visible="false" runat="server" AutoGenerateColumns="False"  CssClass="ReviewListStyle" EnableViewState="false"  BorderWidth="0" Width="100%">
        <Columns>
           <asp:TemplateField >
              <ItemTemplate>
                 <img src='<%# Eval("ReviewStarImageURL") %>' />
                <span><asp:Literal ID="ReviewStar" runat="server" Text='<%# Eval("NickReviewStar") %>' /></span>
              </ItemTemplate> 
              <HeaderStyle Width="20%" />
           </asp:TemplateField>
           <asp:TemplateField HeaderText="评价人">
              <ItemTemplate>
                  <asp:Literal ID="Label8" runat="server" Text='<%# Eval("PurchaserBargainorSize ") %>'/>：　
                   <asp:HyperLink ID="HyperLink1" Text='<%# Eval("UserName") %>' NavigateUrl='<%#"Shop_ShopIntro.aspx?UserID="+Eval("userID")%>' Target="_blank" runat="server" />
              </ItemTemplate>
              <HeaderStyle Width="20%" /> 
           </asp:TemplateField>
           <asp:TemplateField HeaderText="商品名称">
              <ItemTemplate>
                  <asp:HyperLink ID="ProductName" Text='<%# Eval("ProductName") %>' NavigateUrl='<%#"../Auction/Auction.aspx?ProductID="+Eval("ProductID")%>' Target="_blank" runat="server"  /><br />                    
                  <asp:Label ID="ProductPrice" runat="server" Text='<%# Eval("ProductPrice")+"元" %>' ForeColor="orangered"/>&nbsp;
              </ItemTemplate>
              <HeaderStyle Width="30%" /> 
           </asp:TemplateField>
           <asp:TemplateField HeaderText="评价内容">
              <ItemTemplate>
                 <asp:Literal ID="Label7" runat="server" Text='<%# Eval("ReviewContent") %>' /> 
              </ItemTemplate>
               <HeaderStyle Width="30%" /> 
           </asp:TemplateField>
        </Columns>
        <AlternatingRowStyle CssClass="ReviewAlterStyle" />
        <EmptyDataTemplate>
           <div style="text-align:center; height:30px; line-height:30px;">暂无评价！</div>
        </EmptyDataTemplate>
     </asp:GridView>
     
      <!--留言内容-->
    　<asp:TextBox ID="TxtMessage" runat="server" Height="100px" TextMode="MultiLine" MaxLength="400" Width="95%"/><br />
        <!--验证码-->
        <asp:TextBox ID="CheckCode" runat="server" MaxLength="5" Width="50px"/>　
        
          <!--留言查看-->
    <asp:GridView ID="ShopAllMessage" runat="server" AutoGenerateColumns="False" DataSourceID="ShopAllMessageObjds"  CssClass="BrowseMsgStyle" AllowPaging="True"  DataKeyNames="M_ID"  PageSize="20" OnDataBound="ShopAllMessageObjds_OnDataBound" EnableViewState="False" GridLines="None">
          <Columns>
            <asp:TemplateField HeaderText="发言人及时间">
                <ItemTemplate>
                      <b><asp:HyperLink ID="SenderName" runat="server" NavigateUrl='<%#"Shop_Review.aspx?UserID="+Eval("M_UserID") %>' Text='<%# Eval("M_SenderName") %>' Target="_blank" /></b><br />
                      <asp:Literal ID="LabM_DateTime" runat="server" Text='<%# Eval("M_DateTime") %>' />                      
                      <asp:HiddenField ID="R_ID" runat="server" Value='<%# Eval("R_ID") %>' />             
                </ItemTemplate>
                <ItemStyle Width="20%" CssClass="SenderStyle"/>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="内容">
                <ItemTemplate>
                    <asp:Literal ID="SenderContent" Text='<%# Eval("M_CONTENT") %>' runat="server" />
                    <br />
                    <span><asp:Literal ID="ReplayContent" Text='<%# Eval("R_Content") %>' runat="server" /></span>
                    <asp:HiddenField ID="SalerID" runat="server" Value='<%# Eval("SenderID") %>' />
                    <asp:LinkButton ID="delReply" runat="server" CausesValidation="False" CommandName="Delete" Visible="false" Text="删除"  OnClientClick="return confirm('确定要删除此留言吗？');"></asp:LinkButton>
                </ItemTemplate>
                <ItemStyle Width="80%"/>
            </asp:TemplateField>    
          </Columns>
          <EmptyDataTemplate>
             <table class="BrowseMsgStyle">
                <tr>
                   <th Width="20%" >发言人及时间</th>
                   <th Width="80%">内容</th>                                 
                </tr>
                <tr>
                   <td colspan="2" style="text-align:center;">暂无留言！</td>
                </tr>
             </table>
          </EmptyDataTemplate>  
      </asp:GridView>
      
    <asp:ObjectDataSource ID="ShopAllMessageObjds" runat="server" SelectMethod="GetMessageByShopIDLately" TypeName="MallZ.Data.Shop_Message"  DeleteMethod="DeleteMessage">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="ShopID" QueryStringField="ShopID" Type="Int32" />
            <asp:Parameter DefaultValue="all" Name="MessageType" Type="String" />
        </SelectParameters>
        <DeleteParameters>
            <asp:Parameter  DefaultValue="0" Name="M_ID" Type="Int32"/>
        </DeleteParameters>
    </asp:ObjectDataSource>

</form>
</body>
</html>