using System;
using System.Collections.Generic;
using System.Text;
using IDDal;
using Model;
using System.Data.Common;
using System.Data;
using System.Data.SqlClient;
namespace ImpDDal
{
    public class ImpMenuDal:DbCommandStore,MenuDal<Menu>
    {
        #region MenuDal<Menu> Ա
        DbCommand cmd = GetCommand();

        #region ӵȷ
        public int AddMenu(IList<Menu> menus)
        {
            cmd.CommandText = "INSERT INTO UT_Menu(MeunId,MenuItems) VALUES(@MI,@MIems)";
            SqlParameter[] p = new SqlParameter[2];
            p[0]=new SqlParameter("MI",DbType.Guid);
            p[1] = new SqlParameter("MIems", DbType.Int64);

            cmd.Parameters.Add(p[0]);
            cmd.Parameters.Add(p[1]);

            int i = 0;
            DbTransaction transaction=null;
            try
            {
                if(cmd.Connection.State==ConnectionState.Closed)
                 cmd.Connection.Open();
                transaction = cmd.Connection.BeginTransaction(IsolationLevel.Serializable);
                cmd.Transaction = transaction;
                foreach (Menu m in menus)
                {
                    p[0].Value = m.MenuId;
                    p[1].Value = m.MenuItems;
                    i+=cmd.ExecuteNonQuery();
                }
                transaction.Commit();
                return i;
            }
            catch (Exception ex)
            {
                transaction.Rollback();
                throw new Exception("Ӳ˵ϸʧ" + ex.Message);
                
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }
        #endregion

        #region ɾ˵в
        public int DeleteMenu(Menu menu)
        {
            cmd.CommandText = "DELETE FROM UT_Menu WHERE MeunId=@MI";
            SqlParameter p = new SqlParameter("MI",DbType.Guid);
            p.Value = menu.MenuId;
            cmd.Parameters.Add(p);
            DbTransaction transaction=null;
            try
            {
                if(cmd.Connection.State==ConnectionState.Closed)
                cmd.Connection.Open();
                transaction = cmd.Connection.BeginTransaction(IsolationLevel.Serializable);
                cmd.Transaction = transaction;
                int i = cmd.ExecuteNonQuery();
                transaction.Commit();
                return i;
               
            }
            catch (Exception ex)
            {
                cmd.Transaction.Rollback();
                throw new Exception("ɾ˵ϸʧ" + ex.Message);

            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }

        #endregion

        #region ༭˵µĲ
        public int EditMenu(Menu menu)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        #endregion

        #region ѯ˵µв
        public IList<Menu> Menus(string menuId)
        {
            cmd.CommandText = "SELECT * FROM UT_Menu WHERE MeunId=@MI";
            cmd.Parameters.Add(menuId);
            try
            {
                cmd.Connection.Open();
                DbDataReader reader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                List<Menu> list = new List<Menu>();
                Menu menu = null;
                while (reader.Read())
                {
                    menu = new Menu(reader.GetValue(0).ToString(), reader.GetValue(1).ToString());
                    list.Add(menu);
                }
                return list;
            }
            catch (Exception ex)
            {
                throw new Exception("ѯ˵ϸʧ" + ex.Message);
            }
            finally
            {
                cmd.Connection.Close();
            }
        }
        #endregion

        #endregion
    }
}
