using System;
using System.Collections.Generic;
using System.Text;
using Model;
using System.Data.Common;
using System.Data.SqlClient;
namespace ImpDDal
{
    public class ImpNews:DbCommandStore,IDDal.INews<News>
    {
        #region INews<News> Ա
        DbCommand cmd = GetCommand();

        #region ȡҳŶ
        public IList<News> GetIndexNews()
        {
            cmd.CommandText = "SELECT Top 4 * FROM UT_News ORDER BY PublishTime DESC";
            List<News> list = new List<News>();
            try
            {
                if (cmd.Connection.State == System.Data.ConnectionState.Closed)
                    cmd.Connection.Open();
                DbDataReader reader = cmd.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
                while (reader.Read())
                {
                    News news = new News(long.Parse(reader.GetValue(0).ToString()), reader.GetString(1), reader.GetString(2),reader.GetDateTime(3));
                    list.Add(news);
                }
                reader.Close();
                return list;
            }
            catch (Exception ex)
            {

                throw new Exception(ex.Message);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }

        }
        #endregion

        #region ȡб
        public IList<News> GetAllNews()
        {
            cmd.CommandText = "SELECT * FROM UT_News ORDER BY PublishTime DESC";
            List<News> list = new List<News>();
            try
            {
                if (cmd.Connection.State == System.Data.ConnectionState.Closed)
                    cmd.Connection.Open();
                DbDataReader reader = cmd.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
                while (reader.Read())
                {
                    News news = new News(long.Parse(reader.GetValue(0).ToString()), reader.GetString(1), reader.GetString(2),reader.GetDateTime(3));
                    list.Add(news);
                }
                reader.Close();
                return list;
            }
            catch (Exception ex)
            {

                throw new Exception(ex.Message);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }
        #endregion

        #region һ
        public int AddNews(News oneNews)
        {
            cmd.CommandText = "INSERT INTO UT_News(Title,Context) VALUES(@t,@c)";
            SqlParameter[] p = new SqlParameter[2];
            p[0] = new SqlParameter("t", oneNews.Title);
            p[1] = new SqlParameter("c", oneNews.Context);
            cmd.Parameters.Add(p[0]);
            cmd.Parameters.Add(p[1]);
            try
            {
                if (cmd.Connection.State == System.Data.ConnectionState.Closed)
                    cmd.Connection.Open();
                return cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {

                throw new Exception(ex.Message);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }
        #endregion

        #region ɾһż¼
        public int DeleteNew(News oneNews)
        {
            cmd.CommandText = "DELETE  FROM UT_News WHERE SystemId=@id";
            SqlParameter p = new SqlParameter("id",oneNews.SystemId);
            cmd.Parameters.Add(p);
            try
            {
                if (cmd.Connection.State == System.Data.ConnectionState.Closed)
                    cmd.Connection.Open();
                return cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {

                throw new Exception(ex.Message);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }
        #endregion

        #region ɾż¼
        public int DeleteNews(IList<News> someNews)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        #endregion

        #region ༭ż¼
        public int EditNews(News oneNews)
        {
            cmd.CommandText = "UPDATE UT_News SET Title=@t,Context=@c WHERE SystemId=@id";
            SqlParameter[] p = new SqlParameter[3];
            p[0] = new SqlParameter("t", oneNews.Title);
            p[1] = new SqlParameter("c", oneNews.Context);
            p[2] = new SqlParameter("id", oneNews.SystemId);
            cmd.Parameters.Add(p[0]);
            cmd.Parameters.Add(p[1]);
            cmd.Parameters.Add(p[2]);

            try
            {
                if (cmd.Connection.State == System.Data.ConnectionState.Closed)
                    cmd.Connection.Open();
                return cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {

                throw new Exception(ex.Message);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }
        #endregion

        #region ʾһ
        public News ShowNews(News news)
        {
            cmd.CommandText = "SELECT * FROM UT_News WHERE SystemId=@id";
            SqlParameter p = new SqlParameter("id", news.SystemId);
            cmd.Parameters.Add(p);
            News oneNews = null;
            try
            {
                if (cmd.Connection.State == System.Data.ConnectionState.Closed)
                    cmd.Connection.Open();
                DbDataReader reader = cmd.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
                while (reader.Read())
                {
                    oneNews = new News(long.Parse(reader.GetValue(0).ToString()), reader.GetString(1), reader.GetString(2), reader.GetDateTime(3));

                }
                return oneNews;
            }
            catch (Exception ex)
            {

                throw new Exception(ex.Message);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }
        #endregion

        #endregion
    }
}
