﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_MenuMange : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Ajax.Utility.RegisterTypeForAjax(this.GetType());
        this.ClientScript.RegisterClientScriptInclude("ggg", "js/JSMenu.js");
        this.menuList.DataSource = new EMenuType().GetAdminType();
        this.menuList.DataBind();
    }
    /// <summary>
    /// 获取菜单类型
    /// </summary>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetTypes()
    {
        EItemTyps type = new EItemTyps();
        return type.GetItemList();
    }
    /// <summary>
    /// 获取菜单某个类型下的菜肴
    /// </summary>
    /// <param name="typeId">菜单类型</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetItems(string typeId)
    {
        EItem item = new EItem();
        return item.SelectItems(int.Parse(typeId));
    }
    /// <summary>
    /// 增加菜单
    /// </summary>
    /// <param name="itemsList">菜肴字符串</param>
    /// <param name="title">菜单标题</param>
    /// <param name="detail">详细介绍</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int AddMenu(string itemsList, string title, string detail)
    {
        EMenuType menuType = new EMenuType();
        return menuType.AddMenu(itemsList, title, detail);
    }
    /// <summary>
    /// 获取某个菜单的详细内容
    /// </summary>
    /// <param name="menuId">菜单ID</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetMenu(string menuId)
    {
        EMenuType menuType = new EMenuType();
        return menuType.GetDetailMenu(menuId);
    }
    /// <summary>
    /// 获取菜单信息
    /// </summary>
    /// <param name="menuId"></param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetMenuInfo(string menuId)
    {
        EMenuType menuType = new EMenuType();
        return menuType.GetDetailMenuInfo(menuId);
    }
    /// <summary>
    /// 编辑菜单信息
    /// </summary>
    /// <param name="menuId">菜单ID</param>
    /// <param name="itemsList">菜肴字符串</param>
    /// <param name="title">菜单标题</param>
    /// <param name="detail">详细介绍</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int EditMenu(string menuId,string itemsList, string title, string detail)
    {
        EMenuType menuType = new EMenuType();
        return menuType.EditMenu(menuId, itemsList, title, detail);
    }
}
