﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
//该源码下载自www.51aspx.com(５１ａｓｐｘ．ｃｏｍ)

public partial class Admin_NewMange : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Ajax.Utility.RegisterTypeForAjax(this.GetType());
        this.ClientScript.RegisterClientScriptInclude("ggg", "js/JSNews.js");
        this.newsList.DataSource = new ENews().GetAllNews;
        this.newsList.DataBind();
    }
    /// <summary>
    /// 删除新闻
    /// </summary>
    /// <param name="systemId">新闻ID</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int DeleteNew(string systemId)
    {
        ENews news = new ENews();
        return news.Delete(systemId);
    }
    /// <summary>
    /// 显示一条新闻
    /// </summary>
    /// <param name="systemId">新闻ID</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string ShowOne(string systemId)
    {
        ENews news = new ENews();
        return news.ShowOne(systemId);
    }
    /// <summary>
    /// 编辑一条新闻
    /// </summary>
    /// <param name="systemId">新闻ID</param>
    /// <param name="title">新闻标题</param>
    /// <param name="txt">正文</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int EditOneNews(string systemId,string title,string txt)
    {
        ENews news = new ENews();
        return news.EditNews(systemId,title,txt);
    }
    /// <summary>
    /// 增加一条新闻
    /// </summary>
    /// <param name="title">新闻标题</param>
    /// <param name="txt">正文</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int AddOneNews(string title, string txt)
    {
        ENews news = new ENews();
        return news.AddNews(title, txt);
    }

}
