﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_RenewCook : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Ajax.Utility.RegisterTypeForAjax(this.GetType());
        this.FileUpload1.Attributes.Add("onchange","Preview()");
        this.FileUpload1.ID = "itemPicUrl";
        this.itemTypeList.DataSource = new EItemTyps().GetItemTypes();
        this.itemTypeList.DataBind();
        this.ClientScript.RegisterClientScriptInclude("ggg", "js/JSItem.js");
        if (Request.QueryString["id"]!=null)
            ShowItem(Request);
        if (IsPostBack)
        {
            if (Request.QueryString["Edit"] == null)
                AddItem(Request);
            else
                EditItem(Request);
        }
    }
    /// <summary>
    /// 
    /// </summary>
    /// <param name="requst"></param>
    protected void ShowItem(HttpRequest requst)
    {
        int itemTypeId = int.Parse(requst.QueryString["id"].ToString());
        this.itemList.DataSource = new EItem().SelectItemList(itemTypeId);
        this.itemList.DataBind();
    }
    /// <summary>
    /// 增加一个菜肴
    /// </summary>
    /// <param name="requst"></param>
    protected void AddItem(HttpRequest requst)
    {
        //菜肴所在类型
        string type = requst.Form["itemTypeLists"].ToString();
        //菜肴名称
        string name = requst.Form["itemName"].ToString();
        //价格
        string price = requst.Form["itemPrice"].ToString();
        //备注,说明
        string mark = requst.Form["context"].ToString();
        //文件扩展名
        string extend = requst.Form["iType"].ToString();
        try
        {
            string file=DateTime.Now.ToFileTime().ToString() + "." + extend;
            this.FileUpload1.SaveAs(HttpContext.Current.Server.MapPath("../Items/" + type+"/") +file );
            EItem item = new EItem();
            item.AddItem(name, price, mark, file, type);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
        }

    }
    /// <summary>
    /// 修改一个菜肴
    /// </summary>
    /// <param name="requst"></param>
    protected void EditItem(HttpRequest requst)
    {
        //菜肴类型
        string type = requst.Form["itemTypeLists"].ToString();
        //菜肴名称
        string name = requst.Form["itemName"].ToString();
        //价格
        string price = requst.Form["itemPrice"].ToString();
        //备注
        string mark = requst.Form["context"].ToString();
        //文件扩展名
        string extend = requst.Form["iType"].ToString();
        //菜肴ID
        string systemId = requst.Form["itemId"].ToString();
        //修改前的图片地址
        string itemOldPic = requst.Form["itemOldPic"].ToString();
        try
        {
            string file="";
            if (extend != "")
            {
                file = DateTime.Now.ToFileTime().ToString() + "." + extend;
                this.FileUpload1.SaveAs(HttpContext.Current.Server.MapPath("../Items/" + type + "/") + file);
            }
            else
                file = itemOldPic;
            EItem item = new EItem();
            item.EditItem(systemId,name, price, mark, file, type);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
        }

    }
    /// <summary>
    /// 删除一个菜肴
    /// </summary>
    /// <param name="systemId">菜肴ID</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int DeleteItem(string systemId)
    {
        EItem item = new EItem();
        return item.DeleteItem(systemId);
    }
    /// <summary>
    /// 修改菜肴所属类型
    /// </summary>
    /// <param name="systemId">菜肴ID</param>
    /// <param name="itemType">要改变的类别</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int AlterType(string systemId, string itemType)
    {
        EItem item = new EItem();
        return item.AlterType(systemId,itemType);
    }
    /// <summary>
    /// 获取菜肴的全部类别
    /// </summary>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetTypes()
    {
        EItemTyps type = new EItemTyps();
        return type.GetItemList();
    }
    /// <summary>
    /// 获取一个菜肴的信息
    /// </summary>
    /// <param name="systemId">菜肴编号</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetItem(string systemId)
    {
        EItem item = new EItem();
        return item.SelectOneItem(long.Parse(systemId));
    }

}
