﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Business;
using Model;
using System.Collections;
using System.Text;
using System.Collections.Generic;

/// <summary>
/// 菜肴的评论信息展现层
/// </summary>
public class EItemMsg
{
    BItemMsg bItemMsg = new BItemMsg();
    /// <summary>
    /// 虚构函数
    /// </summary>
    public EItemMsg()
    {
        //
        // TODO: 在此处添加构造函数逻辑
        //
    }
    /// <summary>
    /// 增加一条菜肴评论
    /// </summary>
    /// <param name="itemId">菜肴ID</param>
    /// <param name="comment">评论的内容</param>
    /// <returns>1表示增加成功,0表示增加失败</returns>
    public int AddItemMsg(string itemId, string comment)
    {
        if (HttpContext.Current.User.Identity.IsAuthenticated)
        {
            try
            {
                ItemMsg itemMsg = new ItemMsg(long.Parse(itemId), HttpContext.Current.User.Identity.Name, comment, HttpContext.Current.Request.UserHostAddress);
                return bItemMsg.AddItemMsg(itemMsg);
            }
            catch (Exception ex)
            {
                WebConvert.JScript.JsAlert(ex.Message);
                return 0;
            }
        }
        else
            return 0;
    }
    /// <summary>
    /// 获取当评论处理字符串
    /// </summary>
    /// <param name="itemId">菜肴ID</param>
    /// <returns>评论字符串</returns>
    public string GetItemMsg(string itemId)
    {
        IList<ItemMsg> list = null;
        StringBuilder txt = new StringBuilder();
        try
        {
            list = bItemMsg.GetItemMsg(long.Parse(itemId));
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return String.Empty;
        }
        foreach(ItemMsg itemMsg in list)
        {
            txt.Append(itemMsg.Username + "*" + itemMsg.Comment + "*" + itemMsg.Date+"|");
        }
        return txt.ToString();
    }
}
