﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Business;
using Model;
using System.Text;
/// <summary>
/// 菜肴类型展现层方法
/// </summary>
public class EItemTyps
{
    BItemType itemType = new BItemType();
    /// <summary>
    /// 虚构函数
    /// </summary>
    public EItemTyps()
    {
        //
        // TODO: 在此处添加构造函数逻辑
        //
    }
    /// <summary>
    /// 获取全部菜肴类别
    /// </summary>
    /// <returns>菜肴类别列表</returns>
    public IList<ItemType> GetItemTypes()
    {

        try
        {
            return itemType.GetItemTypes();
        }
        catch (Exception ex)
        {

            WebConvert.JScript.JsAlert(ex.Message);
            return null;
        }
    }
    /// <summary>
    /// 获取全部菜肴类别(字符串)
    /// </summary>
    /// <returns>菜肴类别列表</returns>
    public string GetItemList()
    {
        StringBuilder txt = new StringBuilder();
        try
        {
            IList<ItemType> list=itemType.GetItemTypes();
            foreach (ItemType type in list)
            {
                txt.Append(type.ItemTypeId+","+type.TypeName+"|");
            }
            return txt.ToString();
        }
        catch (Exception ex)
        {

            WebConvert.JScript.JsAlert(ex.Message);
            return "";
        }
    }


}
