﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Business;
using Model;
using System.Text;
/// <summary>
/// 菜肴操作的展现层
/// </summary>
public class EItem
{
    BItem item = new BItem();
    /// <summary>
    /// 虚构函数
    /// </summary>
    public EItem()
    {
        //
        // TODO: 在此处添加构造函数逻辑
        //
    }
    /// <summary>
    /// 列出最新的4道菜肴
    /// </summary>
    /// <returns>菜肴列表</returns>
    public IList<Item> SelectItemIndex()
    {
        try
        {
            return item.SelectNewItem();
        }
        catch (Exception ex)
        {
            
            throw new Exception(ex.Message);
        }
    }
    /// <summary>
    /// 根据菜肴类型和选择条数,返回菜肴列表
    /// </summary>
    /// <param name="type">菜肴类型</param>
    /// <param name="top">选择数目</param>
    /// <returns>菜肴列表</returns>
    public IList<Item> SelectItemSub(int type,int top)
    {
        try
        {
            return item.SelectSubItem(type,top);
        }
        catch (Exception ex)
        {

            throw new Exception(ex.Message);
            return null;
        }
    }
    /// <summary>
    /// 根据菜肴类型返回菜肴列表
    /// </summary>
    /// <param name="type">菜肴类型</param>
    /// <returns>菜肴列表</returns>
    public IList<Item> SelectItemList(int type)
    {
        return item.Select(type);
    }
    /// <summary>
    /// 根据菜肴类型返回菜肴列表FOR AJAX(用,分割)
    /// </summary>
    /// <param name="type">菜肴类型</param>
    /// <returns>菜肴列表字符串</returns>
    public string SelectItems(int type)
    {
        StringBuilder txt=new StringBuilder();
        IList<Item> list=item.Select(type);
        foreach (Item _item in list)
        {
            txt.Append(_item.ItemName + "," + _item.SystemId+",Items/"+_item.Type+"/"+_item.Pic+","+_item.Type+","+_item.Price+"|");
        }
        return txt.ToString();
    }

    /// <summary>
    /// 根据菜肴编号返回一个菜肴的信息(用*分割)
    /// </summary>
    /// <param name="systemId">菜肴编号</param>
    /// <returns>菜肴信息字符串</returns>
    public string SelectOneItem(long systemId)
    {
        StringBuilder txt=new StringBuilder();
        Item oneItem = item.SelectOneItem(systemId);
        txt.Append(oneItem.ItemName + "*");
        txt.Append(oneItem.Price + "*");
        txt.Append("Items/"+oneItem.Type+"/"+oneItem.Pic + "*");
        txt.Append(oneItem.Detail+"*");
        txt.Append(oneItem.Type);
        return txt.ToString();
    }
    /// <summary>
    /// 删除一道菜肴
    /// </summary>
    /// <param name="systemId">菜肴编号</param>
    /// <returns>1表示删除成功,0表示删除失败</returns>
    public int DeleteItem(string systemId)
    {
        try
        {
            Item oneItem = new Item(long.Parse(systemId));
            return item.DeleteItem(oneItem);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 修改菜肴所在类别
    /// </summary>
    /// <param name="systemId">菜肴编号</param>
    /// <param name="itemType">要修改的类别</param>
    /// <returns>1表示修改成功,0表示修改失败</returns>
    public int AlterType(string systemId, string itemType)
    {
        try
        {
            Item oneItem = new Item(long.Parse(systemId),int.Parse(itemType));
            return item.ModifyItemType(oneItem);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 增加一个新的菜肴
    /// </summary>
    /// <param name="itemName">菜肴名字</param>
    /// <param name="itemPrice">价格</param>
    /// <param name="itemContxt">介绍</param>
    /// <param name="itemPic">图片</param>
    /// <param name="itemType">类型</param>
    /// <returns></returns>
    public int AddItem(string itemName,string itemPrice,string itemContxt,string itemPic,string itemType)
    {
        try
        {
            Item oneItem = new Item(itemName, float.Parse(itemPrice),int.Parse(itemType),itemPic,itemContxt);
            return item.AddItem(oneItem);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 修改一道菜肴
    /// </summary>
    /// <param name="systemId">菜肴编号</param>
    /// <param name="itemName">菜肴名称</param>
    /// <param name="itemPrice">菜肴价格</param>
    /// <param name="itemContxt">介绍</param>
    /// <param name="itemPic">图片</param>
    /// <param name="itemType">类型</param>
    /// <returns></returns>
    public int EditItem(string systemId,string itemName, string itemPrice, string itemContxt, string itemPic, string itemType)
    {
        try
        {
            Item oneItem = new Item(long.Parse(systemId),itemName, float.Parse(itemPrice), int.Parse(itemType), itemPic, itemContxt);
            return item.ModifyItem(oneItem);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 搜索菜肴FOR 搜索框
    /// </summary>
    /// <param name="key">关键字</param>
    /// <returns>菜肴字符串信息</returns>
    public string SearchItem(string key)
    {
        StringBuilder txt=new StringBuilder();
        IList<Item> list = item.Select(key);
        int i = 0;
        foreach (Item _item in list)
        {
            txt.Append(_item.ItemName+",");
            i++;
            if (i > 5)
                break;
            
        }
        txt.Append("---------总共找到"+list.Count+"个相似项目------------");
        return txt.ToString();
    }
    /// <summary>
    /// 搜索菜肴显示
    /// </summary>
    /// <param name="key">关键字</param>
    /// <returns>菜肴字符串信息</returns>
    public string SearchItems(string key)
    {
        StringBuilder txt = new StringBuilder();
        IList<Item> list = item.Select(key);
        foreach (Item _item in list)
        {
            txt.Append(_item.ItemName + "*Items/"+_item.Type+"/"+_item.Pic+"*"+_item.SystemId+"|");

        }
        return txt.ToString();
    }
    /// <summary>
    /// 
    /// </summary>
    /// <returns></returns>
    public string ItemRandom()
    {
        StringBuilder txt = new StringBuilder();
        IList<Item> list = item.SelectRandom(6);
        foreach (Item _item in list)
        {
            txt.Append(_item.ItemName + "*Items/" + _item.Type + "/" + _item.Pic + "*" + _item.SystemId + "|");

        }
        return txt.ToString();
    }

    public IList<Item> HotItems()
    {
        return item.SelectHotItems();
    }
}
