﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Business;
using Model;
using System.Collections;
using System.Collections.Generic;
using System.Text;
/// <summary>
/// 订单业务的展现层
/// </summary>
public class EOrder
{
    BOrder bOrderOp = new BOrder();
    /// <summary>
    /// 虚构函数
    /// </summary>
    public EOrder()
    {
        //
        // TODO: 在此处添加构造函数逻辑
        //
    }
    /// <summary>
    /// 增加一笔订单
    /// </summary>
    /// <param name="orderMenuId">菜单号</param>
    /// <param name="orderNo">桌数</param>
    /// <param name="orderTime">预定执行时间</param>
    /// <param name="orderMark">备注</param>
    /// <returns>订单号</returns>
    public string AddOrder(string orderMenuId,int orderNo,string orderTime,string orderMark)
    {
        Order order = new Order(orderMenuId, orderNo, HttpContext.Current.User.Identity.Name, DateTime.Parse(orderTime), orderMark);
        try
        {
            
            string id=bOrderOp.AddOrder(order);
            this.GetOneOreder(order.Menuid,order.LoginName);
            return id;

        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return "";
        }
    }
    /// <summary>
    /// 获取我曾经定过的订单列表
    /// </summary>
    /// <returns>订单列表</returns>
    public IList<Order> GetMyOrder()
    {
        IList<Order> list=null;
        try
        {
            list = bOrderOp.GetOrder(HttpContext.Current.User.Identity.Name);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
        }
        return list;
    }
    /// <summary>
    /// 邮件构造及发送邮件
    /// </summary>
    /// <param name="menuId">菜单号</param>
    /// <param name="userId">用户ID</param>
    public void GetOneOreder(string menuId,string userId)
    {
        EMenuType menutype = new EMenuType();
        StringBuilder txt = new StringBuilder();
        EUser user = new EUser();
        string[] users=user.GetUserInfo(userId).Split(new char[] { ',' });
        txt.AppendLine(users[2]);
        txt.AppendLine(users[3]);
        string[] menu=menutype.GetDetailMenuInfo(menuId).Split(new char[] { '*' });
        txt.AppendLine(menu[0]);
        string[] temp = menutype.GetDetailMenu(menuId).Split(new char[]{'|'});
        for (int i = 0; i < temp.Length - 1; i++)
        {
            string[] data = temp[i].Split(new char[] { '*' });
            txt.AppendLine(data[0]+"    "+data[1]);
        }
        WebConvert.SendEmail.SendEmailTxt(users[2]+"的订单", txt.ToString());
    }
}
