﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Business;
using Model;
using WebConvert;
using System.Collections;
using System.Collections.Generic;
using System.Security.Principal;
using System.Web.Configuration;
/// <summary>
/// 用户操作的展现层
/// </summary>
public class EUser
{
    BUser userlogic = new BUser();
    /// <summary>
    /// 注册一个新用户
    /// </summary>
    /// <param name="userName">用户名字</param>
    /// <param name="userPwd">用户密码</param>
    /// <param name="sex">性别</param>
    /// <param name="displayName">显示的名字</param>
    /// <param name="mark">备注</param>
    /// <param name="contact">正文</param>
    /// <param name="tel">电话</param>
    public EUser(string userName,string userPwd,string sex,string displayName,string mark,string contact,string tel)
    {
        User newUser = new User(userName, userPwd, sex, displayName,mark,contact,tel);
        try
        {
            userlogic.CreateUser(newUser);
            JScript.JsAlert("注册新用户成功，请等待管理员批准");
        }
        catch (Exception ex)
        {

            JScript.JsAlert(ex.Message);
        }
    }
    /// <summary>
    /// 虚构函数
    /// </summary>
    public EUser()
    {

    }
    /// <summary>
    /// 删除一个用户
    /// </summary>
    /// <param name="userName">用户登陆名字</param>
    /// <returns>1表示删除成功,-1表示删除失败</returns>
    public int DelUser(string userName)
    {
        User user = new User();
        user.LoginName = userName;
        try
        {
            return userlogic.DeleteUser(user);
        }
        catch (Exception ex)
        {
            
            JScript.JsAlert(ex.Message);
            return -1;
        }
    }
    /// <summary>
    /// 是否存在用户
    /// </summary>
    /// <param name="userName">用户登陆名字</param>
    /// <returns>1表示已经存在,0表示不存在</returns>
    public string ExsitUser(string userName)
    {
        User user = new User();
        user.LoginName = userName;

        try
        {
            return userlogic.ExsitUser(user).ToString();
        }
        catch (Exception ex)
        {

            JScript.JsAlert(ex.Message);
            return "";
        }
    }
    /// <summary>
    /// 获取未认证的用户
    /// </summary>
    /// <returns>用户列表</returns>
    public IList<User> GetNoVerify()
    {
        try
        {
            return userlogic.UserNoVerifyFilter();
        }
        catch (Exception ex)
        {

            JScript.JsAlert(ex.Message);
            return null;
        }
    }
    /// <summary>
    /// 获取已经认证的用户
    /// </summary>
    /// <returns>用户列表</returns>
    public IList<User> GetVerified()
    {
        try
        {
            return userlogic.UserVerifiedFilter();
        }
        catch (Exception ex)
        {

            JScript.JsAlert(ex.Message);
            return null;
        }
    }
    /// <summary>
    /// 获取所有用户列表
    /// </summary>
    /// <returns>用户列表</returns>
    public IList<User> GetList()
    {
        try
        {
            return userlogic.UserList();
        }
        catch (Exception ex)
        {

            JScript.JsAlert(ex.Message);
            return null;
        }
    }
    /// <summary>
    /// 把该用户设置成为认证用户
    /// </summary>
    /// <param name="userName">用户登陆名</param>
    /// <returns>1表示认证成功,0认证失败</returns>
    public int SetVerified(string userName)
    {
        try
        {
            return userlogic.SetVerify(userName);
        }
        catch (Exception ex)
        {

            JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 把该用户设置成为非认证用户
    /// </summary>
    /// <param name="userName">用户登陆名</param>
    /// <returns>1表示废除认证成功,0废除认证失败</returns>
    public int SetNoVerified(string userName)
    {
        try
        {
            return userlogic.SetNoVerify(userName);
        }
        catch (Exception ex)
        {

            JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 登陆
    /// </summary>
    /// <param name="userId">用户登录名</param>
    /// <param name="passWord">密码</param>
    /// <returns>-1表示未认证的用户,-2表示登陆失败</returns>
    public string LogIn(string userId, string passWord)
    {
        FormsAuthenticationTicket tick = null;
        User user=null;
        try
        {
            user = userlogic.Login(userId, passWord);
        }
        catch (Exception ex)
        {
            JScript.JsAlert(ex.Message);
            return "-2";
        }

        if (user.Group == 0)
            return "-1";
        else
            tick = new FormsAuthenticationTicket(1, userId, DateTime.Now, DateTime.Now.AddMinutes(30), false, WebConfigurationManager.AppSettings["roles"+user.Group]);  
        string HashTicket = FormsAuthentication.Encrypt(tick);
        HttpCookie UserCookie = new HttpCookie(FormsAuthentication.FormsCookieName, HashTicket);
        HttpContext.Current.Response.Cookies.Add(UserCookie);
        return user.Sex + "," + user.DisPlay + "," + user.Reward + "," + user.Group;

    }
    /// <summary>
    /// 注销
    /// </summary>
    public void LogOut()
    {
        if (HttpContext.Current.Request.IsAuthenticated)
        {
            FormsAuthentication.SignOut();
        }
    }
    /// <summary>
    /// 获取用户信息
    /// </summary>
    /// <param name="userId">用户</param>
    /// <returns>用户信息用,分割</returns>
    public string GetUserInfo(string userId)
    {
        User user=userlogic.GetUserInfo(userId);
        return user.Sex + "," + user.DisPlay + "," + user.Contact + "," + user.Tel + "," + user.Reward + "," + user.Group;

    }
    /// <summary>
    /// 检测是否登陆
    /// </summary>
    /// <returns>-1没有登陆</returns>
    public string BoologIn()
    {
        if (HttpContext.Current.User.Identity.IsAuthenticated)
            return this.GetUserInfo(HttpContext.Current.User.Identity.Name);
        else
            return "-1";
    }

    public IList<User> GetActiveUser()
    {
        return userlogic.GetActiveUser();
    }
}
