﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Customer_MenuMeal : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Ajax.Utility.RegisterTypeForAjax(this.GetType());
        this.ClientScript.RegisterClientScriptInclude(this.GetType(), "kkk", "js/JSMenu.js");
        this.myMenuList.DataSource = new EMenuType().GetMyType();
        this.myMenuList.DataBind();
    }
    /// <summary>
    /// 获取菜肴类别
    /// </summary>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetTypes()
    {
        EItemTyps type = new EItemTyps();
        return type.GetItemList();
    }
    /// <summary>
    /// 获取该类别编号的所有菜肴
    /// </summary>
    /// <param name="typeId">菜肴类型编号</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetItems(string typeId)
    {
        EItem item = new EItem();
        return item.SelectItems(int.Parse(typeId));
    }
    /// <summary>
    /// 增加一个菜单
    /// </summary>
    /// <param name="itemsList">菜肴字符串</param>
    /// <param name="title">菜单名</param>
    /// <param name="detail">菜单说明</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int AddMenu(string itemsList, string title, string detail)
    {
        EMenuType menuType = new EMenuType();
        return menuType.AddMenu(itemsList, title, detail);
    }
    /// <summary>
    /// 获取一个菜单
    /// </summary>
    /// <param name="menuId">菜单编号</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetMenu(string menuId)
    {
        EMenuType menuType = new EMenuType();
        return menuType.GetDetailMenu(menuId);
    }
    /// <summary>
    /// 获取一个菜单的简单信息
    /// </summary>
    /// <param name="menuId">菜单编号</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetMenuInfo(string menuId)
    {
        EMenuType menuType = new EMenuType();
        return menuType.GetDetailMenuInfo(menuId);
    }
    /// <summary>
    /// 修改一个菜单
    /// </summary>
    /// <param name="menuId">菜单编号</param>
    /// <param name="itemsList">菜肴字符串</param>
    /// <param name="title">菜单名</param>
    /// <param name="detail">菜单说明</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public int EditMenu(string menuId, string itemsList, string title, string detail)
    {
        EMenuType menuType = new EMenuType();
        return menuType.EditMenu(menuId, itemsList, title, detail);
    }
}
