﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Customer_MyOrder : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Ajax.Utility.RegisterTypeForAjax(this.GetType());
        this.ClientScript.RegisterClientScriptInclude("ggg", "js/JSOrder.js");
        this.myOrdered.DataSource = new EOrder().GetMyOrder();
        this.myOrdered.DataBind();

    }
    /// <summary>
    /// 增加一笔订单
    /// </summary>
    /// <param name="menuId">菜单号</param>
    /// <param name="orderNo">预定桌数</param>
    /// <param name="orderTime">预定执行时间</param>
    /// <param name="orderMark">备注</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string AddOrder(string menuId,int orderNo,string orderTime,string orderMark)
    {
        EOrder eorder = new EOrder();
        return eorder.AddOrder(menuId, orderNo, orderTime, orderMark);
    }
    /// <summary>
    /// 列出管理员定制的菜单
    /// </summary>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetAdminMenuType()
    {
        EMenuType menutype = new EMenuType();
        return menutype.GetAdminTypeForAjax();
    }
    /// <summary>
    /// 列出我的菜单
    /// </summary>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetMyMenuType()
    {
        EMenuType menutype = new EMenuType();
        return menutype.GetMyTypeForAjax();
    }
    /// <summary>
    /// 获得菜单详细信息
    /// </summary>
    /// <param name="menuId">菜单ID</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetInfo(string menuId)
    {
        EMenuType menutype = new EMenuType();
        return menutype.GetDetailMenu(menuId);
    }

}
