﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class View : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Ajax.Utility.RegisterTypeForAjax(this.GetType());
        this.ClientScript.RegisterClientScriptInclude("ggg", "js/Nagive.js");
        this.itemTypes.DataSource = new EItemTyps().GetItemTypes();
        this.itemTypes.DataBind();
        this.itemTypes.EnableViewState = false;
        this.ClientScript.RegisterStartupScript(this.GetType(), "kkk", "<script>ItemInit();</script>");
    }
    /// <summary>
    /// 根据菜肴类型,返回本类型下的菜肴列表
    /// </summary>
    /// <param name="id">类型编号</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetItems(string id)
    {
        EItem items = new EItem();
        return items.SelectItems(int.Parse(id));
    }
    /// <summary>
    /// 返回一个菜肴信息
    /// </summary>
    /// <param name="id">菜肴编号</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetOneItem(string id)
    {
        EItem item = new EItem();
        return item.SelectOneItem(long.Parse(id));

    }
    /// <summary>
    /// 获取菜肴评论
    /// </summary>
    /// <param name="itemId">评论编号</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetItemMsg(string itemId)
    {
        EItemMsg msg = new EItemMsg();
        return msg.GetItemMsg(itemId);
    }
    /// <summary>
    /// 搜索框搜索
    /// </summary>
    /// <param name="key">关键字</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetSearch(string key)
    {
        EItem s = new EItem();
        return s.SearchItem(key);
    }
    /// <summary>
    /// 搜索显示菜肴
    /// </summary>
    /// <param name="keyword">关键字</param>
    /// <returns></returns>
    [Ajax.AjaxMethod]
    public string GetSearchItem(string keyword)
    {
        EItem s = new EItem();
        return s.SearchItems(keyword);
    }
    [Ajax.AjaxMethod]
    public string ItemRandom()
    {
        EItem s = new EItem();
        return s.ItemRandom();
    }
}
