﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="AccList.aspx.cs" Inherits="AccList" %>

<%@ Register Src="../PaggingControl.ascx" TagName="PaggingControl" TagPrefix="uc1" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>所有公文列表</title>
    <link href="../css/free3.3.css" rel="stylesheet" type="text/css" />
    <link href="../css/inboxlist.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <div id="main">
            <div class="ggpop">
                <!--这里放广告-->
                <!-- adv -->
            </div>
            <div class="tagbg">
                <div class="tag">
                    <strong>所有附件</strong>
                </div>
                <div class="tag_addons">
                    共<em><asp:Label ID="NumLabel" runat="server" /></em> 个附件。
                </div>
            </div>
            <div id="inboxarea">
                <asp:Panel ID="MsgPanel" runat="server" CssClass="option_msg" Visible="false" EnableViewState="false">
                    <asp:Label ID="MsgLabel" runat="server" Style="padding: 15px 0px 5px 30px; display: inline;"
                        EnableViewState="false" />
                </asp:Panel>
                <div class="inboxareaheader">
                    <span class="userbutton">
                        <asp:LinkButton ID="DelLinkButton" runat="server" CssClass="delete" OnClick="DelLinkButton_Click">删除</asp:LinkButton>
                        <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender1" runat="server" ConfirmText="确定要删除选定的项吗?"
                            TargetControlID="DelLinkButton">
                        </ajaxToolkit:ConfirmButtonExtender>
                        查找:
                        <asp:TextBox ID="SearchTextBox" runat="server" Width="133px" MaxLength="100" ToolTip="可以查找名称或关联文档！"></asp:TextBox> 
                    </span>
                </div>
                <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataSourceID="AccDS"
                    OnDataBound="GridView1_DataBound" AllowPaging="True" AllowSorting="True" ShowFooter="True"
                    CssClass="maillist">
                    <Columns>
                        <asp:TemplateField HeaderText="　">
                            <ItemTemplate>
                                <asp:CheckBox ID="IdChkBox" runat="server" Text='<%# Eval("ID") %>' ForeColor="white" />
                            </ItemTemplate>
                            <HeaderTemplate>
                                <asp:CheckBox ID="AllSelChkBox" runat="server" Text="  全选" Style="margin-left: 5px;"
                                    OnCheckedChanged="AllSelChkBox_CheckedChanged" AutoPostBack="True" />
                            </HeaderTemplate>
                            <ItemStyle Width="80px" HorizontalAlign="Left" CssClass="noread"></ItemStyle>
                            <HeaderStyle CssClass="checjboxth" HorizontalAlign="Center"></HeaderStyle>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="名称" SortExpression="DispName">
                            <ItemTemplate>
                                <a href='../DownFile.aspx?ID=<%#Eval("ID") %>'><%#Eval("DispName") %></a>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="关联文档" SortExpression="Title">
                            <ItemTemplate>
                                <a href='readUserMail.aspx?fid=acc&ID=<%#Eval("DocID")%>' target="_blank">
                                    <%# Eval("DocSubject")%>
                                </a>
                            </ItemTemplate>
                            <ItemStyle CssClass="no_read" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="文件大小" SortExpression="FileSize">
                            <ItemTemplate>
                                <%#ByteToMB((decimal)Eval("FileSize")) %>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="SendDate" HeaderText="发送日期" SortExpression="SendDate">
                            <ItemStyle Width="140px" />
                        </asp:BoundField>
                    </Columns>
                    <PagerTemplate>
                        <uc1:PaggingControl ID="PaggingControl1" runat="server"></uc1:PaggingControl>
                    </PagerTemplate>
                    <PagerStyle HorizontalAlign="Right" />
                    <PagerSettings Position="TopAndBottom" />
                    <SelectedRowStyle Wrap="False" />
                </asp:GridView>
                <div class="inboxareaheader">
                    <span class="userbutton">
                        <asp:LinkButton ID="LinkButton1" runat="server" CssClass="delete" OnClick="DelLinkButton_Click">删除</asp:LinkButton>
                        <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender2" runat="server" ConfirmText="确定要删除选定的项吗?"
                            TargetControlID="LinkButton1">
                        </ajaxToolkit:ConfirmButtonExtender>
                    </span>
                </div>
            </div>
        </div>
        <asp:ObjectDataSource ID="AccDS" runat="server" SelectMethod="GetAccessories" TypeName="DocTran.BLL.Accessories"
            EnablePaging="True" SelectCountMethod="GetAccessoriesCount" SortParameterName="sortExpression"
            OnSelected="DocDS_Selected">
            <SelectParameters>
                <asp:ControlParameter ControlID="SearchTextBox" Name="findExp" PropertyName="Text"
                    Type="String" DefaultValue="" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <span class="cc1"><b></b></span><span class="cc2"><b></b></span>
    </form>

    <script type="text/javascript">
        function framesize(srcframe){
            var framename;
            framename = parent.document.getElementById(srcframe);
            if (framename){
	        framename.style.height = document.body.scrollHeight+30;
	        framename.style.width=document.body.scrollWidth;
	        }
	        
        }
        framesize("mainbody");
    </script>

</body>
</html>
