﻿/**
 * DaLian Digitwest Network Technologies Co., Ltd.(C) 2007
 * File: AccList.aspx.cs
 * Date: 2007-7-24
 * Author: Xing
 * Description: 
 *      管理附件列表
 * history:
 *	 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Utils = Idcwest.WebLibrary.Utils;
public partial class AccList : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.DocManager))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        } 


        //每页数量
        GridView1.PageSize = PageSize;
    }


    //全选
    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;

        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }
    //分页
    protected void GridView1_DataBound(object sender, EventArgs e)
    {
        PaddingCtrl.GridView_DataBound(sender, e);
        
    }

    //将文档删除
    protected void DelLinkButton_Click(object sender, EventArgs e)
    {
        bool bSucc = false;
        List<bool> bRetValCol = new List<bool>();
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                int id = int.Parse(idCheckBox.Text);  
                //先删除文件
                DocTran.BLL.Accessories.DelFileById(id);
                //删除数据库的记录
                bSucc = DocTran.BLL.Accessories.DeleteAccessories(id);
              
                bRetValCol.Add(bSucc);
                 
            }
        }

        if (bRetValCol.Count == 0)
        {
            MsgLabel.Text = "您至少需要选中一项，才能进行删除操作！";
            MsgPanel.Visible = true;
        }
        else
        {
            GridView1.DataBind();
            int nSucc = bRetValCol.FindAll(Succ).Count;
            int nFail = bRetValCol.FindAll(Fail).Count;

            MsgLabel.Text = string.Format("针对<strong><font color='red'>{0}</font></strong>项进行了删除操作，<strong><font color='red'>{1}</font></strong>项被成功删除！",
                    nSucc + nFail, nSucc);
            MsgPanel.Visible = true;
        }

    }
    private static bool Succ(bool val)
    {
        return val == true ? true : false;
    }

    private static bool Fail(bool val)
    {
        return val == false ? true : false;
    }


    //求记录总数
    protected void DocDS_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {   //先执行 GetDocs 返回 List　对象
        //在执行 GetDocCount　返回 int
        
        if (e.ReturnValue is Int32)
        {
            PaddingCtrl.RecordCount = (int)e.ReturnValue;
            NumLabel.Text = e.ReturnValue.ToString();
        }
    }

    protected string ByteToMB(decimal size)
    {
        string temp = "";
        decimal fileSize = Idcwest.WebLibrary.Utils.XConvert.BytesToMB(size, 2);
        temp = fileSize.ToString() + "MB";
        if (fileSize == 0)
        {
            fileSize = Idcwest.WebLibrary.Utils.XConvert.BytesToMB(size, 2);
            temp = fileSize.ToString() + "KB";
        }
        return temp;
    }

}
