﻿/**
 * DaLian Digitwest Network Technologies Co., Ltd.(C) 2007
 * File: AddDeptment.aspx.cs
 * Date: 2007-7-24
 * Author: Xing
 * Description: 
 *      添加部门
 * history:
 *	 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class AddDeptment : DocTran.UI.AdminBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && ViewState["bSucc"] == null)
        {
            SaveReturnButton.CommandName = "UpdateReturn";
            SaveAddNextButton.CommandName = "UpdateNext";
            LinkButton1.CommandName = "UpdateReturn";
            LinkButton2.CommandName = "UpdateNext";

            if (!IsPostBack)
            {
                DocTran.BLL.Deptment dept = DocTran.BLL.Deptment.GetDeptmentByID(int.Parse(Request.QueryString["ID"]));
                if (dept != null)
                {
                    DeptNameTextBox.Text = dept.DeptName;
                    DeptDescTextbox.Text = dept.DeptDesc;
                }
            }
        }
        

    }
    protected void OnCommand(object sender, CommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Save":
                {
                    if (DocTran.BLL.Deptment.IsExistDeptment(DeptNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.Deptment.InsertDeptment(DeptNameTextBox.Text.Trim(), DeptDescTextbox.Text.Trim());
                        //MsgLabel.Text = "添加成功！";
                        //MsgLabel.Visible = true;
                        //TypeNameTextBox.Text = "";
                        //TypeDescTextbox.Text = "";
                        Response.Redirect("DeptmentList.aspx");
                    }
                }
                break;
            case "SaveAdd":
                {
                    if (DocTran.BLL.Deptment.IsExistDeptment(DeptNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.Deptment.InsertDeptment(DeptNameTextBox.Text.Trim(), DeptDescTextbox.Text.Trim());
                        MsgLabel.Text = "添加成功！";
                        MsgPanel.Visible = true;
                        DeptNameTextBox.Text = "";
                        DeptDescTextbox.Text = "";

                    }
                }
                break;
            case "UpdateReturn":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.Deptment.UpdateDeptment(id, DeptNameTextBox.Text.Trim(), DeptDescTextbox.Text.Trim());
                    Response.Redirect("DeptmentList.aspx");
                }
                break;
            case "UpdateNext":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.Deptment.UpdateDeptment(id, DeptNameTextBox.Text.Trim(), DeptDescTextbox.Text.Trim());
                    if ( bSuccess)
                    {
                        ViewState["bSucc"] = true;
                        MsgLabel.Text = "更新成功，你可以继续添加项！";
                        MsgPanel.Visible = true;
                        DeptNameTextBox.Text = "";
                        DeptDescTextbox.Text = "";
                    }
                }
                break;

        }
    }
}
