﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class AddGroup : DocTran.UI.AdminBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && ViewState["bSucc"] == null)
        {
            SaveReturnButton.CommandName = "UpdateReturn";
            SaveAddNextButton.CommandName = "UpdateNext";
            LinkButton1.CommandName = "UpdateReturn";
            LinkButton2.CommandName = "UpdateNext";

            if (!IsPostBack)
            {
                DocTran.BLL.Group group = DocTran.BLL.Group.GetGroupByID(int.Parse(Request.QueryString["ID"]));
                if (group != null)
                {
                    GroupNameTextBox.Text = group.GroupName;
                    GroupDescTextbox.Text = group.GroupDesc;
                    string[] strArray = group.Permission.Split(",".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
                    for (int i = 0; i < strArray.Length; i++)
                    {
                        if (int.Parse(strArray[i]) == Convert.ToInt32(DocTran.Role.DocPublish))
                        {
                            PermissionChkBoxList.Items[0].Selected = true;
                        }
                        else if (int.Parse(strArray[i]) == Convert.ToInt32(DocTran.Role.DocManager))
                        {
                            PermissionChkBoxList.Items[1].Selected = true;
                        }
                        else if (int.Parse(strArray[i]) == Convert.ToInt32(DocTran.Role.WarningPublish))
                        {
                            PermissionChkBoxList.Items[2].Selected = true;
                        }
                        else if (int.Parse(strArray[i]) == Convert.ToInt32(DocTran.Role.SendSMS))
                        {
                            PermissionChkBoxList.Items[3].Selected = true;
                        }
                        else if (int.Parse(strArray[i]) == Convert.ToInt32(DocTran.Role.Admin))
                        {
                            PermissionChkBoxList.Items[4].Selected = true;
                        }

                    }
                }

            }
        }


    }

    protected string Permission
    {
        get
        {
            string permission = "";

            foreach (ListItem items in PermissionChkBoxList.Items)
            {
                if (items.Selected)
                {
                    if (permission == "")
                        permission += items.Value;
                    else
                        permission += "," + items.Value;
                }
            }
            return permission;
        }
    }

    protected void OnCommand(object sender, CommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Save":
                {
                    if (DocTran.BLL.Group.IsExistGroup(GroupNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.Group.InsertGroup(GroupNameTextBox.Text.Trim(), GroupDescTextbox.Text.Trim(), Permission);
                        //MsgLabel.Text = "添加成功！";
                        //MsgLabel.Visible = true;
                        //TypeNameTextBox.Text = "";
                        //TypeDescTextbox.Text = "";
                        Response.Redirect("GroupList.aspx");
                    }
                }
                break;
            case "SaveAdd":
                {
                    if (DocTran.BLL.Group.IsExistGroup(GroupNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.Group.InsertGroup(GroupNameTextBox.Text.Trim(), GroupDescTextbox.Text.Trim(), Permission);
                        MsgLabel.Text = "添加成功！";
                        MsgPanel.Visible = true;
                        GroupNameTextBox.Text = "";
                        GroupDescTextbox.Text = "";
                        PermissionChkBoxList.ClearSelection();

                    }
                }
                break;
            case "UpdateReturn":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.Group.UpdateGroup(id, GroupNameTextBox.Text.Trim(), GroupDescTextbox.Text.Trim(), Permission);
                    Response.Redirect("GroupList.aspx");
                }
                break;
            case "UpdateNext":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.Group.UpdateGroup(id, GroupNameTextBox.Text.Trim(), GroupDescTextbox.Text.Trim(), Permission);
                    {
                        ViewState["bSucc"] = true;
                        MsgLabel.Text = "更新成功，你可以继续添加项！";
                        MsgPanel.Visible = true;
                        GroupNameTextBox.Text = "";
                        GroupDescTextbox.Text = "";
                        PermissionChkBoxList.ClearSelection();
                    }
                }
                break;

        }
    }
}
