﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class AddUser : DocTran.UI.AdminBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && ViewState["bSucc"] == null)
        {
            SaveReturnButton.CommandName = "UpdateReturn";
            SaveAddNextButton.CommandName = "UpdateNext";
            LinkButton1.CommandName = "UpdateReturn";
            LinkButton2.CommandName = "UpdateNext";

            PasswordTextBox.Visible = false;
            ResetPasswordLnkBtn.Visible = true;
            RequiredFieldValidator3.Enabled = false;

            if (!IsPostBack)
            {
                DocTran.BLL.User user = DocTran.BLL.User.GetUserByID(int.Parse(Request.QueryString["ID"]));
                if (user != null)
                {
                    UserNameTextBox.Text = user.UserName;
                    FullNameTextbox.Text = user.FullName;
                    //PasswordTextBox.Text = user.Password;
                    DeptDropDownList.SelectedValue = user.DeptmentID.ToString(); //如果ID在部门表中已经不存在，会出现错误。
                    GroupDropDownList.SelectedValue = user.GroupID.ToString();  // up
                    IsActivateCheckBox.Checked = user.IsActivate;
                    MobileTextBox.Text = user.Mobile;
                    EmailTextBox.Text = user.Email;
                }
            }
        }


    }
    protected void OnCommand(object sender, CommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Save":
                {
                    if (DocTran.BLL.User.IsExistUser(UserNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.User.InsertUser(
                               UserNameTextBox.Text.Trim(),
                               Idcwest.Security.Md5.getMd5Hash(PasswordTextBox.Text.Trim()),
                               FullNameTextbox.Text.Trim(),
                               int.Parse(GroupDropDownList.SelectedValue),
                               int.Parse(DeptDropDownList.SelectedValue),
                               IsActivateCheckBox.Checked,
                               MobileTextBox.Text.Trim(),
                               EmailTextBox.Text.Trim()
                            );
                        //MsgLabel.Text = "添加成功！";
                        //MsgLabel.Visible = true;
                        //TypeNameTextBox.Text = "";
                        //TypeDescTextbox.Text = "";
                        Response.Redirect("UserList.aspx");
                    }
                }
                break;
            case "SaveAdd":
                {
                    if (DocTran.BLL.User.IsExistUser(UserNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.User.InsertUser(
                              UserNameTextBox.Text.Trim(),
                               Idcwest.Security.Md5.getMd5Hash(PasswordTextBox.Text.Trim()),
                               FullNameTextbox.Text.Trim(),
                               int.Parse(GroupDropDownList.SelectedValue),
                               int.Parse(DeptDropDownList.SelectedValue),
                               IsActivateCheckBox.Checked,
                               MobileTextBox.Text.Trim(),
                               EmailTextBox.Text.Trim()
                            );
                        MsgLabel.Text = "添加成功！";
                        MsgPanel.Visible = true;
                        UserNameTextBox.Text = "";
                        PasswordTextBox.Text = "";
                        FullNameTextbox.Text = "";
                        MobileTextBox.Text = "";
                        EmailTextBox.Text = "";

                    }
                }
                break;
            case "UpdateReturn":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.User.UpdateUser(
                            id,
                            UserNameTextBox.Text.Trim(),
                            PasswordTextBox.Text.Trim(),
                            FullNameTextbox.Text.Trim(),
                            int.Parse(GroupDropDownList.SelectedValue),
                            int.Parse(DeptDropDownList.SelectedValue),
                            IsActivateCheckBox.Checked,
                            MobileTextBox.Text.Trim(),
                            EmailTextBox.Text.Trim()
                        );
                    Response.Redirect("UserList.aspx");
                }
                break;
            case "UpdateNext":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.User.UpdateUser(
                            id,
                            UserNameTextBox.Text.Trim(),
                            PasswordTextBox.Text.Trim(),
                            FullNameTextbox.Text.Trim(),
                            int.Parse(GroupDropDownList.SelectedValue),
                            int.Parse(DeptDropDownList.SelectedValue),
                            IsActivateCheckBox.Checked,
                            MobileTextBox.Text.Trim(),
                            EmailTextBox.Text.Trim()
                        );
                    if ( bSuccess)
                    {
                        ViewState["bSucc"] = true;
                        MsgLabel.Text = "更新成功，你可以继续添加项！";
                        MsgPanel.Visible = true;
                        UserNameTextBox.Text = "";
                        PasswordTextBox.Text = "";
                        FullNameTextbox.Text = "";
                        MobileTextBox.Text = "";
                        EmailTextBox.Text = "";
                        PasswordTextBox.Visible = true;
                        ResetPasswordLnkBtn.Visible = false;
                        RequiredFieldValidator3.Enabled = true;
                    }
                }
                break;

        }
    }


    protected void OnResetPasswordButton(object sender,EventArgs e)
    {
        bool retVal = DocTran.BLL.User.UpdatePassword(int.Parse(Request.QueryString["ID"]), Idcwest.Security.Md5.getMd5Hash(ResetPwdTxtBox.Text.Trim()));
        if (retVal)
        {
            MsgLabel.Text = "密码修改成功！";
            MsgPanel.Visible = true;
        }
    }
    
}
