﻿
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.Xml;

using DocTran.Config;
using Idcwest.Common;

public partial class SystemSettings : DocTran.UI.AdminBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if ( !IsPostBack )
            InitConfig();
    }

    protected void InitConfig()
    {
        //公司名称 
        CompanyTextBox.Text = Settings.Company;


        //公文列表显示公文的数目

        for (int i = 0; i < MailListNumRadioList.Items.Count; i++)
        {
            MailListNumRadioList.Items[i].Selected = false;
            if (int.Parse(MailListNumRadioList.Items[i].Value) == Settings.PageSize)
                MailListNumRadioList.Items[i].Selected = true;
        }
        
        //允许上传附件的数目
        for (int i = 0; i < AccNumRadioList.Items.Count; i++)
        {
            AccNumRadioList.Items[i].Selected = false;
            if (int.Parse(AccNumRadioList.Items[i].Value) == Settings.AccessoriesCount)
                AccNumRadioList.Items[i].Selected = true;
        }
        //是否为系统启用缓存功能

        for (int i = 0; i < CacheEnableRadioBtn.Items.Count; i++)
        {
            CacheEnableRadioBtn.Items[i].Selected = false;
            if (bool.Parse(CacheEnableRadioBtn.Items[i].Value) == Settings.EnableCaching)
                CacheEnableRadioBtn.Items[i].Selected = true;
        }

        //SMS 设置
        for (int i = 0; i < DocSmsRadioBtn.Items.Count; i++)
        {
            DocSmsRadioBtn.Items[i].Selected = false;
            if ( bool.Parse(DocSmsRadioBtn.Items[i].Value) == Settings.EnableSMS)
                DocSmsRadioBtn.Items[i].Selected = true;
        }

        CoreIdTextBox.Text = Settings.CoreId;   //企业号
        UseridTextBox.Text = Settings.Userid;   //用户名
        PasswordTextBox.Text = Settings.Password;  //密码
        SignatureTextBox.Text = Settings.Signature; //签名

        // Rss新闻订阅设置
        Rss1TitleTextBox.Text = Settings.Rss1Title;
        Rss1UrlTextBox.Text = Settings.Rss1Url;
        Rss2TitleTextBox.Text = Settings.Rss2Title;
        Rss2UrlTextBox.Text = Settings.Rss2Url;
        Rss3TitleTextBox.Text = Settings.Rss3Title;
        Rss3UrlTextBox.Text = Settings.Rss3Url;
    }

    protected string Save()
    {
        //公文列表显示公文的数目
        string file = AppDomain.CurrentDomain.BaseDirectory + "\\WebLibrary.config";
        XmlDocument xmlDoc = Config.Load(file);

        //公司名称
        xmlDoc = Config.AddAppSetting(xmlDoc, "Company", CompanyTextBox.Text);
        
        //公文列表显示公文的数目
        xmlDoc=Config.AddAppSetting(xmlDoc, "PageSize", MailListNumRadioList.SelectedValue);

        //允许上传附件的数目
        xmlDoc = Config.AddAppSetting(xmlDoc, "AccessoriesCount", AccNumRadioList.SelectedValue);

        //是否为系统启用缓存功能
        xmlDoc = Config.AddAppSetting(xmlDoc, "EnableCaching", CacheEnableRadioBtn.SelectedValue);
       
        //Sms 设置
        xmlDoc = Config.AddAppSetting(xmlDoc, "EnableSMS", DocSmsRadioBtn.SelectedValue);
        xmlDoc = Config.AddAppSetting(xmlDoc, "CoreId", CoreIdTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Userid", UseridTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Password", PasswordTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Signature", SignatureTextBox.Text.Trim());

        // Rss新闻订阅设置
        xmlDoc = Config.AddAppSetting(xmlDoc, "Rss1Title", Rss1TitleTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Rss1Url", Rss1UrlTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Rss2Title", Rss2TitleTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Rss2Url", Rss2UrlTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Rss3Title", Rss3TitleTextBox.Text.Trim());
        xmlDoc = Config.AddAppSetting(xmlDoc, "Rss3Url", Rss3UrlTextBox.Text.Trim());

        return Config.Save(xmlDoc, file);

       
    }

    protected void SaveBtn_Click(object sender, EventArgs e)
    {
        string msg = Save();
        if (string.IsNullOrEmpty(msg))
        {
            MsgLabel.Text = "配置修改成功！";
            MsgPanel.Visible = true;
            //InitConfig();
        }
        else
        {
            MsgLabel.Text = msg;
            MsgPanel.Visible = true;
        }

    }
}
