﻿<%@ page language="C#" autoeventwireup="true" CodeFile="UserList.aspx.cs" inherits="UserList" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>公文转输-系统用户列表</title>
    <link href="../css/free3.3.css" rel="stylesheet" type="text/css" media="all" />
    <link href="../css/inboxlist.css" rel="stylesheet" type="text/css" media="all" />
    <style type="text/css">
<!--
#inboxarea .inboxareaheader .userbutton{
left:135px;
}
-->
</style>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server" ID="ScriptManager1" />
        <div id="main">
            <div class="tagbg">
                <div class="tag">
                    <strong>用户设置</strong><br />
                    (注意：用户如果已经发送过文档，将不能被删除，您必须先删除用户发送过的所有公文。您也可以暂时禁用该用户登录！)
                </div>
            </div>
            <div id="inboxarea">
                <asp:Panel ID="MsgPanel" runat="server" CssClass="option_msg" Visible="false" EnableViewState="false">
                    <asp:Label ID="MsgLabel" runat="server" Style="padding: 15px 0px 5px 30px; display: inline;"
                        EnableViewState="false" />
                </asp:Panel>
                <div class="inboxareaheader">   
                    <span class="userbutton"> 
                    <a href="AddUser.aspx" class="creatcontact_btn">新建</a>
                        <asp:LinkButton ID="DelLinkButton" runat="server" CssClass="delete" OnClick="DelLinkButton_Click">删除</asp:LinkButton>
                        <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender1" runat="server" ConfirmText="确定要删除选定的项吗?"
                            TargetControlID="DelLinkButton">
                        </ajaxToolkit:ConfirmButtonExtender>
                        请输入姓名：<asp:TextBox ID="SearchTextBox" runat="server" />
                        部门：<asp:DropDownList ID="DeptDropDown" runat="server" AutoPostBack="true" DataSourceID="DeptDS"
                            DataTextField="DeptName" DataValueField="ID" AppendDataBoundItems="True">
                            <asp:ListItem Value="0">全部</asp:ListItem>
                        </asp:DropDownList>
                        <asp:ObjectDataSource ID="DeptDS" runat="server" SelectMethod="GetDeptments" TypeName="DocTran.BLL.Deptment">
                        </asp:ObjectDataSource>
                    </span>
                </div>
                <asp:GridView ID="GridView1" runat="server" AllowPaging="True" AllowSorting="True"
                    AutoGenerateColumns="False" DataSourceID="UserDS" CssClass="maillist" OnRowDataBound="GridView1_RowDataBound" >
                    <Columns>
                        <asp:TemplateField HeaderText="全选">
                            <ItemTemplate>
                                <asp:CheckBox ID="IdChkBox" runat="server" Text='<%# Eval("ID") %>' ForeColor="white">
                                </asp:CheckBox>
                            </ItemTemplate>
                            <HeaderTemplate>
                                <asp:CheckBox ID="AllSelChkBox" runat="server" Text="  全选" OnCheckedChanged="AllSelChkBox_CheckedChanged"
                                    AutoPostBack="True" />
                            </HeaderTemplate>
                            <ItemStyle Width="50px" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="UserName" HeaderText="登录账户" SortExpression="UserName" />
                        <asp:BoundField DataField="FullName" HeaderText="用户姓名" SortExpression="FullName" />
                        <asp:BoundField DataField="DeptName" HeaderText="部门" SortExpression="DeptName" />
                        <asp:BoundField DataField="GroupName" HeaderText="权限" SortExpression="GroupName" />
                        <asp:TemplateField HeaderText="状态" SortExpression="IsActivate">
                            <ItemTemplate>
                                <%#UserStatus((bool)Eval("IsActivate")) %>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <a href='AddUser.aspx?ID=<%#Eval("ID") %>'>
                                    <asp:Label ID="EditLabel" runat="server" Text="编辑" /></a>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <br />
                <asp:ObjectDataSource ID="UserDS" runat="server" SelectMethod="GetUsers" TypeName="DocTran.BLL.User"
                    EnablePaging="true" SelectCountMethod="GetUsersCount" SortParameterName="sortExpression">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="SearchTextBox" Name="findExp" PropertyName="Text"
                            Type="String" />
                        <asp:ControlParameter ControlID="DeptDropDown" Name="deptID" PropertyName="SelectedValue"
                            Type="Int32" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <div class="inboxareaheader">
                    <span class="userbutton"><a href="AddUser.aspx" class="creatcontact_btn">新建</a>
                        <asp:LinkButton ID="LinkButton1" runat="server" CssClass="delete" OnClick="DelLinkButton_Click">删除</asp:LinkButton>
                        <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender2" runat="server" ConfirmText="确定要删除选定的项吗?"
                            TargetControlID="LinkButton1">
                        </ajaxToolkit:ConfirmButtonExtender>
                    </span>
                </div>
            </div>
            <span class="cc1"><b></b></span><span class="cc2"><b></b></span>
        </div>
    </form>

    <script type="text/javascript">
        function framesize(srcframe){
            var framename;
            framename = parent.document.getElementById(srcframe);
            if (framename)
	        framename.style.height = document.body.scrollHeight;
        }
        framesize("mainbody");
    </script>

</body>
</html>
