﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Brettle.Web.NeatUpload;
using System.Collections.Generic;
using System.IO;


public partial class Archives_UserAddArc : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request.QueryString["ID"]) && !IsPostBack)
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            SaveButton.CommandName = "Edit";
            DigitWork.BLL.UserArchive arc = DigitWork.BLL.UserArchive.GetById(id);

            ArcNameTextBox.Text = arc.ArcName;
            ArcCategoryDropList.SelectedValue = arc.CategoryID.ToString();
            ArcDescTextBox.Text = arc.ArcDesc;


        }
        

        #region 初始附件控件
        if (IsPostBack)
        {

            PlaceHolder1.Controls.Clear();
            for (int i = 0; i < CtrlCnt; i++)
            {
                UpFileCtrl upfileCtrl = (UpFileCtrl)LoadControl("../UpFileCtrl.ascx");
                if (upfileCtrl != null)
                {
                    upfileCtrl.ID = "inputfile" + i.ToString();
                    PlaceHolder1.Controls.Add(upfileCtrl);
                }

            }

        }
        #endregion
    }


    #region 添加附件

    //记录附件个数
    private int CtrlCnt
    {
        set { ViewState["cnt"] = value; }
        get
        {
            object obj = ViewState["cnt"];
            if (obj != null)
                return (int)ViewState["cnt"];
            else
                return 0;
        }
    }


    protected void AddAcc_Click(object sender, EventArgs e)
    {
        if (CtrlCnt < Settings.AccessoriesCount)
        {
            CtrlCnt++;
            PlaceHolder1.Controls.Clear();
            for (int i = 0; i < CtrlCnt; i++)
            {
                UpFileCtrl upfileCtrl = (UpFileCtrl)LoadControl("../UpFileCtrl.ascx");
                if (upfileCtrl != null)
                {
                    upfileCtrl.ID = "inputfile" + i.ToString();
                    PlaceHolder1.Controls.Add(upfileCtrl);

                }

            }

        }
    }

    #endregion

    #region 附加附件列表
    //附件列表
    private List<DigitWork.BLL.UserArcFile> AccList = new List<DigitWork.BLL.UserArcFile>();

    private List<Pair> Attach()
    {

        List<Pair> fileObjList = new List<Pair>();

        try
        {
            for (int i = 0; i < CtrlCnt; i++)
            {
                UpFileCtrl upfileCtrl = (UpFileCtrl)PlaceHolder1.FindControl("inputfile" + i.ToString());
                if (upfileCtrl != null)
                {
                    InputFile infile = (InputFile)upfileCtrl.FindControl("infile");
                    if (infile != null && infile.FileName != null)
                    {
                        DigitWork.BLL.UserArcFile arcFile = new DigitWork.BLL.UserArcFile();
                        arcFile.DispName = infile.FileName;
                        string ext = infile.FileName.Substring(infile.FileName.LastIndexOf(".")); //取扩展名

                        arcFile.FileName = Guid.NewGuid().ToString() + ext; //使用GUID值做为文件的名称

                        arcFile.FileSize = Convert.ToDecimal(infile.ContentLength);
                        arcFile.SendDate = DateTime.Now;

                        AccList.Add(arcFile);

                        fileObjList.Add(new Pair(infile, arcFile.FileName));
                    }
                }

            }

            return fileObjList;
        }
        catch (Exception ex)
        {
            RedirectError(HttpUtility.UrlEncode(ex.Message + ex.StackTrace));
            return null;
        }
    }

    #endregion

    #region 上传附件

    private bool UploadAcc(List<Pair> fileObjList)
    {
        try
        {
            if (fileObjList != null && fileObjList.Count != 0)
            {
                //上传文件
                foreach (Pair pair in fileObjList)
                {
                    InputFile inputFile = (InputFile)pair.First;
                    string fileName = (string)pair.Second;

                    //将上传的文件转移到指定的目录
                    inputFile.MoveTo(Path.Combine(Request.PhysicalApplicationPath + Settings.ArchiveDirectory, fileName),
                                   MoveToOptions.Overwrite);
                }

                return true;
            }
            else if (fileObjList != null && fileObjList.Count == 0) //没有附件返回true
            {
                return true;
            }
            else
                return false;

        }
        catch (Exception ex)
        {
            RedirectError(ex.Message);
            return false;
        }
        finally { }
    }

    #endregion

    #region 添加与修改档案

    protected void SaveButton_Command(object sender, CommandEventArgs e)
    {
        if (e.CommandName == "Add")
        {
            Add();
        }
        else
        {
            int arcId = int.Parse(Request.QueryString["ID"]);
            Edit(arcId);
        }
       
    }

    private void Add()
    {
        List<Pair> fileList = Attach();  //获取附件列表

        if (fileList.Count <= 0)
        {
            MsgLabel.Text = "没有添加附件！";
            MsgPanel.Visible = true;
            return;
        }

        string arcName = Idcwest.Web.Utils.Helper.ClearHtml(ArcNameTextBox.Text.Trim());
        int categoryId = int.Parse(ArcCategoryDropList.SelectedValue);
        string arcDesc = Idcwest.Web.Utils.Helper.ClearHtml(ArcDescTextBox.Text.Trim());
        bool retVal = DigitWork.BLL.UserArchive.AddMyArchive(
            DocTran.BLL.User.CurrentUser.ID,
            arcName,
            categoryId,
            arcDesc,
            AccList);


        #region 上传附件

        //发送数据成功,上传附件
        if (retVal && UploadAcc(fileList))
            Response.Redirect("../msg.aspx?msg=档案保存成功!&go=archives/UserAddArc.aspx&back=archives/userarchives.aspx");

        #endregion
    }

    private void Edit(int arcId)
    {
        List<Pair> fileList = Attach();  //获取附件列表

        //if (fileList.Count <= 0)
        //{
        //    MsgLabel.Text = "没有添加附件！";
        //    MsgPanel.Visible = true;
        //    return;
        //}

        string arcName = Idcwest.Web.Utils.Helper.ClearHtml(ArcNameTextBox.Text.Trim());
        int categoryId = int.Parse(ArcCategoryDropList.SelectedValue);
        string arcDesc = Idcwest.Web.Utils.Helper.ClearHtml(ArcDescTextBox.Text.Trim());
        bool retVal = DigitWork.BLL.UserArchive.EditMyArchive(
            arcId,
            DocTran.BLL.User.CurrentUser.ID,
            arcName,
            categoryId,
            arcDesc,
            AccList);


        #region 上传附件

        //发送数据成功,上传附件
        if (retVal && UploadAcc(fileList))
            Response.Redirect("../msg.aspx?msg=档案保存成功!&go=archives/UserAddArc.aspx&back=archives/userarchives.aspx");

        #endregion
    }

    #endregion

    #region 编辑状态删除档案文件

    protected void DelFileLinkBtn_OnCommand(object sender, CommandEventArgs e)
    {
        int id = int.Parse(e.CommandArgument.ToString());

        //先删除文件
        bool retVal = DigitWork.BLL.UserArcFile.DeleteFile(id); 
        if (retVal)
        {
            //删除数据库中文件
            DigitWork.BLL.UserArcFile.Delete(id);
            ArcFileRep.DataBind();
        }
        
    }

    #endregion
}
