﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="UserArchives.aspx.cs" Inherits="Archives_UserArchives" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>KO!-个人档案</title>
    <link href="../css/free3.3.css" rel="stylesheet" type="text/css" media="all" />
    <link href="../css/inboxlist.css" rel="stylesheet" type="text/css" />

    <script type="text/javascript">
   
     function framesize(srcframe){
            var framename;
            framename = parent.document.getElementById(srcframe);
            if (framename)
	        framename.style.height = document.body.scrollHeight+30;
        } 
            
    </script>

</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server" ID="ScriptManager1">
        </asp:ScriptManager>
        <div id="main">
            <div class="tagbg">
                <div class="tag" style="text-align: center;">
                    <strong>我的档案</strong>
                </div>
            </div>
            <div id="inboxarea">
                <asp:Panel ID="MsgPanel" runat="server" CssClass="option_msg" Visible="false" EnableViewState="false">
                    <asp:Label ID="MsgLabel" runat="server" Style="padding: 15px 0px 5px 30px; display: inline;"
                        EnableViewState="false" />
                </asp:Panel>
                <div class="inboxareaheader">
                    <span class="userbutton"></span>
                </div>
                <div class="inboxareaheader">
                    <div style="text-align: right; margin-right: 30px;">
                        <asp:DropDownList ID="ArcCategoryDropList" runat="server" DataSourceID="UserArcCategoryDS"
                            DataTextField="CategoryName" DataValueField="ID" AppendDataBoundItems="True" AutoPostBack="true">
                            <asp:ListItem Value="-1">全部分类</asp:ListItem>
                            <asp:ListItem Value="0">没有分类</asp:ListItem>
                        </asp:DropDownList>
                        <asp:ObjectDataSource ID="UserArcCategoryDS" runat="server" SelectMethod="GetUserArcCategorys"
                            TypeName="DigitWork.BLL.UserArcCategory" UpdateMethod="Update">
                            <SelectParameters>
                                <asp:SessionParameter SessionField="CUR_USER_ID" Name="userId" Type="Int32" />
                            </SelectParameters>
                        </asp:ObjectDataSource>
                        <asp:TextBox ID="SearchTextBox" runat="server" CssClass="search_input"></asp:TextBox>
                        <asp:LinkButton ID="SearchBtn" Text="搜" CssClass="searchbtn" runat="server" OnClick="SearchBtn_Click" />
                    </div>
                    <asp:GridView ID="GridView1" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                        DataSourceID="UserArcDS" CssClass="maillist" PageSize="10" ShowHeader="False">
                        <Columns>
                            <asp:TemplateField>
                                <ItemTemplate>
                                    <table width="100%">
                                        <tr>
                                            <td width="60px">
                                                档案名称:
                                            </td>
                                            <td>
                                                <b>
                                                    <%#Eval("ArcName") %>
                                                </b>&nbsp;[<%#Eval("CategoryName") %>] &nbsp;[<%#Eval("AddDate","{0:yyyy-MM-dd}") %>]
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                档案描述:
                                            </td>
                                            <td>
                                                <%#Eval("ArcDesc") %>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                档案文件:
                                            </td>
                                            <td>
                                                <asp:Label runat="server" ID="hideArcIdLabel" Text='<%#Eval("ID") %>' Visible="false" />
                                                <asp:Repeater ID="ArcFileRep" runat="server" DataSourceID="ArcFileDS">
                                                    <ItemTemplate>
                                                        <img src="../images/attach.jpg" alt="附件" /><a href='DownUserArcFiles.aspx?ID=<%#Eval("ID") %>'
                                                            title='<%#Idcwest.Web.Utils.XConvert.BytesToMB((decimal)Eval("FileSize"),2) %>MB'><%#Eval("DispName") %></a>
                                                    </ItemTemplate>
                                                </asp:Repeater>
                                                <asp:ObjectDataSource ID="ArcFileDS" runat="server" SelectMethod="GetUserArcFilesByArcId"
                                                    TypeName="DigitWork.BLL.UserArcFile">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="hideArcIdLabel" Name="arcId" PropertyName="Text"
                                                            Type="Int32" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" align="right">
                                                <a href='UserAddArc.aspx?ID=<%#Eval("ID") %>'>编辑</a>
                                                <asp:LinkButton ID="DelLinkBtn" runat="server" Text="删除" OnCommand="DelLinkBtn_OnCommand"
                                                    CommandArgument='<%#Eval("ID") %>' />
                                                <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender1" runat="server" ConfirmText="确定要删除吗?"
                                                    TargetControlID="DelLinkBtn">
                                                </ajaxToolkit:ConfirmButtonExtender>
                                            </td>
                                        </tr>
                                    </table>
                                    <div style="border-bottom: 1px solid #6322e3;">
                                    </div>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                        <PagerSettings Mode="NumericFirstLast" />
                    </asp:GridView>
                    <asp:ObjectDataSource ID="UserArcDS" runat="server" SelectMethod="GetUserArchives"
                        TypeName="DigitWork.BLL.UserArchive">
                        <SelectParameters>
                            <asp:SessionParameter Name="userId" SessionField="CUR_USER_ID" Type="Int32" />
                            <asp:ControlParameter Name="findExp" ControlID="SearchTextBox" Type="String" />
                            <asp:ControlParameter Name="categoryId" ControlID="ArcCategoryDropList" Type="Int32" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                </div>
            </div>
        </div>
    </form>
</body>

<script type="text/javascript">
       
        framesize("mainbody");
</script>

</html>

