﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class BlogForum_BlogForum : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        DataList1.DataSource = DigitWork.BLL.BlogForum.GetBlogForums(BlogID);
        DataList1.DataBind();

        LinkButton lnkBtn = DataList1.FindControl("DelBtn") as LinkButton;
        if (lnkBtn != null)
        {
            if (DocTran.BLL.User.CurrentUser.ID == 1)
                lnkBtn.Visible = true;
        }
     
    }

    private int _blogID;

    public int BlogID
    {
        get { return _blogID; }
        set { _blogID = value; }
    }

    private  Page _pageParent ;
    public Page PageParent
    {
        set { _pageParent = value; }
        get { return _pageParent; }
    }
    protected void SubmitBtn_Command(object sender, CommandEventArgs e)
    {
        string content = Idcwest.Web.Utils.Helper.ClearHtml(ForumTextBox.Text.Trim());
        DigitWork.BLL.BlogForum.Insert(BlogID, content, DateTime.Now, DocTran.BLL.User.CurrentUser.ID);

        DataList1.DataSource = DigitWork.BLL.BlogForum.GetBlogForums(BlogID);
        DataList1.DataBind();
         Idcwest.Web.Utils.JavaScript.Alert(this.Page, "评论发布成功!");
        ForumTextBox.Text = "";
    }

    protected string FormatDate(DateTime dt)
    {
        string sVal = "";

        //当前时间-发布时间
        TimeSpan v = DateTime.Now.Subtract(dt);

        if (Convert.ToInt32(v.TotalDays) != 0)
        {
            //大于一天
            sVal = Math.Abs(Convert.ToInt32(v.TotalDays)) + "天前";
        }
        else
        {
            if ((Convert.ToInt32(v.TotalMinutes) < 5) && (Convert.ToInt32(v.TotalHours) == 0))
            {
                sVal = "刚才";
            }
            else if ((Convert.ToInt32(v.TotalMinutes) > 5) && (Convert.ToInt32(v.TotalHours) == 0))
            {
                sVal = Convert.ToInt32(v.TotalMinutes) % 60 + " 分钟前";
            }
            else if (Convert.ToInt32(v.TotalHours) != 0)
            {
                sVal = "" + Convert.ToInt32(v.TotalHours) + " 小时" + Convert.ToInt32(v.TotalMinutes) % 60 + " 分前";
            }
            else
            {
                sVal = Convert.ToInt32(v.TotalMinutes) % 60 + " 分钟前";
            }
        }
        return sVal;
    }

    protected void DelBtn_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        DigitWork.BLL.BlogForum.Delete(id);
        DataList1.DataSource = DigitWork.BLL.BlogForum.GetBlogForums(BlogID);
        DataList1.DataBind();
    }

    
}
