﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class BlogList : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //权限

        GridView1.PageSize = new DigitWork.Config.BlogSettings().PageSize;

        //if (!string.IsNullOrEmpty(Request.QueryString["key"]) && !IsPostBack)
        //{
        //    string key = Request.QueryString["key"];
        //    SearchTextBox.Text = Server.UrlDecode(key);

        //    Filter(SearchTextBox.Text);
                       
        //}
    }
   

    protected string FormatDate(DateTime dt)
    {
        string sVal = "";

        //当前时间-发布时间
        TimeSpan v = DateTime.Now.Subtract(dt);

        if ((int)v.TotalDays != 0)
        {
            //大于一天
            sVal = Math.Abs(Convert.ToInt32(v.TotalDays)) + "天前";
        }
        else
        {
            if ((int)v.TotalMinutes < 5 && (int)v.TotalHours == 0)
            {
                sVal = "刚发布";
            }
            //else if ((Convert.ToInt32(v.TotalMinutes) > 5) && (Convert.ToInt32(Math.Abs(v.TotalHours)) == 0))
            //{
            //    sVal = Convert.ToInt32(v.TotalMinutes) % 60 + " 分钟前";
            //}
            else if ((int)v.TotalHours != 0)
            {
                sVal = "" + (int)v.TotalHours + " 小时" + (int)v.TotalMinutes % 60 + " 分前";
            }
            else
            {
                sVal = (int)v.TotalMinutes % 60 + " 分钟前";
            }
        }
        return sVal;
    }

    protected string SubStr(string content,int size)
    {
        content ="　　"+ Idcwest.Web.Utils.Helper.ClearHtml(content);
        if (content.Length > size)
            return content.Substring(0, size) + "......";

        return content;
    }

    protected void SearchBtn_Click(object sender, EventArgs e)
    {
        //Filter = "BlogList.aspx?filter="+SearchTextBox.Text.Trim();
        //PageCtrl1.Url = "BlogList.aspx?key="+Server.UrlEncode(SearchTextBox.Text.Trim());
        if (SearchTextBox.Text.Length <= 0)
        {
            BlogDS.SelectParameters["findExp"].DefaultValue ="";
            BlogDS.DataBind();
            return;
        }
        
        GridView1.DataBind();
        string key = SearchTextBox.Text;
        key = key.Replace("'", "''");
        string t = string.Format("Title LIKE '%{0}%' OR Content LIKE '%{0}%'", key);
        BlogDS.SelectParameters["findExp"].DefaultValue = t;
        BlogDS.DataBind();
    }

    ////根据关键字搜索
    //private void Filter(string key)
    //{
    //    key = key.Replace("'", "''");
    //    PageCtrl1.Url = "BlogList.aspx?key=" + Server.UrlEncode(key);
    //    string t = string.Format("Title LIKE '%{0}%' OR Content LIKE '%{0}%'",key);
    //    BlogDS.SelectParameters["findExp"].DefaultValue = t;
    //}
}
