﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

public partial class PageControl_PageCtrl : System.Web.UI.UserControl
{
    //GridView的ID
    public string GridViewID
    {
        set { ViewState["GridViewID"] = value; }
        get
        {
            object o = ViewState["GridViewID"];
            return o != null ? (string)o : "GridView1";
        }
    }

    //连接的URL
    public string Url
    {
        set { ViewState["Url"] = value; }
        get
        {
            object o = ViewState["Url"];
            return o != null ? (string)o : "";
        }
    }

    //一显示几个页码
    public int ExtendPage
    {
        set { ViewState["ExtendPage"] = value; }
        get
        {
            object o = ViewState["ExtendPage"];
            return o != null ? (int)o : 8;
        }
    }

    //模拟静态连接时的扩展名
    public string ExpName
    {
        set { ViewState["ExpName"] = value; }
        get
        {
            object o = ViewState["ExpName"];
            return o != null ? (string)o : ".aspx";
        }
    }

    //是否启用静态模式
    public bool StaticMode
    {
        set { ViewState["StaticMode"] = value; }
        get
        {
            object o = ViewState["StaticMode"];
            return o != null ? (bool)o : false;
        }
    }
    public bool DispGo
    {
        set { ViewState["DispGo"] = value; }
        get
        {
            object o = ViewState["DispGo"];
            return o != null ? (bool)o : false;
        }
    }
    public int SelectCountPage;

    public string SelectUrl;
    public int SelectCurPage;
    private GridView gv;


    protected void Page_Load(object sender, EventArgs e)
    {
        gv = (GridView)Parent.FindControl(GridViewID);
        if (gv != null)
            gv.DataBound += new EventHandler(gv_DataBound);
    }


    void gv_DataBound(object sender, EventArgs e)
    {
        //throw new Exception("The method or operation is not implemented.");
        int countPage = gv.PageCount;
        int pageSize = gv.PageSize;
        int curPage;
        SelectCountPage = countPage;
        if (!string.IsNullOrEmpty(Request.QueryString["page"]))
        {
            curPage = Convert.ToInt32(Request.QueryString["page"]);
        }
        else
        {
            curPage = 1;
        }
        SelectCurPage = curPage;

        PageNumLabel.Text = string.Format("页次:{0}/{1} 每页:{2}", curPage, countPage, pageSize);

        if (StaticMode) //静态链接
        {
            PageLabel.Text = GetStaticPageNumbers(curPage, countPage, Url, ExpName, ExtendPage);
            SelectUrl = Url + "_Page-{$pages}" + ExpName;
        }
        else
        {
            PageLabel.Text = GetPageNumbers(curPage, countPage, Url, ExtendPage);

            string selectUrl = Url;
            if (selectUrl.IndexOf("?") > 0)
            {
                selectUrl = selectUrl + "&";
            }
            else
            {
                selectUrl = selectUrl + "?";
            }

            SelectUrl = selectUrl + "&page={$pages}";
        }

        gv.PageIndex = curPage - 1;
    }

    public  string GetPageNumbers(int curPage, int countPage, string url, int extendPage)
    {
        int startPage = 1;
        int endPage = 1;

        if (url.IndexOf("?") > 0)
        {
            url = url + "&";
        }
        else
        {
            url = url + "?";
        }


        //第一页（首页）
        string t1 = "&nbsp;<a href=\"" + url + "page=1" + "\"><font face='webdings' Title='First Page'>9</font></a>&nbsp;";
        //最后一页（末页）
        string t2 = "<a href=\"" + url + "page=" + countPage + "\"><font face='webdings' Title='Last Page'>:</font></a>&nbsp;";
        //上一页（前一页）
        string t3 = "<a href=\"" + url + "page=" + (curPage - 1) + "\"><font face='webdings' Title='Prve Page'>3</font></a>&nbsp;";
        //下一页
        string t4 = "<a href=\"" + url + "page=" + (curPage + 1) + "\"><font face='webdings' Title='Next Page'>4</font></a>&nbsp;";

        if (countPage < 1) countPage = 1;
        if (extendPage < 3) extendPage = 2;

        if (countPage > extendPage)
        {
            if (curPage - (extendPage / 2) > 0)
            {
                if (curPage + (extendPage / 2) < countPage)
                {
                    startPage = curPage - (extendPage / 2);
                    endPage = startPage + extendPage - 1;
                }
                else
                {
                    endPage = countPage;
                    startPage = endPage - extendPage + 1;
                    t2 = "<font face='webdings' Title='Last Page'>:</font>&nbsp;";
                }
            }
            else
            {
                endPage = extendPage;
                t1 = "&nbsp;<font face='webdings' Title='First Page'>9</font>&nbsp;";
            }

        }
        else
        {
            startPage = 1;
            endPage = countPage;
            t1 = "&nbsp;<font face='webdings' Title='First Page'>9</font>&nbsp;";
            t2 = "<font face='webdings' Title='Last Page'>:</font>&nbsp;";
        }

        if (curPage <= 1)
            t3 = "<font face='webdings' Title='Prve Page'>3</font>&nbsp;";

        if (curPage >= countPage)
            t4 = "<font face='webdings' Title='Next Page'>4</font>&nbsp;";

        StringBuilder s = new StringBuilder("");

        s.Append(t1);
        s.Append(t3);
        for (int i = startPage; i <= endPage; i++)
        {
            if (i == curPage)
            {
                s.Append("&nbsp;");
                s.Append(i);
                s.Append("&nbsp;");
            }
            else
            {
                s.Append("&nbsp;<a href=\"");
                s.Append(url);
                s.Append("page=");
                s.Append(i);
                s.Append("\">");
                s.Append(i);
                s.Append("</a>&nbsp;");
            }
        }
        s.Append(t4);
        s.Append(t2);

        return s.ToString();
    }

    public  string GetStaticPageNumbers(int curPage, int countPage, string url, string expname, int extendPage)
    {
        int startPage = 1;
        int endPage = 1;

        //第一页（首页）
        string t1 = "&nbsp;<a href=\"" + url + "_Page-1" + expname + "\"><font face='webdings' Title='First Page'>9</font></a>&nbsp;";
        //最后一页（末页）
        string t2 = "<a href=\"" + url + "_Page-" + countPage + expname + "\"><font face='webdings' Title='Last Page'>:</font></a>&nbsp;";
        //上一页（前一页）
        string t3 = "<a href=\"" + url + "_Page-" + (curPage - 1) + expname + "\"><font face='webdings' Title='Prve Page'>3</font></a>&nbsp;";
        //下一页
        string t4 = "<a href=\"" + url + "_Page-" + (curPage + 1) + expname + "\"><font face='webdings' Title='Next Page'>4</font></a>&nbsp;";


        if (countPage < 1) countPage = 1;
        if (extendPage < 3) extendPage = 2;

        if (countPage > extendPage)
        {
            if (curPage - (extendPage / 2) > 0)
            {
                if (curPage + (extendPage / 2) < countPage)
                {
                    startPage = curPage - (extendPage / 2);
                    endPage = startPage + extendPage - 1;
                }
                else
                {
                    endPage = countPage;
                    startPage = endPage - extendPage + 1;
                    t2 = "<font face='webdings' Title='Last Page'>:</font>&nbsp;";

                }
            }
            else
            {
                endPage = extendPage;
                t1 = "&nbsp;<font face='webdings' Title='First Page'>9</font>&nbsp;";

            }


        }
        else
        {
            startPage = 1;
            endPage = countPage;
            t1 = "&nbsp;<font face='webdings' Title='First Page'>9</font>&nbsp;";
            t2 = "<font face='webdings' Title='Last Page'>:</font>&nbsp;";
        }

        if (curPage <= 1)
            t3 = "<font face='webdings' Title='Prve Page'>3</font>&nbsp;";

        if (curPage >= countPage)
            t4 = "<font face='webdings' Title='Next Page'>4</font>&nbsp;";

        StringBuilder s = new StringBuilder("");

        s.Append(t1);
        s.Append(t3);
        for (int i = startPage; i <= endPage; i++)
        {
            if (i == curPage)
            {
                s.Append("&nbsp;");
                s.Append(i);
                s.Append("&nbsp;");
            }
            else
            {
                s.Append("&nbsp;<a href=\"");
                s.Append(url);
                s.Append("_Page-");
                s.Append(i);
                s.Append(expname);
                s.Append("\">");
                s.Append(i);
                s.Append("</a>&nbsp;");
            }
        }
        s.Append(t4);
        s.Append(t2);

        return s.ToString();
    }
}
