﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class AddClienter : QMClient.UI.QMClientBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMClient))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        if (Request.QueryString["ID"] != null && ViewState["bSucc"] == null)
        {
            SaveReturnButton.CommandName = "UpdateReturn";
            SaveAddNextButton.CommandName = "UpdateNext";
            LinkButton1.CommandName = "UpdateReturn";
            LinkButton2.CommandName = "UpdateNext";
            TitleLabel.Text = "修改联系人";
            ReturnButton.PostBackUrl = "ReadClienter.aspx?ID=" + Request.QueryString["ID"];
            if (!IsPostBack)
            {
                QMClient.DAL.Table.ClientInfoTable client = QMClient.BLL.ClientInfo.GetById(int.Parse(Request.QueryString["ID"]));
                if (client != null)
                {
                    CNameTextBox.Text = client.CName;
                    //Response.Write(client.Sex.CompareTo("男"));
                    SexRadioButton.SelectedIndex = (client.Sex.CompareTo("男") > 0 ? 0 : 1);
                    MobileTextBox.Text = client.Mobile;
                    PhoneTextBox.Text = client.Phone;
                    AddressTextBox.Text = client.Address;
                    EmailTextBox.Text = client.Email;
                    RemarkTextBox.Text = client.Remark;
                    BirthTextBox.Text = client.Birth;
                    CategoryDropDownList.SelectedValue = client.CategoryID.ToString();

                }
            }
        }


    }
    protected void OnCommand(object sender, CommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Save":
                {

                    QMClient.BLL.ClientInfo.Insert(
                        CNameTextBox.Text.Trim(),
                        SexRadioButton.SelectedValue,
                        MobileTextBox.Text.Trim(),
                        PhoneTextBox.Text.Trim(),
                        AddressTextBox.Text.Trim(),
                        EmailTextBox.Text.Trim(),
                        RemarkTextBox.Text.Trim(),
                        DocTran.BLL.User.CurrentUser.ID,
                        int.Parse(CategoryDropDownList.SelectedValue),
                        BirthTextBox.Text.Trim()
                        );

                    //MsgLabel.Text = "添加成功！";
                    //MsgLabel.Visible = true;
                    //TypeNameTextBox.Text = "";
                    //TypeDescTextbox.Text = "";
                    //Response.Redirect("UserList.aspx");
                    Response.Redirect("MyClienter.aspx");
                }
                break;
            case "SaveAdd":
                {
                    QMClient.BLL.ClientInfo.Insert(
                        CNameTextBox.Text.Trim(),
                        SexRadioButton.SelectedValue,
                        MobileTextBox.Text.Trim(),
                        PhoneTextBox.Text.Trim(),
                        AddressTextBox.Text.Trim(),
                        EmailTextBox.Text.Trim(),
                        RemarkTextBox.Text.Trim(),
                        DocTran.BLL.User.CurrentUser.ID,
                        int.Parse(CategoryDropDownList.SelectedValue),
                        BirthTextBox.Text.Trim()
                        );

                    MsgLabel.Text = "添加成功！";
                    MsgPanel.Visible = true;

                    CNameTextBox.Text = "";
                    MobileTextBox.Text = "";
                    PhoneTextBox.Text = "";
                    AddressTextBox.Text = "";
                    EmailTextBox.Text = "";
                    RemarkTextBox.Text = "";

                }
                break;
            case "UpdateReturn":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = QMClient.BLL.ClientInfo.Update(id,
                        CNameTextBox.Text.Trim(),
                        SexRadioButton.SelectedValue,
                        MobileTextBox.Text.Trim(),
                        PhoneTextBox.Text.Trim(),
                        AddressTextBox.Text.Trim(),
                        EmailTextBox.Text.Trim(),
                        RemarkTextBox.Text.Trim(),
                        DocTran.BLL.User.CurrentUser.ID,
                        int.Parse(CategoryDropDownList.SelectedValue),
                        BirthTextBox.Text.Trim()
                        );
                    MsgLabel.Text = "保存成功！";
     
                    MsgPanel.Visible = true;
                }
                break;
            case "UpdateNext":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = QMClient.BLL.ClientInfo.Update(id,
                        CNameTextBox.Text.Trim(),
                        SexRadioButton.SelectedValue,
                        MobileTextBox.Text.Trim(),
                        PhoneTextBox.Text.Trim(),
                        AddressTextBox.Text.Trim(),
                        EmailTextBox.Text.Trim(),
                        RemarkTextBox.Text.Trim(),
                        DocTran.BLL.User.CurrentUser.ID,
                        int.Parse(CategoryDropDownList.SelectedValue),
                         BirthTextBox.Text.Trim()
                        );
                    if (bSuccess)
                    {
                        ViewState["bSucc"] = true;
                        MsgLabel.Text = "更新成功，你可以继续添加项！";
                        TitleLabel.Text = "添加客户";
                        MsgPanel.Visible = true;
                        CNameTextBox.Text = "";
                        MobileTextBox.Text = "";
                        PhoneTextBox.Text = "";
                        AddressTextBox.Text = "";
                        EmailTextBox.Text = "";
                        RemarkTextBox.Text = "";
                        ReturnButton.PostBackUrl = "AddClienter.aspx";
                    }
                }
                break;

        }
    }


}
