﻿/**
 * 大连西数网络技术有限公司 (C)2005-2008
 * 创建日期: 2008.6.17
 * 描述: 
 *     短信提醒业务
 * 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Utils = Idcwest.WebLibrary.Utils;
public partial class MyClienter : QMClient.UI.QMClientBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMClient))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        GridView1.PageSize = QMClient.BLL.ClientInfo.Settings.PageSize;

        if (!string.IsNullOrEmpty(Request.QueryString["key"]))
        {
            SearchTextBox.Text = Request.QueryString["key"];
        }
    }


    //全选
    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;

        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }
  

    //发送短信
    protected void OnSendSmsButton(object sender, EventArgs e)
    {

        int retVal = 0;
        QMClient.Sms sms = new QMClient.Sms();
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                //根据id 获取 手机号，发送短信
                string phone = QMClient.BLL.ClientInfo.GetById(int.Parse(idCheckBox.Text)).Mobile;
                retVal = sms.Send(phone, Content.Text.Trim(), DateTime.Now.ToString());
                
            }
            
        }

        if (retVal == 0)
        {
            MsgLabel.Text = "您至少需要选中一项，才能进行发送操作！";
            MsgPanel.Visible = true;

        }

        //if (sms.ResultIntValues.Count <=0 )
        //{
        //    MsgLabel.Text = "您至少需要选中一项，才能进行发送操作！";
        //    MsgPanel.Visible = true;
        //}
        //else
        //{

        //    int nSucc = sms.Result.FindAll(Succ).Count;
            

        //    MsgLabel.Text = string.Format("<strong><font color='red'>{0}</font></strong>项发送成功！",
        //            nSucc);
        //    MsgPanel.Visible = true;
        //}

    }
    private static bool Succ(Pair p)
    {
        return Convert.ToInt32(p.Second) == 1 ? true : false;
    }

    


    protected void SearchBtn_Click(object sender, EventArgs e)
    {

    }

    //打电话和发送短信
    protected void PhoneAndSms_OnCommand(object sender, CommandEventArgs e)
    {
        string phone = e.CommandArgument.ToString();
        switch (e.CommandName)
        {
            case "Phone":
                {
                    
                  
                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "call", "window.location='"+QMClient.Skype.Call(phone)+"'", true);

                   
                }
                break;
            case "Sms":
                {
                    /*
                    QMClient.Sms sms = new QMClient.Sms();
                    int retVal = sms.Send(phone, Content.Text.Trim(), DateTime.Now.ToString());
                    string alert = string.Format("alert('{0}')", sms.CodeStatus(retVal));
                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "err", alert, true);
                     */
                } 
                break;

        }
    }

     protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {

        //Label lbl = (Label)e.Row.Cells[
        //lbl.Text = "haha";
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            Label lbl = (Label)e.Row.Cells[2].FindControl("MobileLbl");
            if (lbl != null)
            {
                if (string.IsNullOrEmpty(lbl.Text))
                {
                    LinkButton lnk = (LinkButton)e.Row.Cells[2].FindControl("PhoneCallBtn");
                    if (lnk != null)
                        lnk.Visible = false;
                }
            }

            lbl = (Label)e.Row.Cells[3].FindControl("PhoneLbl");
            if (lbl != null)
            {
                if (string.IsNullOrEmpty(lbl.Text))
                {
                    LinkButton lnk = (LinkButton)e.Row.Cells[2].FindControl("PhoneCallBtn2");
                    if (lnk != null)
                        lnk.Visible = false;
                }
            }

        }
    }
}
