﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class SendAllSms : QMClient.UI.QMClientBasePage
{
    
    //接收人列表
    private List<Pair> InUserList = new List<Pair>();  //pair<username,userid>

    private Idcwest.Utils.WorkThread workThread;
    
   
    //接收人ID 用","隔开
    //private string _inceptNo = "";
    protected string InceptNo
    {
        set
        {
            //_inceptNo = value;
            ViewState["inceptNo"] = value;
        }
        get
        {
            if (ViewState["inceptNo"] != null)
                return (string)ViewState["inceptNo"];
            else
                return "";
        }
    }
   

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMSms))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

       

        if (ViewState["userlist"] != null)
            InUserList = (List<Pair>)ViewState["userlist"];


        #region 第一次运行时加载  通讯录

        if (!IsPostBack)
        {
            FillTree();
            //http://www.cnblogs.com/freeliver54/archive/2007/01/05/612393.html
            TreeView1.Attributes.Add("onclick", "postBackByObject()");   //客户端TreeView选中脚本
        }

        #endregion

        if (Session["work"] != null)
        {
            workThread = (Idcwest.Utils.WorkThread)Session["work"];
            switch (workThread.Status)
            {
                case Idcwest.Utils.WorkThreadStatus.Starting:
                    {
                        Timer1.Enabled = true;
                        MsgLabel.Text = "正在发送!" + workThread.ProcessMsg;
                        MsgPanel.Visible = true;
                        SendButton.Visible = false;
                    }
                    break;
                case Idcwest.Utils.WorkThreadStatus.Stop:
                    {
                        MsgLabel.Text = "操作完成!";
                        MsgPanel.Visible = true;
                        SendButton.Visible = true;
                        Session["work"] = null;
                        Timer1.Enabled = false;
                    }
                    break;
            }
        }
        else
        {
            MsgPanel.Visible = false;
        }

    }
    
    protected void Timer1_Tick(object sender, EventArgs e)
    {
        MsgLabel.Text =  workThread.ProcessMsg;
        if (workThread != null && workThread.Status == Idcwest.Utils.WorkThreadStatus.Stop)
            SendButton.Visible = true;
    }

    void workThread_Work(object sender,Idcwest.Utils.WorkThread.WorkEventArgs e)
    {
      
        QMClient.Sms qsms = new QMClient.Sms(e.userId);
        Idcwest.Utils.WorkThread wt = sender as Idcwest.Utils.WorkThread;
        int retVal;
        int i = 1;
        foreach (Pair p in e.userList)
        {
            if (string.IsNullOrEmpty(p.Second.ToString()))
                continue;

            retVal = qsms.Send(p.Second.ToString(), Content.Text, DateTime.Now.ToString());

            wt.ProcessMsg = string.Format("({0}/{1})发送至:{2} {3}", i++, e.userList.Count, p.First.ToString() , qsms.CodeStatus(retVal));
            System.Diagnostics.Debug.WriteLine(p.First.ToString() + ":" + p.Second.ToString());
            System.Threading.Thread.Sleep(1000);
        }

        e.status = Idcwest.Utils.WorkThreadStatus.Stop;
       
    }


    /// <summary>
    /// 填充用户用户树
    /// </summary>
    private void FillTree()
    {
        List<QMClient.DAL.Table.ClientCategoryTable> categoryList = QMClient.BLL.ClientCategory.GetClientCategorys(DocTran.BLL.User.CurrentUser.ID);

        foreach (QMClient.DAL.Table.ClientCategoryTable category in categoryList)
        {
            TreeNode root = new TreeNode(category.CategoryName, category.ID.ToString());
            List<QMClient.DAL.Table.ClientInfoTable> clientInfoList = QMClient.BLL.ClientInfo.GetClientInfos(DocTran.BLL.User.CurrentUser.ID, category.ID);
            root.SelectAction = TreeNodeSelectAction.None; //节点不响应事件处理

            foreach (QMClient.DAL.Table.ClientInfoTable client in clientInfoList)
            {

                TreeNode child = new TreeNode(client.CName,client.Mobile);
                child.SelectAction = TreeNodeSelectAction.None;
                root.ChildNodes.Add(child);
            }

            TreeView1.Nodes.Add(root);
        }

        TreeNode root2 = new TreeNode("无分类", "0");
        List<QMClient.DAL.Table.ClientInfoTable> clientInfoList2 = QMClient.BLL.ClientInfo.GetClientInfos(DocTran.BLL.User.CurrentUser.ID, 0);
        root2.SelectAction = TreeNodeSelectAction.None; //节点不响应事件处理
        foreach (QMClient.DAL.Table.ClientInfoTable client2 in clientInfoList2)
        {

            TreeNode child2 = new TreeNode(client2.CName, client2.Mobile);
            child2.SelectAction = TreeNodeSelectAction.None;
            root2.ChildNodes.Add(child2);
        }

        TreeView1.Nodes.Add(root2);
    }

    /// <summary>
    /// 验证 控件
    /// </summary>
    private bool RequirdField()
    {
        //收件人,主题,正文,都不能为空.
        if (InUserList.Count == 0)
        {
            MsgLabel.Text = "请在右边的通讯录中选择收件人!";
            MsgPanel.Visible = true;
            return false;
        }

       
        if (string.IsNullOrEmpty(Content.Text))
        {
            MsgLabel.Text += "请填写正文!";
            MsgPanel.Visible = true;
            return false;
        }
        return true;
    }


    //选中接收人
    protected void TreeView1_TreeNodeCheckChanged(object sender, TreeNodeEventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);

        //对子节点操作
        SetChildChecked(e.Node);

        //填充接收人列表及接收人TextBox
        FillInUser();
    }

    //单个部门的全部选定与取消
    private void SetChildChecked(TreeNode parentNode)
    {
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = parentNode.Checked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node);
            }
        }
    }

    //所有部门人员的全选
    private void SetAllChecked(TreeNode parentNode, bool chked)
    {
        parentNode.Checked = chked;
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = chked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node);
            }
        }
    }

    //填充接收人列表及接收人TextBox
    protected void FillInUser()
    {
        InUserList.Clear();
        InUserTextBox.Text = "";
        InceptNo = "";

        // Fill InUserList
        foreach (TreeNode node in TreeView1.Nodes)
            FillInUserList(node);

        ViewState["userlist"] = InUserList;

        FillInUserTextBox();

    }

    //递归调用填充收件人
    private void FillInUserList(TreeNode rootNode)
    {


        foreach (TreeNode node in rootNode.ChildNodes)
        {
            if (node.Checked)
            {
                InUserList.Add(new Pair(node.Text, node.Value));
            }

            if (node.ChildNodes.Count > 0)
            {
                FillInUserList(node);
            }
        }
    }

    //填充收件人TexBox
    private void FillInUserTextBox()
    {

        if (InUserList.Count != 0)
        {
            string inUsername = "";
            foreach (Pair pair in InUserList)
            {
                inUsername += pair.First.ToString() + ",";
                //InceptNo += pair.Second.ToString() + ",";
            }

            //去除最后一个","
            //InceptNo = InceptNo.Remove(InceptNo.LastIndexOf(","));

            inUsername = inUsername.Remove(inUsername.LastIndexOf(","));
            InUserTextBox.Text = inUsername;
            InUserTextBox.Style.Add("color", "red");
        }
        else
        {
            InUserTextBox.Text = "请从右边通讯录选择收件人";
            InUserTextBox.Style.Add("color", "#cccccc");
        }
    }

    /// <summary>
    /// 通讯录全选
    /// </summary>
    protected void AllSelectChkBox_CheckedChanged(object sender, EventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);

        foreach (TreeNode node in TreeView1.Nodes)
            SetAllChecked(node, AllSelectChkBox.Checked);

        FillInUser();
    }

    List<Pair> smsRetValList = new List<Pair>();

    //private void SendSms(localhost.DigitWestSmsService sms, QMClient.DAL.Table.SmsConfigTable s,string msg)
    //{ /*
    //   if ( msg > 70 )
    //       折分出前70个字

    //   发送

    //   将剩余的字递归发送
    //  */
    //    if (msg.Length <= 0)
    //        return;

    //    string t = msg;
    //    if (msg.Length > 70)
    //        t = msg.Substring(0, 70);
        
    //    int retVal = sms.SendSms(s.CoreID.ToString(), s.UserName, s.Password, p.Second.ToString(), t, DateTime.Now.ToString(), "10");
    //    smsRetValList.Add(new Pair(p, retVal));

    //    t = msg.Substring(70 + 1);
    //    SendSms(sms, s, t);

    //}

    //发送
    
    //发送短信
    protected void SendButton_Command(object sender, CommandEventArgs e)
    {

        //验证
        if (RequirdField() == false)
            return;
        
        

       // localhost.DigitWestSmsService sms = new localhost.DigitWestSmsService();
       
        QMClient.DAL.Table.SmsConfigTable s = QMClient.BLL.SmsConfig.GetById(DocTran.BLL.User.CurrentUser.ID);

        if (s == null)
        {
            MsgLabel.Text = "没有余额，发送失败！";
            MsgPanel.Visible = true;
            return;
        }

        //QMClient.Sms qsms = new QMClient.Sms();
        
        //foreach (Pair p in InUserList)
        //{
          
        //    qsms.Send(p.Second.ToString(), Content.Text, DateTime.Now.ToString());

        //}

        workThread = new Idcwest.Utils.WorkThread();
        workThread.Work += new Idcwest.Utils.WorkThread.WorkEvent(workThread_Work);
        workThread.UserID = DocTran.BLL.User.CurrentUser.ID;
        workThread.UserList = InUserList;
        Session["work"] = workThread;
               

        workThread.Run();

        SendButton.Visible = false;
        Timer1.Enabled = true;

        MsgLabel.Text = "正在发送!";
        MsgPanel.Visible = true;



        //string str = "";
        //foreach (Pair pair in smsRetValList)
        //{
        //    Pair p = (Pair)pair.First;
        //    str += p.First + " : " + p.Second + "&nbsp; " + CodeStatus((int)pair.Second) + "<br/>";
        //}

        //foreach (Pair p in qsms.Result)
        //{
        //    str += p.First + " : " + p.Second + "&nbsp; " + "<br/>";
        //}

        //resutlLabel.Text = str;
    }

    public string CodeStatus(int code)
    {
        string retVal = "";
        if (code == 1)
            retVal = "发送成功";
        else if (code == -10)
            retVal = "字数太多";
        else if (code == -30)
            retVal = "余额不足";
        else if (code == -20)
            retVal = "用户或密码错误";
        else if (code == -40)
            retVal = "发送失败";
        else if (code == -1)
            retVal = "发送错误";
        return retVal;

    }
}
