﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class SendSms : QMClient.UI.QMClientBasePage
{
    
    //接收人列表
    private List<Pair> InUserList = new List<Pair>();  //pair<username,userid>

   
    //接收人ID 用","隔开
    //private string _inceptNo = "";
    protected string InceptNo
    {
        set
        {
            //_inceptNo = value;
            ViewState["inceptNo"] = value;
        }
        get
        {
            if (ViewState["inceptNo"] != null)
                return (string)ViewState["inceptNo"];
            else
                return "";
        }
    }
   

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMSms))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

       

        if (ViewState["userlist"] != null)
            InUserList = (List<Pair>)ViewState["userlist"];


       

        

    }



    /// <summary>
    /// 验证 控件
    /// </summary>
    private bool RequirdField()
    {
        //收件人,主题,正文,都不能为空.
        if (string.IsNullOrEmpty(InUserTextBox.Text))
        {
            MsgLabel.Text = "请填写手机号吗!";
            MsgPanel.Visible = true;
            return false;
        }

       
        if (string.IsNullOrEmpty(Content.Text))
        {
            MsgLabel.Text += "请填写正文!";
            MsgPanel.Visible = true;
            return false;
        }
        return true;
    }


   

    List<Pair> smsRetValList = new List<Pair>();
    //发送
    protected void SendButton_Command(object sender, CommandEventArgs e)
    {

        //验证
        if (RequirdField() == false)
            return;
        QMClient.Sms qsms = new QMClient.Sms();

        string [] ms = InUserTextBox.Text.Split(',');
        int retVal = 0;
        foreach (string p in ms)
        {
            //Response.Write(p.First + "-" + p.Second);

            retVal = qsms.Send(p, Content.Text, DateTime.Now.ToString());

        }
        if (retVal == 1)
        {
            MsgLabel.Text = "发送完成!";
            MsgPanel.Visible = true;
        }
        else
        {
            MsgLabel.Text = "发送失败!";
            MsgPanel.Visible = true;
        }


        //string str = "";
        //foreach (Pair p in qsms.Result)
        //{
        //    str += p.First + " : " + p.Second + "&nbsp; " + "<br/>";
        //}
        //resutlLabel.Text = str;
    }

    public string CodeStatus(int code)
    {
        string retVal = "";
        if (code == 1)
            retVal = "发送成功";
        else if (code == -10)
            retVal = "字数太多";
        else if (code == -30)
            retVal = "余额不足";
        else if (code == -20)
            retVal = "用户或密码错误";
        else if (code == -40)
            retVal = "发送失败";
        return retVal;

    }
}
