﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Utils = Idcwest.WebLibrary.Utils;
public partial class ReadMail : DocTran.UI.BasePage
{

    //public DocTran.BLL.Doc Mail
    //{
    //    get
    //    {
    //        if (ViewState["mail"] != null)
    //        {
    //            _mail = (DocTran.BLL.Doc)ViewState["mail"];
    //        }
    //        else
    //        {
    //            if (Request.QueryString["ID"] != null)
    //            {
    //                int docId = int.Parse(Request.QueryString["ID"]);
    //                _mail = DocTran.BLL.Doc.GetDocByID(docId);
    //                if (_mail != null)
    //                    ViewState["mail"] = _mail;

    //            }
    //        }
    //    }
    //}

    /// <summary>
    /// 发件人
    /// </summary>
    private string _sendUserName = "";
    public string SendUserName
    {
        set
        {
            _sendUserName = value;
        }
        get
        {
            return _sendUserName;
        }
    }
    private string _inceptUserName = "";
    public string InceptUserName
    {
        set
        {
            _inceptUserName = value;
        }
        get
        {
            return _inceptUserName;
        }
    }

    private string _sendDate = "";
    public string SendDate
    {
        set
        {
            _sendDate = value;
        }
        get
        {
            return _sendDate;
        }
    }

    private string _subject = "";
    public string Subject
    {
        set
        {
            _subject = value;
        }
        get
        {
            return _subject;
        }
    }

    private string _contnet = "";
    public string Content
    {
        set
        {
            _contnet = value;
        }
        get
        {
            return _contnet;
        }
    }

    private string _acc = "";
    public string Acc
    {
        set
        {
            _acc = value;
        }
        get
        {
            return _acc;
        }
    }

    private int _docId = 0;
    public int DocID
    {
        set
        {
            _docId = value;
        }
        get
        {
            return _docId;
        }
    }

    private List<int> _idList = new List<int>();
    public List<int> IdList
    {
        set { _idList = value; }
        get { return _idList; }
    }


    private int _prvIndex = 0;
    public int PrvIndex
    {
        set { _prvIndex = value; }
        get { return _prvIndex; }
    }

    private int _nextIndex = 0;
    public int NextIndex
    {
        set { _nextIndex = value; }
        get { return _nextIndex; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        DocTran.BLL.Doc mail = null;

        if (Request.QueryString["ID"] != null)
        {
            DocID = int.Parse(Request.QueryString["ID"]);
            mail = DocTran.BLL.Doc.GetDocByID(DocID);
            if (mail != null)
            {
                // ViewState["mail"] = mail;

                SendUserName = mail.SendUserName;
                InceptUserName = DocTran.BLL.User.CurrentUser.FullName;
                SendDate = mail.SendDate.ToString();
                Subject = mail.Title;
                Content = mail.Content;
                
                InitPrvNextLink();

                
                //将读过的文件,标记为已经阅读过

                int curUserID = DocTran.BLL.User.CurrentUser.ID;
                
                DocTran.BLL.DocSign docSign= DocTran.BLL.DocSign.GetDocSign(curUserID, DocID);
                 
                if ( !docSign.IsSign())
                      DocTran.BLL.DocSign.UpdateDocSign(curUserID, DocID);
            }

        }

        if (Request.QueryString["fid"] != null && Request.QueryString["fid"] == "all")
        {
            DocHyperLink.NavigateUrl = "MailList.aspx";
            DocHyperLink2.NavigateUrl = "MailList.aspx";
        }

    }

    protected void InitPrvNextLink()
    {
        #region 提取上一个,下一个
        //List<DocTran.BLL.Doc> docList = null;
        //if (Cache["noreadlist"] != null)
        //{
        //    docList = (List<DocTran.BLL.Doc>)Cache["noreadlist"];
        //}
        //else
        //{
        //    docList = DocTran.BLL.Doc.GetDocNoRead(DocTran.BLL.User.CurrentUserID, "", 0, int.MaxValue - 1);
        //    Cache.Insert("noreadlist", docList);
        //}
        List<DocTran.BLL.Doc> docList = null;

        bool bReadAll = (Request.QueryString["fid"] != null && Request.QueryString["fid"] == "all");
        if ( bReadAll )
        {
            docList = DocTran.BLL.Doc.GetDocRead("",DocTran.BLL.User.CurrentUser.ID, "", 0, int.MaxValue - 1);
        }
        else{
            docList = DocTran.BLL.Doc.GetDocNoRead(DocTran.BLL.User.CurrentUser.ID, "", 0, int.MaxValue - 1);
        }

        for (int i = 0; i < docList.Count; i++)
        {
            if (DocID == docList[i].ID)
            {
                if (i != 0) //上一个   
                {
                    //应用在未读公文
                    string url = "readMail.aspx?ID=" + docList[i - 1].ID.ToString();;
                    if (bReadAll) //应用在公文收件箱
                        url = "readMail.aspx?fid=all&ID=" + docList[i - 1].ID.ToString();
                    PrvLink.NavigateUrl = url;
                    PrvLink2.NavigateUrl = url;
                }
                else
                {
                    PrvLink.Visible = false;
                    PrvLink2.Visible = false;
                }



                if (i != docList.Count - 1)
                {
                    string url = "readMail.aspx?ID=" + docList[i + 1].ID.ToString(); ;
                    if (bReadAll)
                        url = "readMail.aspx?fid=all&ID=" + docList[i + 1].ID.ToString();

                    NextLink.NavigateUrl = url;
                    NextLink2.NavigateUrl = url;
                }
                else
                {
                    NextLink.Visible = false;
                    NextLink2.Visible = false;
                }

                break;
            }
        }

        #endregion
    }

    public string BytesToMBOrKb(decimal bytes)
    {
        if (bytes == 0)
            return "0";

        decimal size = Utils.XConvert.BytesToMB(bytes, 2);
        string retVal = size.ToString() + "MB";
        if (size == 0)
        {
            size = Utils.XConvert.BytesToKB(bytes, 2);
            retVal = size.ToString() + "KB";
        }
        return retVal;
    }

    //删除
    protected void DelBtn_Click(object sender, EventArgs e)
    {
        DocTran.BLL.DocSign.Recycle(DocTran.BLL.User.CurrentUser.ID, DocID);
        if (Request.QueryString["fid"] != null && Request.QueryString["fid"] == "all")
        {
            Response.Redirect("MailList.aspx");
        }
       
    }
}
