﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class WriteBlog : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.DocPublish))
        //{
        //    Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
        //    Response.End();
        //}

        if (!string.IsNullOrEmpty(Request.QueryString["mode"])
            && !string.IsNullOrEmpty(Request.QueryString["ID"])
            && !IsPostBack)
        {
            //编辑状态,只能编辑自己的

            int id = int.Parse(Request.QueryString["ID"]);
            DigitWork.BLL.Blog blog = DigitWork.BLL.Blog.GetById(id);
            if (blog != null && blog.UserID == DocTran.BLL.User.CurrentUser.ID 
                || DocTran.BLL.User.CurrentUser.ID ==1)
            {
                
                SendButton.CommandName = "Edit";
                SaveButton2.CommandName = "Edit";

                SubjectTextBox.Text = blog.Title;
                Content.Value = blog.Content;
                LogCheckBox.Checked = blog.IsLog;
            }

        }

    }

    protected void SendButton_Command(object sender, CommandEventArgs e)
    {
        string title = Idcwest.Web.Utils.Helper.ClearHtml(SubjectTextBox.Text.Trim());

        switch (e.CommandName)
        {
            case "Add":
                { //添加日志
                    
                    int retVal = DigitWork.BLL.Blog.Insert(0, title, Content.Value, DateTime.Now, DocTran.BLL.User.CurrentUser.CurrentUserID, LogCheckBox.Checked);
                    if (retVal != 0)
                        Idcwest.Web.Utils.JavaScript.AlertRedirect("发布成功", "readBlog.aspx?ID=" + retVal.ToString());
                }
                break;
            case "Edit":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    DigitWork.BLL.Blog blog = DigitWork.BLL.Blog.GetById(id);
                    blog.Title = title;
                    blog.IsLog = LogCheckBox.Checked;
                    blog.Content = Content.Value + string.Format("<div style='float:right;color:blue;' >作者于{0}修改过</div>", DateTime.Now);
                    if ( DigitWork.BLL.Blog.Update(blog))
                        Idcwest.Web.Utils.JavaScript.AlertRedirect("修改成功", "readBlog.aspx?ID=" + id.ToString());

                }
                break;
        }


    }

    protected void ResizeFckHeight_Command(object sender, CommandEventArgs e)
    {
        int h = (int)Content.Height.Value;
        if (e.CommandName == "Add")
        {
            Content.Height = Unit.Pixel(50 + h);
        }
        else if (e.CommandName == "Sub")
        {
            if (h - 50 > 100)
            {
                Content.Height = Unit.Pixel(h - 50);
            }
        }
        //重新定义高度
        ScriptManager.RegisterStartupScript(this, this.GetType(), "fsize", "framesize('mainbody');", true);
    }
}
