﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class WriteMail : DocTran.UI.BasePage
{
    /// <summary>
    /// 记录附件个数
    /// </summary>
    private int CtrlCnt
    {
        set { ViewState["cnt"] = value; }
        get
        {
            object obj = ViewState["cnt"];
            if (obj != null)
                return (int)ViewState["cnt"];
            else
                return 0;
        }
    }

    //接收人列表
    private List<Pair> InUserList = new List<Pair>();  //pair<username,userid>

    //附件列表
    private List<DocTran.BLL.Accessories> AccList = new List<DocTran.BLL.Accessories>();


    //接收人ID 用","隔开
    //private string _inceptNo = "";
    protected string InceptNo
    {
        set
        {
            //_inceptNo = value;
            ViewState["inceptNo"] = value;
        }
        get
        {
            if (ViewState["inceptNo"] != null)
                return (string)ViewState["inceptNo"];
            else
                return "";
        }
    }
    //附件文档名 用"|"隔开
    //private string AccFile = "";
    [Obsolete("已过期,不再使用")]
    protected string AccFile
    {
        set
        {
            ViewState["accFile"] = value;
        }
        get
        {
            if (ViewState["accFile"] != null)
                return (string)ViewState["accFile"];
            else
                return "";
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.DocPublish))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        //是否打开发短信功能
        if (Settings.EnableSMS)
            SendSMSChkBox.Visible = true;


        if (ViewState["userlist"] != null)
            InUserList = (List<Pair>)ViewState["userlist"];


        #region 第一次运行时加载  通讯录

        if (!IsPostBack)
        {
            FillTree();
            //http://www.cnblogs.com/freeliver54/archive/2007/01/05/612393.html
            TreeView1.Attributes.Add("onclick", "postBackByObject()");   //客户端TreeView选中脚本
        }

        #endregion

        #region 初始附件控件
        if (IsPostBack)
        {

            PlaceHolder1.Controls.Clear();
            for (int i = 0; i < CtrlCnt; i++)
            {
                UpFileCtrl upfileCtrl = (UpFileCtrl)LoadControl("UpFileCtrl.ascx");
                if (upfileCtrl != null)
                {
                    upfileCtrl.ID = "inputfile" + i.ToString();
                    PlaceHolder1.Controls.Add(upfileCtrl);
                }

            }

        }
        #endregion

    }


    /// <summary>
    /// 填充部门用户树
    /// </summary>
    private void FillTree()
    {
        List<DocTran.BLL.Deptment> deptList = DocTran.BLL.Deptment.GetDeptments();
        foreach (DocTran.BLL.Deptment dept in deptList)
        {
            TreeNode root = new TreeNode(dept.DeptName, dept.ID.ToString());
            List<DocTran.BLL.User> userList = DocTran.BLL.User.GetUsersByDeptID(dept.ID);
            root.SelectAction = TreeNodeSelectAction.None; //节点不响应事件处理

            foreach (DocTran.BLL.User user in userList)
            {
                //if (user.ID == DocTran.BLL.User.CurrentUser.ID)  //不在列表中添加自己的姓名
                //    continue;
                if ( DocTran.BLL.User.CurrentUser.ID==1)  //不在列表中添加管理员
                    continue;

                TreeNode child = new TreeNode(user.FullName, user.ID.ToString());
                child.SelectAction = TreeNodeSelectAction.None;
                root.ChildNodes.Add(child);
            }

            TreeView1.Nodes.Add(root);
        }
    }

    /// <summary>
    /// 验证 控件
    /// </summary>
    private bool RequirdField()
    {
        //收件人,主题,正文,都不能为空.
        if (InUserList.Count == 0)
        {
            MsgLabel.Text = "请在右边的通讯录中选择收件人!";
            MsgPanel.Visible = true;
            return false;
        }

        if (string.IsNullOrEmpty(SubjectTextBox.Text.Trim()))
        {

            MsgLabel.Text += "请填写主题!";
            MsgPanel.Visible = true;
            return false;
        }
        if (string.IsNullOrEmpty(Content.Value))
        {
            MsgLabel.Text += "请填写正文!";
            MsgPanel.Visible = true;
            return false;
        }
        return true;
    }


    //选中接收人
    protected void TreeView1_TreeNodeCheckChanged(object sender, TreeNodeEventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);

        //对子节点操作
        SetChildChecked(e.Node);

        //填充接收人列表及接收人TextBox
        FillInUser();
    }

    //单个部门的全部选定与取消
    private void SetChildChecked(TreeNode parentNode)
    {
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = parentNode.Checked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node);
            }
        }
    }

    //所有部门人员的全选
    private void SetAllChecked(TreeNode parentNode, bool chked)
    {
        parentNode.Checked = chked;
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = chked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node);
            }
        }
    }

    //填充接收人列表及接收人TextBox
    protected void FillInUser()
    {
        InUserList.Clear();
        InUserTextBox.Text = "";
        InceptNo = "";

        // Fill InUserList
        foreach (TreeNode node in TreeView1.Nodes)
            FillInUserList(node);

        ViewState["userlist"] = InUserList;

        FillInUserTextBox();

    }

    //递归调用填充收件人
    private void FillInUserList(TreeNode rootNode)
    {


        foreach (TreeNode node in rootNode.ChildNodes)
        {
            if (node.Checked)
            {
                InUserList.Add(new Pair(node.Text, node.Value));
            }

            if (node.ChildNodes.Count > 0)
            {
                FillInUserList(node);
            }
        }
    }

    //填充收件人TexBox
    private void FillInUserTextBox()
    {

        if (InUserList.Count != 0)
        {
            string inUsername = "";
            foreach (Pair pair in InUserList)
            {
                inUsername += pair.First.ToString() + ",";
                //InceptNo += pair.Second.ToString() + ",";
            }

            //去除最后一个","
            //InceptNo = InceptNo.Remove(InceptNo.LastIndexOf(","));

            inUsername = inUsername.Remove(inUsername.LastIndexOf(","));
            InUserTextBox.Text = inUsername;
            InUserTextBox.Style.Add("color", "red");
        }
        else
        {
            InUserTextBox.Text = "请从右边通讯录选择收件人";
            InUserTextBox.Style.Add("color", "#cccccc");
        }
    }

    /// <summary>
    /// 通讯录全选
    /// </summary>
    protected void AllSelectChkBox_CheckedChanged(object sender, EventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);

        foreach (TreeNode node in TreeView1.Nodes)
            SetAllChecked(node, AllSelectChkBox.Checked);

        FillInUser();
    }


    //发送
    protected void SendButton_Command(object sender, CommandEventArgs e)
    {

        //验证
        if (RequirdField() == false)
            return;

        //不好用
        //ScriptManager.RegisterStartupScript(this, this.GetType(), "DispProcess", "alert('hello')", true);

        List<Pair> fileList = Attach();  //获取附件列表

        bool bRetVal = false;

        List<Pair> smsRetValList = null; //发短信的返回结果

        #region 将文档资料写入数据
        try
        {

            //将值写入到 doc 数据库中
            //docID = DocTran.BLL.Doc.InsertDoc(InceptNo, SubjectTextBox.Text.Trim(), IsFeedBackChkBox.Checked,
            //    "", DateTime.Now, DocTran.BLL.User.CurrentUser.ID,
            //    int.Parse(DocTypeDropList.SelectedValue), 
            //    Content.Value, AccFile,
            //    1,                                          //暂时定义 1 为 公文类型
            //    false, IsSaveChkBox.Checked);
            
            /*已过期
            bRetVal = DocTran.BLL.User.CurrentUser.WriteMail_0_1(
                InUserList,
                SubjectTextBox.Text.Trim(),
                int.Parse(DocTypeDropList.SelectedValue),
                Content.Value,
                AccFile
                );
           */
            /*
            bRetVal = DocTran.BLL.User.CurrentUser.WriteMail_0_2(
                InUserList,
                Server.HtmlEncode(SubjectTextBox.Text.Trim()), //不充许发送html代码
                int.Parse(DocTypeDropList.SelectedValue),
                Content.Value,
                AccList);
             */

            bRetVal = DocTran.BLL.User.CurrentUser.WriteMail_0_3(
               InUserList,
               Server.HtmlEncode(SubjectTextBox.Text.Trim()), //不充许发送html代码
               int.Parse(DocTypeDropList.SelectedValue),
               Content.Value,
               AccList);

            if (Settings.EnableSMS && SendSMSChkBox.Checked)
            {
                smsRetValList = DocTran.BLL.User.CurrentUser.SendSMS(InUserList, Idcwest.WebLibrary.Utils.Helper.ClearHtml(SubjectTextBox.Text.Trim()));
            }
        }
        catch (Exception ex)
        {
            /*
             * if ( docid != 0)
             *    delete doid row
             */
            RedirectError(ex.Message + ex.StackTrace);
            return;

        }
        #endregion



        //#region 写入将要签收的用户
        //try
        //{
        //    //将接收用户ID 与文档ID 写入签收数据库
        //    foreach (Pair pair in InUserList)
        //    {
        //        int userID =  Convert.ToInt32(pair.Second);
        //        DocTran.BLL.DocSign.InsertDocSign(userID, docID);
        //    }
        //}
        //catch (Exception ex)
        //{
        //    /*
        //     * if (docid != 0)
        //     *      delete docid file
        //     */
        //    //转到出错页！
        //    //Response.Redirect("ErrorMsg.aspx?errmsg=" + ex.Message);
        //    RedirectError(ex.Message +  ex.StackTrace);
        //    return;
        //}

        //#endregion

        ////上边如果出现错误，不再继续执行下去。

        //if (fileList.Count == 0)
        //    RedirectSuccess("发送成功!");

        #region 上传附件
             
         //发送数据成功,上传附件
         if ( bRetVal && UploadAcc(fileList))
             RedirectSuccess("发送成功!");
        #endregion
         
    }


    //取得上传附件的文件名,及上传控件对象
    private List<Pair> Attach()
    {

        List<Pair> fileObjList = new List<Pair>();

        try
        {
            for (int i = 0; i < CtrlCnt; i++)
            {
                UpFileCtrl upfileCtrl = (UpFileCtrl)PlaceHolder1.FindControl("inputfile" + i.ToString());
                if (upfileCtrl != null)
                {
                    InputFile infile = (InputFile)upfileCtrl.FindControl("infile");
                    if (infile != null && infile.FileName != null)
                    {
                        DocTran.BLL.Accessories acc = new DocTran.BLL.Accessories();
                        //acc.DocID 在写入文档后在赋值
                        //acc.Subject 在写入文档后在赋值
                        acc.DispName = infile.FileName;
                        string ext = infile.FileName.Substring(infile.FileName.LastIndexOf(".")); //取扩展名
                        
                        acc.FileName = Guid.NewGuid().ToString() + ext; //使用GUID值做为文件的名称

                        acc.FileSize = Convert.ToDecimal(infile.ContentLength);
                        acc.SendDate = DateTime.Now;
                        
                        AccList.Add(acc);

                        fileObjList.Add(new Pair(infile, acc.FileName));
                    }
                }

            }

            return fileObjList;
        }
        catch (Exception ex)
        {
            RedirectError(HttpUtility.UrlEncode(ex.Message + ex.StackTrace));
            return null;
        }
    }

    //上传附件
    private bool UploadAcc(List<Pair> fileObjList)
    {
        try
        {
            if (fileObjList != null && fileObjList.Count != 0)
            {
                //上传文件
                foreach (Pair pair in fileObjList)
                {
                    InputFile inputFile = (InputFile)pair.First;
                    string fileName = (string)pair.Second;

                    //将上传的文件转移到指定的目录
                    inputFile.MoveTo(Path.Combine(Request.PhysicalApplicationPath + Settings.UploadDir, fileName),
                                   MoveToOptions.Overwrite);
                }

                return true;
            }
            else if (fileObjList != null && fileObjList.Count == 0) //没有附件返回true
            {
                return true;
            }
            else
                return false;

        }
        catch (Exception ex)
        {
            RedirectError(ex.Message);
            return false;
        }
        finally { }
    }
        
    protected void SaveButton_Command(object sender, CommandEventArgs e)
    {
        //验证
        if (RequirdField() == false)
            return;

        //上传附件
        try
        {
            for (int i = 0; i < CtrlCnt; i++)
            {
                UpFileCtrl upfileCtrl = (UpFileCtrl)PlaceHolder1.FindControl("inputfile" + i.ToString());
                if (upfileCtrl != null)
                {
                    InputFile infile = (InputFile)upfileCtrl.FindControl("infile");
                    if (infile != null && infile.FileName != null)
                    {
                        infile.MoveTo(Path.Combine(Request.PhysicalApplicationPath + "\\UploadFiles", infile.FileName),
                             MoveToOptions.Overwrite);

                    }
                }

            }
        }
        catch (Exception ex)
        {
            Response.Redirect("ErrorMsg.aspx?errmsg=" + ex.Message);
            return;
        }

        //添加状态的保存

        //编辑状态的保存
    }

    /// <summary>
    /// 添加附件
    /// </summary>
    protected void AddAcc_Click(object sender, EventArgs e)
    {
        if (CtrlCnt < Settings.AccessoriesCount)
        { 
            CtrlCnt++;
            PlaceHolder1.Controls.Clear();
            for (int i = 0; i < CtrlCnt; i++)
            {
                UpFileCtrl upfileCtrl = (UpFileCtrl)LoadControl("UpFileCtrl.ascx");
                if (upfileCtrl != null)
                {
                    upfileCtrl.ID = "inputfile" + i.ToString();
                    PlaceHolder1.Controls.Add(upfileCtrl);

                }

            }
           
        }
    }

    
    protected void ResizeFckHeight_Command(object sender, CommandEventArgs e)
    {
        int h = (int)Content.Height.Value;
        if (e.CommandName == "Add")
        {
            Content.Height = Unit.Pixel(50 + h);
        }
        else if ( e.CommandName == "Sub")
        {
            if (h - 50 > 100)
            {
                Content.Height = Unit.Pixel(h - 50);
            }
        }
        //重新定义高度
        ScriptManager.RegisterStartupScript(this, this.GetType(),"fsize", "framesize('mainbody');", true);
    }
}
