﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class WriteWarning : DocTran.UI.BasePage
{

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.WarningPublish))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        } 
    }

    /// <summary>
    /// 验证 控件
    /// </summary>
    private bool RequirdField()
    {
        if (string.IsNullOrEmpty(SubjectTextBox.Text.Trim()))
        {

            MsgLabel.Text += "请填写公告主题!";
            MsgPanel.Visible = true;
            return false;
        }
        if (string.IsNullOrEmpty(Content.Value))
        {
            MsgLabel.Text += "请填写公告正文!";
            MsgPanel.Visible = true;
            return false;
        }
        return true;
    }
                    
    protected void ResizeFckHeight_Command(object sender, CommandEventArgs e)
    {
        int h = (int)Content.Height.Value;
        if (e.CommandName == "Add")
        {
            Content.Height = Unit.Pixel(50 + h);
        }
        else if ( e.CommandName == "Sub")
        {
            if (h - 50 > 100)
            {
                Content.Height = Unit.Pixel(h - 50);
            }
        }
        //重新定义高度
        ScriptManager.RegisterStartupScript(this, this.GetType(),"fsize", "framesize('mainbody');", true);
    }

    protected void SendButton_Click(object sender, EventArgs e)
    {
        //验证
        if (RequirdField() == false)
            return;

        int retVal = DocTran.BLL.Warning.WriteWarning(Server.HtmlEncode(SubjectTextBox.Text.Trim()),
            Content.Value, 
            DocTran.BLL.User.CurrentUser.ID,
            DateTime.Now);
        if (retVal != 0)
            Idcwest.WebLibrary.Utils.JavaScript.AlertRedirect("公告发布成功!", "?");

    }
}
