<?php
/* * *********************************************************
 * [cml] (C)2012 - 3000 cml http://linhecheng.com
 * @Author  linhecheng<linhechengbush@live.com>
 * @Date: 13-6-26 上午11:23
 * @version  1.0 
 * cml框架 项目基类，用于自动创建所需要的项目目录和文件结构以及异常处理
 * *********************************************************** */

defined('CML_PATH') || exit();

class CmlBase
{
	// 致命错误捕获
	public static function fatalError()
	{
		if ($error = error_get_last()) {
			if(in_array($error['type'], array(1, 4, 16, 64, 32, 128))) {
				if(!$GLOBALS['APP_DEBUG']) {
					//正式环境 只显示‘系统错误’并将错误信息记录到日志
					error_log('['.date('Y-m-d h:i:s').'] [message]'.$error['message'].'[file]'.$error['file'].'[line]'.$error['line']."\n\r", 3, RUNTIME_LOGS_PATH.DIR_SEP.APP_PATH.DIR_SEP.'fatal_error_'.date('Y-m-d').'.log');                    
					$error = array();
					$error['message'] = L('_CML_ERROR_');
				}

				header('HTTP/1.1 500 Internal Server Error');
				require C('TMPL_EXCEPTION');
			}
		}
	}
    
	/**
	 * 自定义异常处理
	 *
	 * @access public
	 * @param mixed $e 异常对象
	 */
	public static function appException($e)
	{
		$error = array();
		$error['message'] = $e->getMessage();
		$trace  =   $e->getTrace();
		if('throw_exception' == $trace[0]['function']) {
			$error['file'] = $trace[0]['file'];
			$error['line'] = $trace[0]['line'];
		}else{
			$error['file'] = $e->getFile();
			$error['line'] = $e->getLine();
		}

		if(!$GLOBALS['APP_DEBUG']) {
			//正式环境 只显示‘系统错误’并将错误信息记录到日志                    
			error_log('['.date('Y-m-d h:i:s').'] [message]'.$error['message'].'[file]'.$error['file'].'[line]'.$error['line']."\n\r", 3, RUNTIME_LOGS_PATH.DIR_SEP.APP_PATH.DIR_SEP.'fatal_error_'.date('Y-m-d').'.log');   
			$error = array();
			$error['message'] = L('_CML_ERROR_');
		}

		header('HTTP/1.1 500 Internal Server Error');
		require C('TMPL_EXCEPTION');
	}
    
	/**
	 * 自动加载系统类库
	 *
	 */
	public static function autoloadLib($className)
	{
		if($className == 'CmlModel' || $className == 'CmlDebug' || $className == 'CmlView') {
			//载入系统核心类   
			import($className, CML_LIB_BASE_PATH);	        
		} else if(substr($className, 0, 5) == 'Cache') { 
			//载入缓存类            
			import($className, CML_LIB_DRIVER_PATH.DIR_SEP.'Cache');                        
		} else if(substr($className, 0, 2) == 'Db') {  
			//载入db类
			import($className, CML_LIB_DRIVER_PATH.DIR_SEP.'Db');                     
		}       
	}

	/**
	 * 自动加载项目文件
	 *
	 * @param $className
	 */
	public static function autoloadLibAppFile($className)
	{
		if(substr($className, -10) == 'Controller') {
			$controllerDir = is_file(APP_CONTROLLER_PATH.DIR_SEP.$className.'.class.php') ? APP_CONTROLLER_PATH : APP_CONTROLLER_ROOT_PATH;
			import($className, $controllerDir);
		} else if(substr($className, -5) == 'Model') {
			$modelDir = is_file(APP_MODEL_PATH.DIR_SEP.$className.'.class.php') ? APP_MODEL_PATH : APP_MODEL_ROOT_PATH;
			import($className, $modelDir);
		}
	}

	/**
	 * 自动加载扩展
	 *
	 * @param $className
	 */
	public static function autoloadExtend($className)
	{
		import($className, CML_EXTEND_PATH);
	}

	/**
	 * 执行插件
	 *
	 * @param string $hook 插件钩子名称
	 *
	 * @return void
	 */
	public static function hook($hook)
	{
		$hookRun = C("PLUGINS.{$hook}");
		if(!is_null($hookRun)) {
			foreach($hookRun as $key => $val) {
				//为了性能着想不判断插件文件是否存在，插件文件不存在时直接报错，这种情况直接把不存在的插件配置去除即可
				import($key, APP_PLUGIN_PATH, 'Plugin.class.php');
				$pluginName = "{$key}Plugin";
				$plugin = new $pluginName;
				$plugin->$val();
			}
		}
		return;
	}
}