using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

using Model;

namespace LoginFrame
{
    public partial class FrmAddNews : Form
    {
        public FrmAddNews()
        {
            InitializeComponent();
        }

        private News news = new News();
        private void btn_newsPhoto_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            try
            {
                openFileDialog1.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.MyComputer);
                openFileDialog1.Filter = "ͼƬ*.jpg;*.bmp;*.gif,*.png|*.jpg;*.bmp;*.gif;*.png";
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    this.txt_newsPhoto.Text = openFileDialog1.FileName;
                    pictureBox_newsPhoto.Image = Image.FromFile(txt_newsPhoto.Text);
                    pictureBox_newsPhoto.SizeMode = PictureBoxSizeMode.StretchImage;
                    FileStream fs = new FileStream(openFileDialog1.FileName, FileMode.Open, FileAccess.Read);
                    BinaryReader bw = new BinaryReader(fs);
                    news.newsPhoto = bw.ReadBytes((int)fs.Length);
                }
            }
            catch
            {
                MessageBox.Show("ѡȷͼƬʽ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
        }

        private void Btn_Add_Click(object sender, EventArgs e)
        {
            if (this.txt_newsTitle.Text == "")
            {
                MessageBox.Show("ű벻Ϊ!");
                this.txt_newsTitle.Focus();
                return;
            }
            news.newsTitle = this.txt_newsTitle.Text; //ű
            if (this.txt_newsContent.Text == "")
            {
                MessageBox.Show("벻Ϊ!");
                this.txt_newsContent.Focus();
                return;
            }
            news.newsContent = this.txt_newsContent.Text; //
            news.newsDate = this.dtp_newsDate.Value;
            if (BLL.bllNews.AddNews(news))
                MessageBox.Show("Ϣӳɹ!");
            else
                MessageBox.Show("Ϣʧ!");
            this.Close(); 
        }

        private void FrmAddNews_Load(object sender, EventArgs e)
        {
            pictureBox_newsPhoto.Image = Image.FromFile("pic/NoImage.jpg");
            pictureBox_newsPhoto.SizeMode = PictureBoxSizeMode.StretchImage;
            FileStream newsPhoto_fs = new FileStream("pic/NoImage.jpg", FileMode.Open, FileAccess.Read);
            BinaryReader newsPhoto_bw = new BinaryReader(newsPhoto_fs);
            news.newsPhoto = newsPhoto_bw.ReadBytes((int)newsPhoto_fs.Length);
        }
    }
}
