using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;
using Model;

namespace LoginFrame
{
    public partial class FrmEditClassInfo : Form
    {
        public FrmEditClassInfo(String classNumber,FrmQueryClassInfo frmQueryClassInfo)
        {
            InitializeComponent();
            this.classNumber = classNumber;
            this.frmQueryClassInfo = frmQueryClassInfo;
        }
        private ClassInfo classInfo;
        private String classNumber;
        private FrmQueryClassInfo frmQueryClassInfo;
        private void Btn_Update_Click(object sender, EventArgs e)
        { 
            if (this.txt_className.Text == "")
            {
                MessageBox.Show("༶벻Ϊ!");
                this.txt_className.Focus();
                return;
            }
            classInfo.className = this.txt_className.Text; //༶
            classInfo.classSpecialFieldNumber = this.cb_classSpecialFieldNumber.SelectedValue.ToString(); //רҵ
            classInfo.classBirthDate = this.dtp_classBirthDate.Value;
            classInfo.classTeacherCharge = this.txt_classTeacherCharge.Text;  //
            classInfo.classTelephone = this.txt_classTelephone.Text;  //ϵ绰
            classInfo.classMemo = this.txt_classMemo.Text;  //Ϣ
            if (BLL.bllClassInfo.EditClassInfo(classInfo))
                MessageBox.Show("༶Ϣ³ɹ!");
            else
                MessageBox.Show("༶Ϣʧ!");
            frmQueryClassInfo.BindData("refresh");
            this.Close(); 
        }

        private void FrmEditClassInfo_Load(object sender, EventArgs e)
        {
            classInfo = BLL.bllClassInfo.getSomeClassInfo(classNumber);
            //ѯеרҵϢ
            DataSet specialFieldInfoDs = BLL.bllSpecialFieldInfo.getAllSpecialFieldInfo();
            this.cb_classSpecialFieldNumber.DataSource = specialFieldInfoDs.Tables[0];
            this.cb_classSpecialFieldNumber.DisplayMember = "specialFieldName";
            this.cb_classSpecialFieldNumber.ValueMember = "specialFieldNumber";
            this.cb_classSpecialFieldNumber.SelectedValue = classInfo.classSpecialFieldNumber.ToString();
            this.txt_classNumber.ReadOnly = true;
            this.txt_classNumber.Text = classInfo.classNumber;
            this.txt_className.Text = classInfo.className;
            this.dtp_classBirthDate.Value = classInfo.classBirthDate;
            this.txt_classTeacherCharge.Text = classInfo.classTeacherCharge;
            this.txt_classTelephone.Text = classInfo.classTelephone;
            this.txt_classMemo.Text = classInfo.classMemo;
        }
    }
}
