using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;
using Model;

namespace LoginFrame
{
    public partial class FrmEditNews : Form
    {
        public FrmEditNews(int newsId,FrmQueryNews frmQueryNews)
        {
            InitializeComponent();
            this.newsId = newsId;
            this.frmQueryNews = frmQueryNews;
        }
        private News news;
        private int newsId;
        private FrmQueryNews frmQueryNews;
        private void Btn_Update_Click(object sender, EventArgs e)
        { 
            if (this.txt_newsTitle.Text == "")
            {
                MessageBox.Show("ű벻Ϊ!");
                this.txt_newsTitle.Focus();
                return;
            }
            news.newsTitle = this.txt_newsTitle.Text; //ű
            if (this.txt_newsContent.Text == "")
            {
                MessageBox.Show("벻Ϊ!");
                this.txt_newsContent.Focus();
                return;
            }
            news.newsContent = this.txt_newsContent.Text; //
            news.newsDate = this.dtp_newsDate.Value;
            if (BLL.bllNews.EditNews(news))
                MessageBox.Show("Ϣ³ɹ!");
            else
                MessageBox.Show("Ϣʧ!");
            frmQueryNews.BindData("refresh");
            this.Close(); 
        }

        private void btn_newsPhoto_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            try
            {
                openFileDialog1.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.MyComputer);
                openFileDialog1.Filter = "ͼƬ*.jpg;*.bmp;*.gif,*.png|*.jpg;*.bmp;*.gif;*.png";
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    this.txt_newsPhoto.Text = openFileDialog1.FileName;
                    pictureBox_newsPhoto.Image = Image.FromFile(txt_newsPhoto.Text);
                    pictureBox_newsPhoto.SizeMode = PictureBoxSizeMode.StretchImage;
                    FileStream fs = new FileStream(openFileDialog1.FileName, FileMode.Open, FileAccess.Read);
                    BinaryReader bw = new BinaryReader(fs);
                    news.newsPhoto = bw.ReadBytes((int)fs.Length);
                }
            }
            catch
            {
                MessageBox.Show("ѡȷͼƬʽ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
        }

        private void FrmEditNews_Load(object sender, EventArgs e)
        {
            news = BLL.bllNews.getSomeNews(newsId);
            this.txt_newsId.ReadOnly = true;
            this.txt_newsId.Text = news.newsId.ToString();
            this.txt_newsTitle.Text = news.newsTitle;
            this.txt_newsContent.Text = news.newsContent;
            this.dtp_newsDate.Value = news.newsDate;
            byte[] newsPhoto = (byte[])(news.newsPhoto);
            MemoryStream ms_newsPhoto = new MemoryStream(newsPhoto);
            pictureBox_newsPhoto.Image = Image.FromStream(ms_newsPhoto);
        }
    }
}
