using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;
using Model;

namespace LoginFrame
{
    public partial class FrmEditScoreInfo : Form
    {
        public FrmEditScoreInfo(int scoreId,FrmQueryScoreInfo frmQueryScoreInfo)
        {
            InitializeComponent();
            this.scoreId = scoreId;
            this.frmQueryScoreInfo = frmQueryScoreInfo;
        }
        private ScoreInfo scoreInfo;
        private int scoreId;
        private FrmQueryScoreInfo frmQueryScoreInfo;
        private void Btn_Update_Click(object sender, EventArgs e)
        { 
            scoreInfo.studentNumber = this.cb_studentNumber.SelectedValue.ToString(); //ѧ
            scoreInfo.courseNumber = this.cb_courseNumber.SelectedValue.ToString(); //γ̶
            try
            {
                scoreInfo.scoreValue = Convert.ToSingle(this.txt_scoreValue.Text);  //ɼ÷
            }
            catch
            {
                MessageBox.Show("ɼ÷ȷĸʽ!");
                this.txt_scoreValue.SelectAll();
                this.txt_scoreValue.Focus();
                return;
            }
            scoreInfo.studentEvaluate = this.txt_studentEvaluate.Text;  //ѧ
            if (BLL.bllScoreInfo.EditScoreInfo(scoreInfo))
                MessageBox.Show("ɼϢ³ɹ!");
            else
                MessageBox.Show("ɼϢʧ!");
            frmQueryScoreInfo.BindData("refresh");
            this.Close(); 
        }

        private void FrmEditScoreInfo_Load(object sender, EventArgs e)
        {
            scoreInfo = BLL.bllScoreInfo.getSomeScoreInfo(scoreId);
            //ѯеѧϢ
            DataSet student_QQ287307421Ds = BLL.bllStudent_QQ287307421.getAllStudent_QQ287307421();
            this.cb_studentNumber.DataSource = student_QQ287307421Ds.Tables[0];
            this.cb_studentNumber.DisplayMember = "studentName";
            this.cb_studentNumber.ValueMember = "studentNumber";
            this.cb_studentNumber.SelectedValue = scoreInfo.studentNumber.ToString();
            //ѯеĿγϢ
            DataSet courseInfo_QQ254540457Ds = BLL.bllCourseInfo_QQ254540457.getAllCourseInfo_QQ254540457();
            this.cb_courseNumber.DataSource = courseInfo_QQ254540457Ds.Tables[0];
            this.cb_courseNumber.DisplayMember = "courseName";
            this.cb_courseNumber.ValueMember = "courseNumber";
            this.cb_courseNumber.SelectedValue = scoreInfo.courseNumber.ToString();
            this.txt_scoreId.ReadOnly = true;
            this.txt_scoreId.Text = scoreInfo.scoreId.ToString();
            this.txt_scoreValue.Text = scoreInfo.scoreValue.ToString();
            this.txt_studentEvaluate.Text = scoreInfo.studentEvaluate;
        }
    }
}
