using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;
using Model;

namespace LoginFrame
{
    public partial class FrmEditSpecialFieldInfo : Form
    {
        public FrmEditSpecialFieldInfo(String specialFieldNumber,FrmQuerySpecialFieldInfo frmQuerySpecialFieldInfo)
        {
            InitializeComponent();
            this.specialFieldNumber = specialFieldNumber;
            this.frmQuerySpecialFieldInfo = frmQuerySpecialFieldInfo;
        }
        private SpecialFieldInfo specialFieldInfo;
        private String specialFieldNumber;
        private FrmQuerySpecialFieldInfo frmQuerySpecialFieldInfo;
        private void Btn_Update_Click(object sender, EventArgs e)
        { 
            if (this.txt_specialFieldName.Text == "")
            {
                MessageBox.Show("רҵ벻Ϊ!");
                this.txt_specialFieldName.Focus();
                return;
            }
            specialFieldInfo.specialFieldName = this.txt_specialFieldName.Text; //רҵ
            specialFieldInfo.specialCollegeNumber = this.cb_specialCollegeNumber.SelectedValue.ToString(); //ѧԺ
            specialFieldInfo.specialBirthDate = this.dtp_specialBirthDate.Value;
            specialFieldInfo.specialMan = this.txt_specialMan.Text;  //ϵ
            specialFieldInfo.specialTelephone = this.txt_specialTelephone.Text;  //ϵ绰
            specialFieldInfo.specialMemo = this.txt_specialMemo.Text;  //Ϣ
            if (BLL.bllSpecialFieldInfo.EditSpecialFieldInfo(specialFieldInfo))
                MessageBox.Show("רҵϢ³ɹ!");
            else
                MessageBox.Show("רҵϢʧ!");
            frmQuerySpecialFieldInfo.BindData("refresh");
            this.Close(); 
        }

        private void FrmEditSpecialFieldInfo_Load(object sender, EventArgs e)
        {
            specialFieldInfo = BLL.bllSpecialFieldInfo.getSomeSpecialFieldInfo(specialFieldNumber);
            //ѯеѧԺϢ
            DataSet collegeInfoDs = BLL.bllCollegeInfo.getAllCollegeInfo();
            this.cb_specialCollegeNumber.DataSource = collegeInfoDs.Tables[0];
            this.cb_specialCollegeNumber.DisplayMember = "collegeName";
            this.cb_specialCollegeNumber.ValueMember = "collegeNumber";
            this.cb_specialCollegeNumber.SelectedValue = specialFieldInfo.specialCollegeNumber.ToString();
            this.txt_specialFieldNumber.ReadOnly = true;
            this.txt_specialFieldNumber.Text = specialFieldInfo.specialFieldNumber;
            this.txt_specialFieldName.Text = specialFieldInfo.specialFieldName;
            this.dtp_specialBirthDate.Value = specialFieldInfo.specialBirthDate;
            this.txt_specialMan.Text = specialFieldInfo.specialMan;
            this.txt_specialTelephone.Text = specialFieldInfo.specialTelephone;
            this.txt_specialMemo.Text = specialFieldInfo.specialMemo;
        }
    }
}
