using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LoginFrame
{
    public partial class FrmQueryClassInfo : Form
    {
        public FrmQueryClassInfo()
        {
            InitializeComponent();
        }
        private void dtp_classBirthDate_ValueChanged(object sender, EventArgs e)
        {
            this.txt_classBirthDate.Text = this.dtp_classBirthDate.Value.ToShortDateString();
        } 
        private void txt_classBirthDate_DoubleClick(object sender, EventArgs e)
        {
            this.txt_classBirthDate.Text = "";
        }

        private void Btn_Query_Click(object sender, EventArgs e)
        {
            string sqlstr = " where 1=1 ";
            if (this.txt_classNumber.Text != "")
            {
                sqlstr += "  and classNumber like '%" + this.txt_classNumber.Text + "%'";
            }
            if (this.txt_className.Text != "")
            {
                sqlstr += "  and className like '%" + this.txt_className.Text + "%'";
            }
            if (this.cb_classSpecialFieldNumber.SelectedValue.ToString() != "")
            {
                sqlstr += "  and classSpecialFieldNumber='" + this.cb_classSpecialFieldNumber.SelectedValue.ToString() + "'"; 
            }
            if (this.txt_classBirthDate.Text != "")
            {
                sqlstr += "  and convert(char(11),classBirthDate,20) ='" + this.txt_classBirthDate.Text + "'"; 
            }
            HWhere.Text = sqlstr;
            BindData("");
        }
        public void BindData(string strClass)
        {
            int DataCount = 0;
            int NowPage = 1;
            int AllPage = 0;
            int PageSize = Convert.ToInt32(HPageSize.Text);
            switch (strClass)
            {
                case "next":
                    NowPage = Convert.ToInt32(HNowPage.Text) + 1;
                    break;
                case "up":
                    NowPage = Convert.ToInt32(HNowPage.Text) - 1;
                    break;
                case "end":
                    NowPage = Convert.ToInt32(HAllPage.Text);
                    break;
                case "refresh":
                    NowPage = Convert.ToInt32(HNowPage.Text);
                    break;
                default:
                    break;
            }
            DataTable dsLog = BLL.bllClassInfo.GetClassInfo(NowPage, PageSize, out AllPage, out DataCount, HWhere.Text);
            if (dsLog.Rows.Count == 0 || AllPage == 1)
            {
                LBEnd.Enabled = false;
                LBHome.Enabled = false;
                LBNext.Enabled = false;
                LBUp.Enabled = false;
            }
            else if (NowPage == 1)
            {
                LBHome.Enabled = false;
                LBUp.Enabled = false;
                LBNext.Enabled = true;
                LBEnd.Enabled = true;
            }
            else if (NowPage == AllPage)
            {
                LBHome.Enabled = true;
                LBUp.Enabled = true;
                LBNext.Enabled = false;
                LBEnd.Enabled = false;
            }
            else
            {
                LBEnd.Enabled = true;
                LBHome.Enabled = true;
                LBNext.Enabled = true;
                LBUp.Enabled = true;
            }
            this.dataGridView_ClassInfo.DataSource = dsLog.DefaultView; 
            PageMes.Text = string.Format("[ÿҳ{0} {1}ҳ{2}ҳ   {3}]", PageSize, NowPage, AllPage, DataCount);
            HNowPage.Text = Convert.ToString(NowPage++);
            HAllPage.Text = AllPage.ToString();

            if (dsLog.Rows.Count > 0)
            {
                this.Btn_Update.Enabled = true;
                this.Btn_Del.Enabled = true;
            }
            else
            {
                this.Btn_Update.Enabled = false;
                this.Btn_Del.Enabled = false;
            }
        }

        /*ʼش*/
        private void FrmQueryClassInfo_Load(object sender, EventArgs e)
        {
            //ѯеרҵϢ
            DataSet specialFieldInfoDs = BLL.bllSpecialFieldInfo.getAllSpecialFieldInfo();
            DataTable newDataTable_classSpecialFieldNumber = new DataTable();
            newDataTable_classSpecialFieldNumber.Columns.Add("specialFieldNumber");
            newDataTable_classSpecialFieldNumber.Columns.Add("specialFieldName");

            foreach (DataRow oldDR in specialFieldInfoDs.Tables[0].Rows)
            {
                DataRow newDR = newDataTable_classSpecialFieldNumber.NewRow();
                newDR[0] = oldDR["specialFieldNumber"].ToString();
                newDR[1] = oldDR["specialFieldName"].ToString();
                newDataTable_classSpecialFieldNumber.Rows.InsertAt(newDR, newDataTable_classSpecialFieldNumber.Rows.Count);
            }
            // Add your 'Select an item' option at the top  
            DataRow dr_classSpecialFieldNumber = newDataTable_classSpecialFieldNumber.NewRow();
            dr_classSpecialFieldNumber[0] = "";
            dr_classSpecialFieldNumber[1] = "ѡ";
            newDataTable_classSpecialFieldNumber.Rows.InsertAt(dr_classSpecialFieldNumber, 0);
            this.cb_classSpecialFieldNumber.DataSource = newDataTable_classSpecialFieldNumber;
            this.cb_classSpecialFieldNumber.DisplayMember = "specialFieldName";
            this.cb_classSpecialFieldNumber.ValueMember = "specialFieldNumber";
        }
        private void LBHome_Click(object sender, EventArgs e)
        {
            BindData("");
        }
        private void LBUp_Click(object sender, EventArgs e)
        {
            BindData("up");
        }
        private void LBNext_Click(object sender, EventArgs e)
        {
            BindData("next");
        }
        private void LBEnd_Click(object sender, EventArgs e)
        {
            BindData("end");
        }

        private void Btn_Update_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_ClassInfo.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                String classNumber = this.dataGridView_ClassInfo.CurrentRow.Cells[0].Value.ToString();
                FrmEditClassInfo frmEditClassInfo = new FrmEditClassInfo(classNumber,this); 
                frmEditClassInfo.ShowDialog(); 
            }
        }

        private void Btn_Del_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_ClassInfo.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                if ( MessageBox.Show("ȷɾ?", "ɾʾ", MessageBoxButtons.OKCancel) == DialogResult.OK)
                {
                    String classNumber = this.dataGridView_ClassInfo.CurrentRow.Cells[0].Value.ToString();
                    if (BLL.bllClassInfo.DelClassInfo(classNumber))
                        MessageBox.Show("༶Ϣɾɹ!");
                    else
                        MessageBox.Show("༶Ϣɾʧ!");
                    BindData("refresh");
                }
            }
        } 
    }
}
