using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LoginFrame
{
    public partial class FrmQueryCourseInfo_QQ254540457 : Form
    {
        public FrmQueryCourseInfo_QQ254540457()
        {
            InitializeComponent();
        }

        private void Btn_Query_Click(object sender, EventArgs e)
        {
            string sqlstr = " where 1=1 ";
            if (this.txt_courseNumber.Text != "")
            {
                sqlstr += "  and courseNumber like '%" + this.txt_courseNumber.Text + "%'";
            }
            if (this.txt_courseName.Text != "")
            {
                sqlstr += "  and courseName like '%" + this.txt_courseName.Text + "%'";
            }
            if (this.cb_courseTeacher.SelectedValue.ToString() != "")
            {
                sqlstr += "  and courseTeacher='" + this.cb_courseTeacher.SelectedValue.ToString() + "'"; 
            }
            HWhere.Text = sqlstr;
            BindData("");
        }
        public void BindData(string strClass)
        {
            int DataCount = 0;
            int NowPage = 1;
            int AllPage = 0;
            int PageSize = Convert.ToInt32(HPageSize.Text);
            switch (strClass)
            {
                case "next":
                    NowPage = Convert.ToInt32(HNowPage.Text) + 1;
                    break;
                case "up":
                    NowPage = Convert.ToInt32(HNowPage.Text) - 1;
                    break;
                case "end":
                    NowPage = Convert.ToInt32(HAllPage.Text);
                    break;
                case "refresh":
                    NowPage = Convert.ToInt32(HNowPage.Text);
                    break;
                default:
                    break;
            }
            DataTable dsLog = BLL.bllCourseInfo_QQ254540457.GetCourseInfo_QQ254540457(NowPage, PageSize, out AllPage, out DataCount, HWhere.Text);
            if (dsLog.Rows.Count == 0 || AllPage == 1)
            {
                LBEnd.Enabled = false;
                LBHome.Enabled = false;
                LBNext.Enabled = false;
                LBUp.Enabled = false;
            }
            else if (NowPage == 1)
            {
                LBHome.Enabled = false;
                LBUp.Enabled = false;
                LBNext.Enabled = true;
                LBEnd.Enabled = true;
            }
            else if (NowPage == AllPage)
            {
                LBHome.Enabled = true;
                LBUp.Enabled = true;
                LBNext.Enabled = false;
                LBEnd.Enabled = false;
            }
            else
            {
                LBEnd.Enabled = true;
                LBHome.Enabled = true;
                LBNext.Enabled = true;
                LBUp.Enabled = true;
            }
            this.dataGridView_CourseInfo_QQ254540457.DataSource = dsLog.DefaultView; 
            PageMes.Text = string.Format("[ÿҳ{0} {1}ҳ{2}ҳ   {3}]", PageSize, NowPage, AllPage, DataCount);
            HNowPage.Text = Convert.ToString(NowPage++);
            HAllPage.Text = AllPage.ToString();

            if (dsLog.Rows.Count > 0)
            {
                this.Btn_Update.Enabled = true;
                this.Btn_Del.Enabled = true;
            }
            else
            {
                this.Btn_Update.Enabled = false;
                this.Btn_Del.Enabled = false;
            }
        }

        /*ʼش*/
        private void FrmQueryCourseInfo_QQ254540457_Load(object sender, EventArgs e)
        {
            //ѯеĽʦϢ
            DataSet teacher_QQ287307421Ds = BLL.bllTeacher_QQ287307421.getAllTeacher_QQ287307421();
            DataTable newDataTable_courseTeacher = new DataTable();
            newDataTable_courseTeacher.Columns.Add("teacherNumber");
            newDataTable_courseTeacher.Columns.Add("teacherName");

            foreach (DataRow oldDR in teacher_QQ287307421Ds.Tables[0].Rows)
            {
                DataRow newDR = newDataTable_courseTeacher.NewRow();
                newDR[0] = oldDR["teacherNumber"].ToString();
                newDR[1] = oldDR["teacherName"].ToString();
                newDataTable_courseTeacher.Rows.InsertAt(newDR, newDataTable_courseTeacher.Rows.Count);
            }
            // Add your 'Select an item' option at the top  
            DataRow dr_courseTeacher = newDataTable_courseTeacher.NewRow();
            dr_courseTeacher[0] = "";
            dr_courseTeacher[1] = "ѡ";
            newDataTable_courseTeacher.Rows.InsertAt(dr_courseTeacher, 0);
            this.cb_courseTeacher.DataSource = newDataTable_courseTeacher;
            this.cb_courseTeacher.DisplayMember = "teacherName";
            this.cb_courseTeacher.ValueMember = "teacherNumber";
        }
        private void LBHome_Click(object sender, EventArgs e)
        {
            BindData("");
        }
        private void LBUp_Click(object sender, EventArgs e)
        {
            BindData("up");
        }
        private void LBNext_Click(object sender, EventArgs e)
        {
            BindData("next");
        }
        private void LBEnd_Click(object sender, EventArgs e)
        {
            BindData("end");
        }

        private void Btn_Update_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_CourseInfo_QQ254540457.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                String courseNumber = this.dataGridView_CourseInfo_QQ254540457.CurrentRow.Cells[0].Value.ToString();
                FrmEditCourseInfo_QQ254540457 frmEditCourseInfo_QQ254540457 = new FrmEditCourseInfo_QQ254540457(courseNumber,this); 
                frmEditCourseInfo_QQ254540457.ShowDialog(); 
            }
        }

        private void Btn_Del_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_CourseInfo_QQ254540457.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                if ( MessageBox.Show("ȷɾ?", "ɾʾ", MessageBoxButtons.OKCancel) == DialogResult.OK)
                {
                    String courseNumber = this.dataGridView_CourseInfo_QQ254540457.CurrentRow.Cells[0].Value.ToString();
                    if (BLL.bllCourseInfo_QQ254540457.DelCourseInfo_QQ254540457(courseNumber))
                        MessageBox.Show("γϢɾɹ!");
                    else
                        MessageBox.Show("γϢɾʧ!");
                    BindData("refresh");
                }
            }
        } 
    }
}
