using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LoginFrame
{
    public partial class FrmQueryScoreInfo : Form
    {
        public FrmQueryScoreInfo()
        {
            InitializeComponent();
        }

        private void Btn_Query_Click(object sender, EventArgs e)
        {
            string sqlstr = " where 1=1 ";
            if (this.cb_studentNumber.SelectedValue.ToString() != "")
            {
                sqlstr += "  and studentNumber='" + this.cb_studentNumber.SelectedValue.ToString() + "'"; 
            }
            if (this.cb_courseNumber.SelectedValue.ToString() != "")
            {
                sqlstr += "  and courseNumber='" + this.cb_courseNumber.SelectedValue.ToString() + "'"; 
            }
            HWhere.Text = sqlstr;
            BindData("");
        }
        public void BindData(string strClass)
        {
            int DataCount = 0;
            int NowPage = 1;
            int AllPage = 0;
            int PageSize = Convert.ToInt32(HPageSize.Text);
            switch (strClass)
            {
                case "next":
                    NowPage = Convert.ToInt32(HNowPage.Text) + 1;
                    break;
                case "up":
                    NowPage = Convert.ToInt32(HNowPage.Text) - 1;
                    break;
                case "end":
                    NowPage = Convert.ToInt32(HAllPage.Text);
                    break;
                case "refresh":
                    NowPage = Convert.ToInt32(HNowPage.Text);
                    break;
                default:
                    break;
            }
            DataTable dsLog = BLL.bllScoreInfo.GetScoreInfo(NowPage, PageSize, out AllPage, out DataCount, HWhere.Text);
            if (dsLog.Rows.Count == 0 || AllPage == 1)
            {
                LBEnd.Enabled = false;
                LBHome.Enabled = false;
                LBNext.Enabled = false;
                LBUp.Enabled = false;
            }
            else if (NowPage == 1)
            {
                LBHome.Enabled = false;
                LBUp.Enabled = false;
                LBNext.Enabled = true;
                LBEnd.Enabled = true;
            }
            else if (NowPage == AllPage)
            {
                LBHome.Enabled = true;
                LBUp.Enabled = true;
                LBNext.Enabled = false;
                LBEnd.Enabled = false;
            }
            else
            {
                LBEnd.Enabled = true;
                LBHome.Enabled = true;
                LBNext.Enabled = true;
                LBUp.Enabled = true;
            }
            this.dataGridView_ScoreInfo.DataSource = dsLog.DefaultView; 
            PageMes.Text = string.Format("[ÿҳ{0} {1}ҳ{2}ҳ   {3}]", PageSize, NowPage, AllPage, DataCount);
            HNowPage.Text = Convert.ToString(NowPage++);
            HAllPage.Text = AllPage.ToString();

            if (dsLog.Rows.Count > 0)
            {
                this.Btn_Update.Enabled = true;
                this.Btn_Del.Enabled = true;
            }
            else
            {
                this.Btn_Update.Enabled = false;
                this.Btn_Del.Enabled = false;
            }
        }

        /*ʼش*/
        private void FrmQueryScoreInfo_Load(object sender, EventArgs e)
        {
            //ѯеѧϢ
            DataSet student_QQ287307421Ds = BLL.bllStudent_QQ287307421.getAllStudent_QQ287307421();
            DataTable newDataTable_studentNumber = new DataTable();
            newDataTable_studentNumber.Columns.Add("studentNumber");
            newDataTable_studentNumber.Columns.Add("studentName");

            foreach (DataRow oldDR in student_QQ287307421Ds.Tables[0].Rows)
            {
                DataRow newDR = newDataTable_studentNumber.NewRow();
                newDR[0] = oldDR["studentNumber"].ToString();
                newDR[1] = oldDR["studentName"].ToString();
                newDataTable_studentNumber.Rows.InsertAt(newDR, newDataTable_studentNumber.Rows.Count);
            }
            // Add your 'Select an item' option at the top  
            DataRow dr_studentNumber = newDataTable_studentNumber.NewRow();
            dr_studentNumber[0] = "";
            dr_studentNumber[1] = "ѡ";
            newDataTable_studentNumber.Rows.InsertAt(dr_studentNumber, 0);
            this.cb_studentNumber.DataSource = newDataTable_studentNumber;
            this.cb_studentNumber.DisplayMember = "studentName";
            this.cb_studentNumber.ValueMember = "studentNumber";
            //ѯеĿγϢ
            DataSet courseInfo_QQ254540457Ds = BLL.bllCourseInfo_QQ254540457.getAllCourseInfo_QQ254540457();
            DataTable newDataTable_courseNumber = new DataTable();
            newDataTable_courseNumber.Columns.Add("courseNumber");
            newDataTable_courseNumber.Columns.Add("courseName");

            foreach (DataRow oldDR in courseInfo_QQ254540457Ds.Tables[0].Rows)
            {
                DataRow newDR = newDataTable_courseNumber.NewRow();
                newDR[0] = oldDR["courseNumber"].ToString();
                newDR[1] = oldDR["courseName"].ToString();
                newDataTable_courseNumber.Rows.InsertAt(newDR, newDataTable_courseNumber.Rows.Count);
            }
            // Add your 'Select an item' option at the top  
            DataRow dr_courseNumber = newDataTable_courseNumber.NewRow();
            dr_courseNumber[0] = "";
            dr_courseNumber[1] = "ѡ";
            newDataTable_courseNumber.Rows.InsertAt(dr_courseNumber, 0);
            this.cb_courseNumber.DataSource = newDataTable_courseNumber;
            this.cb_courseNumber.DisplayMember = "courseName";
            this.cb_courseNumber.ValueMember = "courseNumber";
        }
        private void LBHome_Click(object sender, EventArgs e)
        {
            BindData("");
        }
        private void LBUp_Click(object sender, EventArgs e)
        {
            BindData("up");
        }
        private void LBNext_Click(object sender, EventArgs e)
        {
            BindData("next");
        }
        private void LBEnd_Click(object sender, EventArgs e)
        {
            BindData("end");
        }

        private void Btn_Update_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_ScoreInfo.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                int scoreId = Convert.ToInt32(this.dataGridView_ScoreInfo.CurrentRow.Cells[0].Value.ToString());
                FrmEditScoreInfo frmEditScoreInfo = new FrmEditScoreInfo(scoreId,this); 
                frmEditScoreInfo.ShowDialog(); 
            }
        }

        private void Btn_Del_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_ScoreInfo.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                if ( MessageBox.Show("ȷɾ?", "ɾʾ", MessageBoxButtons.OKCancel) == DialogResult.OK)
                {
                    String scoreId = this.dataGridView_ScoreInfo.CurrentRow.Cells[0].Value.ToString();
                    if (BLL.bllScoreInfo.DelScoreInfo(scoreId))
                        MessageBox.Show("ɼϢɾɹ!");
                    else
                        MessageBox.Show("ɼϢɾʧ!");
                    BindData("refresh");
                }
            }
        } 
    }
}
