using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LoginFrame
{
    public partial class FrmQuerySpecialFieldInfo : Form
    {
        public FrmQuerySpecialFieldInfo()
        {
            InitializeComponent();
        }
        private void dtp_specialBirthDate_ValueChanged(object sender, EventArgs e)
        {
            this.txt_specialBirthDate.Text = this.dtp_specialBirthDate.Value.ToShortDateString();
        } 
        private void txt_specialBirthDate_DoubleClick(object sender, EventArgs e)
        {
            this.txt_specialBirthDate.Text = "";
        }

        private void Btn_Query_Click(object sender, EventArgs e)
        {
            string sqlstr = " where 1=1 ";
            if (this.txt_specialFieldNumber.Text != "")
            {
                sqlstr += "  and specialFieldNumber like '%" + this.txt_specialFieldNumber.Text + "%'";
            }
            if (this.txt_specialFieldName.Text != "")
            {
                sqlstr += "  and specialFieldName like '%" + this.txt_specialFieldName.Text + "%'";
            }
            if (this.cb_specialCollegeNumber.SelectedValue.ToString() != "")
            {
                sqlstr += "  and specialCollegeNumber='" + this.cb_specialCollegeNumber.SelectedValue.ToString() + "'"; 
            }
            if (this.txt_specialBirthDate.Text != "")
            {
                sqlstr += "  and convert(char(11),specialBirthDate,20) ='" + this.txt_specialBirthDate.Text + "'"; 
            }
            HWhere.Text = sqlstr;
            BindData("");
        }
        public void BindData(string strClass)
        {
            int DataCount = 0;
            int NowPage = 1;
            int AllPage = 0;
            int PageSize = Convert.ToInt32(HPageSize.Text);
            switch (strClass)
            {
                case "next":
                    NowPage = Convert.ToInt32(HNowPage.Text) + 1;
                    break;
                case "up":
                    NowPage = Convert.ToInt32(HNowPage.Text) - 1;
                    break;
                case "end":
                    NowPage = Convert.ToInt32(HAllPage.Text);
                    break;
                case "refresh":
                    NowPage = Convert.ToInt32(HNowPage.Text);
                    break;
                default:
                    break;
            }
            DataTable dsLog = BLL.bllSpecialFieldInfo.GetSpecialFieldInfo(NowPage, PageSize, out AllPage, out DataCount, HWhere.Text);
            if (dsLog.Rows.Count == 0 || AllPage == 1)
            {
                LBEnd.Enabled = false;
                LBHome.Enabled = false;
                LBNext.Enabled = false;
                LBUp.Enabled = false;
            }
            else if (NowPage == 1)
            {
                LBHome.Enabled = false;
                LBUp.Enabled = false;
                LBNext.Enabled = true;
                LBEnd.Enabled = true;
            }
            else if (NowPage == AllPage)
            {
                LBHome.Enabled = true;
                LBUp.Enabled = true;
                LBNext.Enabled = false;
                LBEnd.Enabled = false;
            }
            else
            {
                LBEnd.Enabled = true;
                LBHome.Enabled = true;
                LBNext.Enabled = true;
                LBUp.Enabled = true;
            }
            this.dataGridView_SpecialFieldInfo.DataSource = dsLog.DefaultView; 
            PageMes.Text = string.Format("[ÿҳ{0} {1}ҳ{2}ҳ   {3}]", PageSize, NowPage, AllPage, DataCount);
            HNowPage.Text = Convert.ToString(NowPage++);
            HAllPage.Text = AllPage.ToString();

            if (dsLog.Rows.Count > 0)
            {
                this.Btn_Update.Enabled = true;
                this.Btn_Del.Enabled = true;
            }
            else
            {
                this.Btn_Update.Enabled = false;
                this.Btn_Del.Enabled = false;
            }
        }

        /*ʼش*/
        private void FrmQuerySpecialFieldInfo_Load(object sender, EventArgs e)
        {
            //ѯеѧԺϢ
            DataSet collegeInfoDs = BLL.bllCollegeInfo.getAllCollegeInfo();
            DataTable newDataTable_specialCollegeNumber = new DataTable();
            newDataTable_specialCollegeNumber.Columns.Add("collegeNumber");
            newDataTable_specialCollegeNumber.Columns.Add("collegeName");

            foreach (DataRow oldDR in collegeInfoDs.Tables[0].Rows)
            {
                DataRow newDR = newDataTable_specialCollegeNumber.NewRow();
                newDR[0] = oldDR["collegeNumber"].ToString();
                newDR[1] = oldDR["collegeName"].ToString();
                newDataTable_specialCollegeNumber.Rows.InsertAt(newDR, newDataTable_specialCollegeNumber.Rows.Count);
            }
            // Add your 'Select an item' option at the top  
            DataRow dr_specialCollegeNumber = newDataTable_specialCollegeNumber.NewRow();
            dr_specialCollegeNumber[0] = "";
            dr_specialCollegeNumber[1] = "ѡ";
            newDataTable_specialCollegeNumber.Rows.InsertAt(dr_specialCollegeNumber, 0);
            this.cb_specialCollegeNumber.DataSource = newDataTable_specialCollegeNumber;
            this.cb_specialCollegeNumber.DisplayMember = "collegeName";
            this.cb_specialCollegeNumber.ValueMember = "collegeNumber";
        }
        private void LBHome_Click(object sender, EventArgs e)
        {
            BindData("");
        }
        private void LBUp_Click(object sender, EventArgs e)
        {
            BindData("up");
        }
        private void LBNext_Click(object sender, EventArgs e)
        {
            BindData("next");
        }
        private void LBEnd_Click(object sender, EventArgs e)
        {
            BindData("end");
        }

        private void Btn_Update_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_SpecialFieldInfo.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                String specialFieldNumber = this.dataGridView_SpecialFieldInfo.CurrentRow.Cells[0].Value.ToString();
                FrmEditSpecialFieldInfo frmEditSpecialFieldInfo = new FrmEditSpecialFieldInfo(specialFieldNumber,this); 
                frmEditSpecialFieldInfo.ShowDialog(); 
            }
        }

        private void Btn_Del_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_SpecialFieldInfo.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                if ( MessageBox.Show("ȷɾ?", "ɾʾ", MessageBoxButtons.OKCancel) == DialogResult.OK)
                {
                    String specialFieldNumber = this.dataGridView_SpecialFieldInfo.CurrentRow.Cells[0].Value.ToString();
                    if (BLL.bllSpecialFieldInfo.DelSpecialFieldInfo(specialFieldNumber))
                        MessageBox.Show("רҵϢɾɹ!");
                    else
                        MessageBox.Show("רҵϢɾʧ!");
                    BindData("refresh");
                }
            }
        } 
    }
}
